/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    private static final Logger e = Logger.getInstance(ClassObjectRenderer.class);

    public ClassObjectRenderer(NodeRendererSettings nodeRendererSettings) {
        super(nodeRendererSettings, "Class", null, null);
        this.setClassName("java.lang.Class");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(final EvaluationContextImpl evaluationContextImpl, final ValueDescriptorImpl valueDescriptorImpl) {
        return new JavaValue.JavaFullValueEvaluator(DebuggerBundle.message((String)"message.node.navigate", (Object[])new Object[0]), evaluationContextImpl){

            @Override
            public void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback xFullValueEvaluationCallback) {
                Value value;
                ClassType classType;
                Method method;
                if (xFullValueEvaluationCallback == null) {
                    1.b(0);
                }
                if ((method = (classType = (ClassType)(value = valueDescriptorImpl.getValue()).type()).concreteMethodByName("getName", "()Ljava/lang/String;")) != null) {
                    try {
                        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
                        Value value2 = debugProcessImpl.invokeMethod((EvaluationContext)evaluationContextImpl, (ObjectReference)value, method, Collections.emptyList());
                        if (value2 instanceof StringReference) {
                            xFullValueEvaluationCallback.evaluated("");
                            String string = ((StringReference)value2).value();
                            ApplicationManager.getApplication().runReadAction(() -> {
                                PsiClass psiClass = DebuggerUtils.findClass((String)string, (Project)valueDescriptorImpl.getProject(), (GlobalSearchScope)debugProcessImpl.getSearchScope());
                                if (psiClass != null) {
                                    DebuggerUIUtil.invokeLater(() -> psiClass.navigate(true));
                                }
                            });
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        e.info("Exception while getting type name", (Throwable)evaluateException);
                    }
                }
            }

            public boolean isShowValuePopup() {
                return false;
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/ClassObjectRenderer$1", "evaluate"));
            }
        };
    }
}

