/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompoundTypeRenderer
extends CompoundNodeRenderer {
    @NonNls
    public static final String UNIQUE_ID = "CompoundTypeRenderer";
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer");
    private static final AutoToStringRenderer d = new AutoToStringRenderer();

    public CompoundTypeRenderer(NodeRendererSettings nodeRendererSettings, String string, ValueLabelRenderer valueLabelRenderer, ChildrenRenderer childrenRenderer) {
        super(nodeRendererSettings, string, valueLabelRenderer, childrenRenderer);
        this.myProperties.setClassName("java.lang.Object");
        LOG.assertTrue(valueLabelRenderer == null || valueLabelRenderer instanceof TypeRenderer);
        LOG.assertTrue(childrenRenderer == null || childrenRenderer instanceof TypeRenderer);
    }

    @Override
    public void setLabelRenderer(ValueLabelRenderer valueLabelRenderer) {
        ValueLabelRenderer valueLabelRenderer2 = this.getLabelRenderer();
        super.setLabelRenderer(this.isBaseRenderer(valueLabelRenderer) ? null : valueLabelRenderer);
        ValueLabelRenderer valueLabelRenderer3 = this.getLabelRenderer();
        if (valueLabelRenderer2 != valueLabelRenderer3 && valueLabelRenderer3 instanceof TypeRenderer) {
            ((TypeRenderer)((Object)valueLabelRenderer3)).setClassName(this.getClassName());
        }
    }

    @Override
    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        ChildrenRenderer childrenRenderer2 = this.getChildrenRenderer();
        super.setChildrenRenderer(this.isBaseRenderer(childrenRenderer) ? null : childrenRenderer);
        ChildrenRenderer childrenRenderer3 = this.getChildrenRenderer();
        if (childrenRenderer2 != childrenRenderer3 && childrenRenderer3 instanceof TypeRenderer) {
            ((TypeRenderer)((Object)childrenRenderer3)).setClassName(this.getClassName());
        }
    }

    @Override
    public ChildrenRenderer getChildrenRenderer() {
        ChildrenRenderer childrenRenderer = super.getChildrenRenderer();
        return childrenRenderer != null ? childrenRenderer : this.b();
    }

    private NodeRenderer b() {
        String string = this.getClassName();
        if (TypeConversionUtil.isPrimitive((String)string)) {
            return this.myRendererSettings.getPrimitiveRenderer();
        }
        return string.endsWith("]") ? this.myRendererSettings.getArrayRenderer() : d;
    }

    @Override
    public ValueLabelRenderer getLabelRenderer() {
        ValueLabelRenderer valueLabelRenderer = super.getLabelRenderer();
        return valueLabelRenderer != null ? valueLabelRenderer : this.b();
    }

    private ChildrenRenderer a() {
        NodeRenderer nodeRenderer = this.b();
        ChildrenRenderer childrenRenderer = super.getChildrenRenderer();
        return childrenRenderer == nodeRenderer ? null : childrenRenderer;
    }

    private ValueLabelRenderer c() {
        NodeRenderer nodeRenderer = this.b();
        ValueLabelRenderer valueLabelRenderer = super.getLabelRenderer();
        return valueLabelRenderer == nodeRenderer ? null : valueLabelRenderer;
    }

    @Override
    public boolean isApplicable(Type type) {
        if (DebuggerUtils.instanceOf((Type)type, (String)this.getClassName())) {
            return super.isApplicable(type);
        }
        return false;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    public void setClassName(@NotNull String string) {
        Renderer renderer;
        if (string == null) {
            CompoundTypeRenderer.b(0);
        }
        this.myProperties.setClassName(string);
        if (this.c() != null && (renderer = super.getLabelRenderer()) instanceof TypeRenderer) {
            ((TypeRenderer)renderer).setClassName(string);
        }
        if (this.a() != null && (renderer = super.getChildrenRenderer()) instanceof TypeRenderer) {
            ((TypeRenderer)renderer).setClassName(string);
        }
    }

    @NotNull
    public String getClassName() {
        String string = this.myProperties.getClassName();
        if (string == null) {
            CompoundTypeRenderer.b(1);
        }
        return string;
    }

    protected final PsiElement getContext(Project project2, DebuggerContext debuggerContext) {
        DebugProcess debugProcess = debuggerContext.getDebugProcess();
        GlobalSearchScope globalSearchScope = debugProcess != null ? debugProcess.getSearchScope() : GlobalSearchScope.allScope((Project)project2);
        return DebuggerUtils.findClass((String)this.getClassName(), (Project)project2, (GlobalSearchScope)globalSearchScope);
    }

    protected final PsiElement getChildValueExpression(String string, DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) {
        Project project2 = debuggerTreeNode.getProject();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        return psiElementFactory.createExpressionFromText(string, this.getContext(project2, debuggerContext));
    }

    public boolean isBaseRenderer(Renderer renderer) {
        return renderer == d || renderer == this.myRendererSettings.getClassRenderer() || renderer == this.myRendererSettings.getPrimitiveRenderer() || renderer == this.myRendererSettings.getArrayRenderer();
    }

    @Override
    public boolean hasOverhead() {
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/tree/render/CompoundTypeRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/tree/render/CompoundTypeRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setClassName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AutoToStringRenderer
    extends ToStringRenderer {
        private AutoToStringRenderer() {
        }

        @Override
        public String getUniqueId() {
            return "AutoToString";
        }

        @Override
        public boolean isApplicable(Type type) {
            return type instanceof ReferenceType;
        }

        @Override
        public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
            ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
            if (toStringRenderer.isEnabled() && toStringRenderer.isApplicable(valueDescriptor.getType())) {
                return toStringRenderer.calcLabel(valueDescriptor, evaluationContext, descriptorLabelListener);
            }
            return nodeRendererSettings.getClassRenderer().calcLabel(valueDescriptor, evaluationContext, descriptorLabelListener);
        }
    }
}

