/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class EnumerationChildrenRenderer
extends TypeRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "EnumerationChildrenRenderer";
    private boolean b;
    private List<ChildInfo> c;
    @NonNls
    public static final String APPEND_DEFAULT_NAME = "AppendDefault";
    @NonNls
    public static final String CHILDREN_EXPRESSION = "ChildrenExpression";
    @NonNls
    public static final String CHILD_NAME = "Name";
    @NonNls
    public static final String CHILD_ONDEMAND = "OnDemand";

    public EnumerationChildrenRenderer() {
        this(new ArrayList<ChildInfo>());
    }

    public EnumerationChildrenRenderer(List<ChildInfo> list2) {
        this.c = list2;
    }

    public void setAppendDefaultChildren(boolean bl2) {
        this.b = bl2;
    }

    public boolean isAppendDefaultChildren() {
        return this.b;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public EnumerationChildrenRenderer clone() {
        return (EnumerationChildrenRenderer)super.clone();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.c.clear();
        this.b = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)APPEND_DEFAULT_NAME));
        List list2 = element.getChildren(CHILDREN_EXPRESSION);
        for (Element element2 : list2) {
            String string = element2.getAttributeValue(CHILD_NAME);
            TextWithImports textWithImports = DebuggerUtils.getInstance().readTextWithImports((Element)element2.getChildren().get(0));
            boolean bl2 = Boolean.parseBoolean(element2.getAttributeValue(CHILD_ONDEMAND));
            this.c.add(new ChildInfo(string, textWithImports, bl2));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.b) {
            JDOMExternalizerUtil.writeField((Element)element, (String)APPEND_DEFAULT_NAME, (String)"true");
        }
        for (ChildInfo childInfo : this.c) {
            Element element2 = new Element(CHILDREN_EXPRESSION);
            element2.setAttribute(CHILD_NAME, childInfo.myName);
            if (childInfo.myOnDemand) {
                element2.setAttribute(CHILD_ONDEMAND, "true");
            }
            element2.addContent(DebuggerUtils.getInstance().writeTextWithImports(childInfo.myExpression));
            element.addContent(element2);
        }
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder childrenBuilder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = childrenBuilder.getNodeManager();
        NodeDescriptorFactory nodeDescriptorFactory = childrenBuilder.getDescriptorManager();
        ArrayList<DebuggerTreeNode> arrayList = new ArrayList<DebuggerTreeNode>();
        int n2 = 0;
        for (ChildInfo childInfo : this.c) {
            UserExpressionData userExpressionData = new UserExpressionData((ValueDescriptorImpl)childrenBuilder.getParentDescriptor(), this.getClassName(), childInfo.myName, childInfo.myExpression);
            userExpressionData.setEnumerationIndex(n2++);
            UserExpressionDescriptor userExpressionDescriptor = nodeDescriptorFactory.getUserExpressionDescriptor(childrenBuilder.getParentDescriptor(), userExpressionData);
            if (childInfo.myOnDemand) {
                userExpressionDescriptor.putUserData(OnDemandRenderer.ON_DEMAND_CALCULATED, false);
            }
            arrayList.add(nodeManager.createNode(userExpressionDescriptor, evaluationContext));
        }
        childrenBuilder.addChildren(arrayList, !this.b);
        if (this.b) {
            DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, childrenBuilder, evaluationContext);
        }
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
        return ((ValueDescriptor)debuggerTreeNode.getDescriptor()).getDescriptorEvaluation(debuggerContext);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) {
        return this.c.size() > 0 || this.b && DebugProcessImpl.getDefaultRenderer(value).isExpandable(value, evaluationContext, nodeDescriptor);
    }

    public List<ChildInfo> getChildren() {
        return this.c;
    }

    public void setChildren(List<ChildInfo> list2) {
        this.c = list2;
    }

    @Nullable
    public static EnumerationChildrenRenderer getCurrent(ValueDescriptorImpl valueDescriptorImpl) {
        ChildrenRenderer childrenRenderer;
        Renderer renderer = valueDescriptorImpl.getLastRenderer();
        if (renderer instanceof CompoundNodeRenderer && NodeRendererSettings.getInstance().getCustomRenderers().contains((NodeRenderer)renderer) && (childrenRenderer = ((CompoundNodeRenderer)renderer).getChildrenRenderer()) instanceof EnumerationChildrenRenderer) {
            return (EnumerationChildrenRenderer)childrenRenderer;
        }
        return null;
    }

    public static class ChildInfo
    implements Cloneable {
        public String myName;
        public TextWithImports myExpression;
        public boolean myOnDemand;

        public ChildInfo(String string, TextWithImports textWithImports, boolean bl2) {
            this.myName = string;
            this.myExpression = textWithImports;
            this.myOnDemand = bl2;
        }
    }
}

