/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.designer.palette.PaletteToolWindowManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToolWindowManager
extends LightToolWindowManager {
    protected AbstractToolWindowManager(Project project2, FileEditorManager fileEditorManager) {
        super(project2, fileEditorManager);
    }

    @Nullable
    protected DesignerEditorPanelFacade getDesigner(FileEditor fileEditor) {
        if (fileEditor instanceof DesignerEditor) {
            DesignerEditor designerEditor = (DesignerEditor)fileEditor;
            return designerEditor.getDesignerPanel();
        }
        return null;
    }

    protected ToggleEditorModeAction createToggleAction(ToolWindowAnchor toolWindowAnchor) {
        return new ToggleEditorModeAction(this, this.myProject, toolWindowAnchor){

            protected LightToolWindowManager getOppositeManager() {
                DesignerToolWindowManager designerToolWindowManager = DesignerToolWindowManager.getInstance(this.myProject);
                PaletteToolWindowManager paletteToolWindowManager = PaletteToolWindowManager.getInstance(this.myProject);
                return this.myManager == designerToolWindowManager ? paletteToolWindowManager : designerToolWindowManager;
            }
        };
    }

    @Nullable
    protected static DesignerCustomizations getCustomizations() {
        return (DesignerCustomizations)DesignerCustomizations.EP_NAME.findExtension(DesignerCustomizations.class);
    }
}

