/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractComboBoxAction<T>
extends ComboBoxAction {
    protected static final Icon CHECKED = PlatformIcons.CHECK_ICON;
    protected List<T> myItems = Collections.emptyList();
    private T b;
    private Presentation c;
    private boolean a;

    public void setItems(List<T> list2, @Nullable T t2) {
        this.myItems = list2;
        this.setSelection(t2);
    }

    public T getSelection() {
        return this.b;
    }

    public void setSelection(T t2) {
        this.b = t2;
        if (t2 == null && !this.myItems.isEmpty()) {
            this.b = this.myItems.get(0);
        }
        this.update();
    }

    public void clearSelection() {
        this.b = null;
        this.update();
    }

    public void showDisabledActions(boolean bl2) {
        this.a = bl2;
    }

    public JComponent createCustomComponent(Presentation presentation) {
        this.c = presentation;
        this.update();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.createComboBoxButton(presentation), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 1, 2, 1), 0, 0));
        return jPanel;
    }

    protected ComboBoxAction.ComboBoxButton createComboBoxButton(Presentation presentation) {
        if (this.a) {
            return new ComboBoxAction.ComboBoxButton(presentation){

                protected JBPopup createPopup(Runnable runnable) {
                    ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)AbstractComboBoxAction.this.createPopupActionGroup((JComponent)((Object)this)), this.getDataContext(), true, runnable, AbstractComboBoxAction.this.getMaxRows());
                    listPopup.setMinimumSize(new Dimension(AbstractComboBoxAction.this.getMinWidth(), AbstractComboBoxAction.this.getMinHeight()));
                    return listPopup;
                }
            };
        }
        return super.createComboBoxButton(presentation);
    }

    public void update() {
        this.update(this.b, this.c == null ? this.getTemplatePresentation() : this.c, false);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent jComponent) {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        for (final T t2 : this.myItems) {
            if (this.addSeparator(defaultActionGroup, t2)) continue;
            AnAction anAction = new AnAction(){

                public void actionPerformed(AnActionEvent anActionEvent) {
                    if (AbstractComboBoxAction.this.b != t2 && AbstractComboBoxAction.this.selectionChanged(t2)) {
                        AbstractComboBoxAction.this.b = t2;
                        AbstractComboBoxAction.this.update(t2, AbstractComboBoxAction.this.c, false);
                    }
                }
            };
            defaultActionGroup.add(anAction);
            Presentation presentation = anAction.getTemplatePresentation();
            presentation.setIcon(this.b == t2 ? CHECKED : null);
            this.update(t2, presentation, true);
        }
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
        if (defaultActionGroup2 == null) {
            AbstractComboBoxAction.a(0);
        }
        return defaultActionGroup2;
    }

    protected boolean addSeparator(DefaultActionGroup defaultActionGroup, T t2) {
        return false;
    }

    protected abstract void update(T var1, Presentation var2, boolean var3);

    protected abstract boolean selectionChanged(T var1);

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/actions/AbstractComboBoxAction", "createPopupActionGroup"));
    }
}

