/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class TreeDropListener
extends DropTargetAdapter {
    private final EditableArea j;
    private final ToolProvider a;
    private final Class[] g;
    private final OperationContext i = new OperationContext();
    private DropTargetDragEvent b;
    private EditOperation e;
    private RadComponent c;
    private boolean d;
    private boolean f;
    private static final Cursor h = Cursors.getMoveCursor();

    public TreeDropListener(ComponentTree componentTree, EditableArea editableArea, ToolProvider toolProvider) {
        this((JComponent)((Object)componentTree), editableArea, toolProvider, TreeDropListener.class, PaletteItem.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            componentTree.setDragEnabled(true);
            componentTree.setTransferHandler(new TreeTransfer(TreeDropListener.class));
        }
    }

    public TreeDropListener(JComponent jComponent, EditableArea editableArea, ToolProvider toolProvider, Class ... classArray) {
        this.j = editableArea;
        this.i.setArea(editableArea);
        this.a = toolProvider;
        this.g = classArray;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            jComponent.setDropTarget(new DropTarget(jComponent, this));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.c();
        this.a(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.b = dropTargetDragEvent;
        this.f();
        this.b();
        this.g();
        this.d();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.c();
        this.a();
        this.a(true);
        dropTargetDropEvent.dropComplete(true);
    }

    private void d() {
        if (this.e != null) {
            this.e.showFeedback();
        }
        this.f = true;
    }

    private void c() {
        if (this.f) {
            this.f = false;
            if (this.e != null) {
                this.e.eraseFeedback();
            }
        }
    }

    private void f() {
        this.i.setLocation(this.e());
        if (this.i.getComponents() == null) {
            if (!ArrayUtil.contains((Object)SimpleTransferable.getData(this.b.getTransferable(), Class.class), (Object[])this.g)) {
                this.i.setComponents(Collections.emptyList());
                return;
            }
            if (this.a.getActiveTool() instanceof CreationTool) {
                this.i.setType("create_children");
                CreationTool creationTool = (CreationTool)this.a.getActiveTool();
                try {
                    this.i.setComponents(Collections.singletonList(creationTool.getFactory().create()));
                }
                catch (Throwable throwable) {
                    this.i.setComponents(Collections.emptyList());
                    this.a.loadDefaultTool();
                }
                return;
            }
            List<RadComponent> list2 = RadComponent.getPureSelection(this.j.getSelection());
            RadComponent radComponent = null;
            for (RadComponent radComponent2 : list2) {
                if (radComponent == null) {
                    radComponent = radComponent2.getParent();
                    continue;
                }
                if (radComponent == radComponent2.getParent()) continue;
                list2 = Collections.emptyList();
                break;
            }
            this.i.setComponents(list2);
            this.i.resetMoveAddEnabled();
            for (RadComponent radComponent2 : list2) {
                radComponent2.processDropOperation(this.i);
            }
        }
    }

    private void b() {
        if (this.i.getComponents().isEmpty()) {
            return;
        }
        final ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>(this.i.getComponents());
        if (!this.i.isCreate()) {
            for (RadComponent object2 : this.i.getComponents()) {
                object2.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent radComponent) {
                        arrayList.add(radComponent);
                    }
                }, true);
            }
        }
        final EditOperation[] editOperationArray = new EditOperation[1];
        ComponentTargetFilter componentTargetFilter = new ComponentTargetFilter(){

            @Override
            public boolean preFilter(RadComponent radComponent) {
                return TreeDropListener.this.i.isCreate() || !arrayList.contains((Object)radComponent);
            }

            @Override
            public boolean resultFilter(RadComponent radComponent) {
                if (!TreeDropListener.this.i.isCreate()) {
                    if (TreeDropListener.this.i.getComponents().get(0).getParent() == radComponent) {
                        TreeDropListener.this.i.setType("move_children");
                    } else {
                        TreeDropListener.this.i.setType("add_children");
                    }
                }
                if (TreeDropListener.this.c == radComponent) {
                    return true;
                }
                RadLayout radLayout = radComponent.getLayout();
                if (radLayout != null) {
                    editOperationArray[0] = radLayout.processChildOperation(TreeDropListener.this.i);
                }
                return editOperationArray[0] != null;
            }
        };
        Point point = this.e();
        RadComponent radComponent = this.j.findTarget(point.x, point.y, componentTargetFilter);
        if (radComponent != this.c) {
            if (this.e != null) {
                this.c();
            }
            this.c = radComponent;
            this.e = editOperationArray[0];
        }
        if (radComponent == null) {
            if (!this.i.isCreate()) {
                this.i.setType(null);
            }
        } else {
            this.e.setComponents(this.i.getComponents());
        }
    }

    private Point e() {
        return this.b.getLocation();
    }

    private void g() {
        if (this.e != null) {
            if (this.i.isMove()) {
                this.b(this.i.isMoveEnabled() && this.e.canExecute());
            } else if (this.i.isAdd()) {
                this.b(this.i.isAddEnabled() && this.e.canExecute());
            } else if (this.i.isCreate()) {
                this.b(this.e.canExecute());
            } else {
                this.b(false);
            }
        } else {
            this.b(false);
        }
    }

    private void b(boolean bl2) {
        this.d = bl2;
        if (bl2) {
            this.b.acceptDrag(this.b.getDropAction());
            this.j.setCursor(this.i.isCreate() ? Cursors.getCopyCursor() : h);
        } else {
            this.b.rejectDrag();
            this.j.setCursor(Cursors.getSystemNoCursor());
        }
    }

    private void a() {
        if (this.d) {
            this.a.execute(Collections.singletonList(this.e), this.i.getMessage());
            if (this.i.isCreate()) {
                this.j.setSelection(this.i.getComponents());
            }
        }
    }

    private void a(boolean bl2) {
        this.i.setComponents(null);
        this.b = null;
        this.e = null;
        this.c = null;
        this.d = false;
        if (bl2 || !this.i.isCreate()) {
            this.i.setType(null);
            this.a.loadDefaultTool();
        }
        this.j.setCursor(null);
    }
}

