/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.DesignerEditorState;
import com.intellij.designer.DesignerToolWindowContent;
import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.LightFillLayout;
import com.intellij.designer.ModuleProvider;
import com.intellij.designer.PaletteToolWindowContent;
import com.intellij.designer.actions.AbstractComboBoxAction;
import com.intellij.designer.actions.CommonEditActionsProvider;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.componentTree.TreeComponentDecorator;
import com.intellij.designer.componentTree.TreeEditableArea;
import com.intellij.designer.designSurface.CaptionPanel;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.ComponentEditableArea;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.GlassLayer;
import com.intellij.designer.designSurface.InplaceEditingLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.QuickFixManager;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.designSurface.tools.ComponentCreationFactory;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.MarqueeTracker;
import com.intellij.designer.designSurface.tools.PasteTool;
import com.intellij.designer.designSurface.tools.SelectionTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.FindComponentVisitor;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadPropertyContext;
import com.intellij.designer.model.WrapInProvider;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteToolWindowManager;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.designer.propertyTable.TablePanelActionPolicy;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditorPanel
extends JPanel
implements DesignerEditorPanelFacade,
DataProvider,
ModuleProvider,
RadPropertyContext {
    private static final Logger p = Logger.getInstance((String)"#com.intellij.designer.designSurface.DesignerEditorPanel");
    protected static final Integer LAYER_COMPONENT = JLayeredPane.DEFAULT_LAYER;
    protected static final Integer LAYER_DECORATION = JLayeredPane.POPUP_LAYER;
    protected static final Integer LAYER_FEEDBACK = JLayeredPane.DRAG_LAYER;
    protected static final Integer LAYER_GLASS = LAYER_FEEDBACK + 100;
    protected static final Integer LAYER_INPLACE_EDITING = LAYER_GLASS + 100;
    private static final Integer b = LAYER_INPLACE_EDITING + 100;
    private static final String j = "designer";
    private static final String e = "error";
    private static final String n = "stack";
    private static final String z = "no_stack";
    @NotNull
    private final DesignerEditor D;
    private final Project k;
    private Module m;
    protected final VirtualFile myFile;
    private final CardLayout h;
    private final ThreeComponentsSplitter s;
    private final JPanel q;
    private JComponent c;
    protected DesignerActionPanel myActionPanel;
    protected CaptionPanel myHorizontalCaption;
    protected CaptionPanel myVerticalCaption;
    protected JScrollPane myScrollPane;
    protected JLayeredPane myLayeredPane;
    protected GlassLayer myGlassLayer;
    private DecorationLayer u;
    private FeedbackLayer B;
    private InplaceEditingLayer x;
    protected ToolProvider myToolProvider;
    protected EditableArea mySurfaceArea;
    protected RadComponent myRootComponent;
    protected QuickFixManager myQuickFixManager;
    private PaletteItem o;
    private List<?> w;
    private final Map<String, Property> t;
    private int[][] f;
    private int[][] g;
    private final Map<String, int[][]> l;
    private FixableMessageAction v;
    private JPanel A;
    protected JPanel myErrorMessages;
    private JPanel y;
    private CardLayout i;
    private JTextArea C;
    private JPanel d;
    private AsyncProcessIcon r;
    private JLabel a;
    protected String myLastExecuteCommand;

    public DesignerEditorPanel(@NotNull DesignerEditor designerEditor, @NotNull Project project2, Module module2, @NotNull VirtualFile virtualFile) {
        if (designerEditor == null) {
            DesignerEditorPanel.a(0);
        }
        if (project2 == null) {
            DesignerEditorPanel.a(1);
        }
        if (virtualFile == null) {
            DesignerEditorPanel.a(2);
        }
        this.h = new CardLayout();
        this.s = new ThreeComponentsSplitter();
        this.q = new JPanel(this.h);
        this.t = new HashMap<String, Property>();
        this.l = new FixedHashMap(16);
        this.D = designerEditor;
        this.k = project2;
        this.m = module2;
        this.myFile = virtualFile;
        this.c();
        this.myToolProvider.loadDefaultTool();
    }

    private void c() {
        this.setLayout(new BorderLayout());
        this.s.setDividerWidth(0);
        this.s.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.add((Component)this.s, "Center");
        this.d();
        this.b();
        this.g();
        UIUtil.invokeLaterIfNeeded(() -> {
            DesignerEditorPanel designerEditorPanel = this;
            this.getDesignerWindowManager().bind(designerEditorPanel);
            this.getPaletteWindowManager().bind(designerEditorPanel);
        });
    }

    private void d() {
        JPanel jPanel = new JPanel((LayoutManager)new LightFillLayout());
        this.s.setInnerComponent((JComponent)jPanel);
        this.myLayeredPane = new MyLayeredPane();
        this.mySurfaceArea = this.createEditableArea();
        this.myToolProvider = this.createToolProvider();
        this.myGlassLayer = this.createGlassLayer(this.myToolProvider, this.mySurfaceArea);
        this.myLayeredPane.add((Component)this.myGlassLayer, LAYER_GLASS);
        this.u = this.createDecorationLayer();
        this.myLayeredPane.add((Component)this.u, LAYER_DECORATION);
        this.B = this.createFeedbackLayer();
        this.myLayeredPane.add((Component)this.B, LAYER_FEEDBACK);
        this.x = this.createInplaceEditingLayer();
        this.myLayeredPane.add((Component)this.x, LAYER_INPLACE_EDITING);
        this.myScrollPane = this.createScrollPane(this.myLayeredPane);
        this.myQuickFixManager = new QuickFixManager(this, this.myGlassLayer, this.myScrollPane.getViewport());
        this.myActionPanel = this.createActionPanel();
        this.v = new FixableMessageAction();
        jPanel.add(this.myActionPanel.getToolbarComponent());
        jPanel.add(this.q);
        this.c = this.createDesignerCardPanel();
        this.q.add((Component)this.c, j);
        this.mySurfaceArea.addSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectionChanged(EditableArea editableArea) {
                DesignerEditorPanel.this.e();
            }
        });
    }

    protected JComponent createDesignerCardPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.myVerticalCaption = this.createCaptionPanel(false);
        jPanel.add((Component)((Object)this.myVerticalCaption), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.myHorizontalCaption = this.createCaptionPanel(true);
        jPanel.add((Component)((Object)this.myHorizontalCaption), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.myScrollPane, gridBagConstraints);
        this.myHorizontalCaption.attachToScrollPane(this.myScrollPane);
        this.myVerticalCaption.attachToScrollPane(this.myScrollPane);
        return jPanel;
    }

    public final ThreeComponentsSplitter getContentSplitter() {
        return this.s;
    }

    protected EditableArea createEditableArea() {
        return new DesignerEditableArea();
    }

    protected ToolProvider createToolProvider() {
        return new DesignerToolProvider();
    }

    protected GlassLayer createGlassLayer(ToolProvider toolProvider, EditableArea editableArea) {
        return new GlassLayer(toolProvider, editableArea);
    }

    protected DecorationLayer createDecorationLayer() {
        return new DecorationLayer(this, this.mySurfaceArea);
    }

    protected FeedbackLayer createFeedbackLayer() {
        return new FeedbackLayer(this);
    }

    protected InplaceEditingLayer createInplaceEditingLayer() {
        return new InplaceEditingLayer(this);
    }

    protected CaptionPanel createCaptionPanel(boolean bl2) {
        return new CaptionPanel(this, bl2, true);
    }

    protected JScrollPane createScrollPane(@NotNull JLayeredPane jLayeredPane) {
        if (jLayeredPane == null) {
            DesignerEditorPanel.a(3);
        }
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)jLayeredPane);
        jScrollPane.setBackground((Color)new JBColor(Color.WHITE, UIUtil.getListBackground()));
        return jScrollPane;
    }

    protected DesignerActionPanel createActionPanel() {
        return new DesignerActionPanel(this, this.myGlassLayer);
    }

    @Nullable
    public final PaletteItem getActivePaletteItem() {
        return this.o;
    }

    public final void activatePaletteItem(@Nullable PaletteItem paletteItem) {
        this.o = paletteItem;
        if (paletteItem != null) {
            this.myToolProvider.setActiveTool(new CreationTool(true, this.createCreationFactory(paletteItem)));
        } else if (this.myToolProvider.getActiveTool() instanceof CreationTool) {
            this.myToolProvider.loadDefaultTool();
        }
    }

    protected final void showDesignerCard() {
        this.myErrorMessages.removeAll();
        this.C.setText(null);
        this.myLayeredPane.revalidate();
        if (this.myHorizontalCaption != null) {
            this.myHorizontalCaption.update();
        }
        if (this.myVerticalCaption != null) {
            this.myVerticalCaption.update();
        }
        this.h.show(this.q, j);
    }

    private void b() {
        this.A = new JPanel(new BorderLayout());
        this.myErrorMessages = new JPanel((LayoutManager)new VerticalFlowLayout(0, 10, 5, true, false));
        this.A.add((Component)this.myErrorMessages, "First");
        this.C = new JTextArea(50, 20);
        this.C.setEditable(false);
        this.i = new CardLayout();
        this.y = new JPanel(this.i);
        this.y.add((Component)new JLabel(), z);
        this.y.add((Component)ScrollPaneFactory.createScrollPane((Component)this.C), n);
        this.A.add((Component)this.y, "Center");
        this.q.add((Component)this.A, e);
    }

    public final void showError(@NotNull String string, @NotNull Throwable throwable) {
        if (string == null) {
            DesignerEditorPanel.a(4);
        }
        if (throwable == null) {
            DesignerEditorPanel.a(5);
        }
        if (this.isProjectClosed()) {
            return;
        }
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.myMessage = errorInfo.myDisplayMessage = string;
        errorInfo.myThrowable = throwable;
        this.configureError(errorInfo);
        if (errorInfo.myShowMessage) {
            this.showErrorPage(errorInfo);
        }
        if (errorInfo.myShowLog) {
            p.error((Object)LogMessageEx.createEvent((String)errorInfo.myDisplayMessage, (String)(errorInfo.myMessage + "\n" + ExceptionUtil.getThrowableText((Throwable)errorInfo.myThrowable)), (Attachment[])this.getErrorAttachments(errorInfo)));
        }
    }

    protected Attachment[] getErrorAttachments(ErrorInfo errorInfo) {
        return new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)this.myFile)};
    }

    protected abstract void configureError(@NotNull ErrorInfo var1);

    protected void showErrorPage(ErrorInfo errorInfo) {
        this.storeState();
        this.hideProgress();
        this.myRootComponent = null;
        this.myErrorMessages.removeAll();
        if (errorInfo.myShowStack) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            errorInfo.myThrowable.printStackTrace(new PrintStream(byteArrayOutputStream));
            this.C.setText(byteArrayOutputStream.toString());
            this.i.show(this.y, n);
        } else {
            this.C.setText(null);
            this.i.show(this.y, z);
        }
        this.addErrorMessage(new FixableMessageInfo(true, errorInfo.myDisplayMessage, "", "", null, null), Messages.getErrorIcon());
        for (FixableMessageInfo fixableMessageInfo : errorInfo.myMessages) {
            this.addErrorMessage(fixableMessageInfo, fixableMessageInfo.myErrorIcon ? Messages.getErrorIcon() : Messages.getWarningIcon());
        }
        this.A.revalidate();
        this.h.show(this.q, e);
        this.getDesignerToolWindow().refresh(true);
        this.repaint();
    }

    protected void addErrorMessage(final FixableMessageInfo fixableMessageInfo, Icon icon) {
        Object object;
        if (fixableMessageInfo.myLinkText.length() > 0 || fixableMessageInfo.myAfterLinkText.length() > 0) {
            object = new HyperlinkLabel();
            object.setOpaque(false);
            object.setHyperlinkText(fixableMessageInfo.myBeforeLinkText, fixableMessageInfo.myLinkText, fixableMessageInfo.myAfterLinkText);
            object.setIcon(icon);
            if (fixableMessageInfo.myQuickFix != null) {
                object.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            fixableMessageInfo.myQuickFix.run();
                        }
                    }
                });
            }
            this.myErrorMessages.add((Component)object);
        } else {
            object = new JBLabel();
            object.setOpaque(false);
            object.setText("<html><body>" + fixableMessageInfo.myBeforeLinkText.replace("\n", "<br>") + "</body></html>");
            object.setIcon(icon);
            this.myErrorMessages.add((Component)object);
        }
        if (fixableMessageInfo.myAdditionalFixes != null && fixableMessageInfo.myAdditionalFixes.size() > 0) {
            object = new JPanel(new FlowLayout(0, 5, 0));
            ((JComponent)object).setBorder((Border)JBUI.Borders.empty((int)3, (int)0, (int)10, (int)0));
            ((JComponent)object).setOpaque(false);
            ((Container)object).add(Box.createHorizontalStrut(icon.getIconWidth()));
            for (Pair<String, Runnable> pair2 : fixableMessageInfo.myAdditionalFixes) {
                HyperlinkLabel hyperlinkLabel = new HyperlinkLabel();
                hyperlinkLabel.setOpaque(false);
                hyperlinkLabel.setHyperlinkText((String)pair2.getFirst());
                final Runnable runnable = (Runnable)pair2.getSecond();
                hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            runnable.run();
                        }
                    }
                });
                ((Container)object).add((Component)hyperlinkLabel);
            }
            this.myErrorMessages.add((Component)object);
        }
    }

    protected final void showWarnMessages(@Nullable List<FixableMessageInfo> list2) {
        if (list2 == null) {
            this.v.hide();
        } else {
            this.v.show(list2);
        }
    }

    private void g() {
        this.r = new AsyncProcessIcon("Designer progress");
        this.a = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.add((Component)this.r);
        jPanel.add(this.a);
        jPanel.setBorder((Border)IdeBorderFactory.createRoundedBorder());
        this.d = new JPanel(new GridBagLayout());
        this.d.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.d.setOpaque(false);
    }

    protected final void showProgress(String string) {
        this.a.setText(string);
        if (this.d.getParent() == null) {
            this.myGlassLayer.setEnabled(false);
            this.r.resume();
            this.myLayeredPane.add((Component)this.d, b);
            this.myLayeredPane.repaint();
        }
    }

    protected final void hideProgress() {
        this.myGlassLayer.setEnabled(true);
        this.r.suspend();
        this.myLayeredPane.remove(this.d);
    }

    @Override
    @NotNull
    public final Module getModule() {
        if (this.m.isDisposed()) {
            this.m = this.findModule(this.k, this.myFile);
            if (this.m == null) {
                throw new IllegalArgumentException("No module for file " + this.myFile + " in project " + this.k);
            }
        }
        Module module2 = this.m;
        if (module2 == null) {
            DesignerEditorPanel.a(6);
        }
        return module2;
    }

    @Nullable
    protected Module findModule(Project project2, VirtualFile virtualFile) {
        return ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2);
    }

    @NotNull
    public final DesignerEditor getEditor() {
        DesignerEditor designerEditor = this.D;
        if (designerEditor == null) {
            DesignerEditorPanel.a(7);
        }
        return designerEditor;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public final Project getProject() {
        return this.k;
    }

    public final boolean isProjectClosed() {
        return this.k.isDisposed() || !this.k.isOpen();
    }

    public EditableArea getSurfaceArea() {
        return this.mySurfaceArea;
    }

    public ToolProvider getToolProvider() {
        return this.myToolProvider;
    }

    public DesignerActionPanel getActionPanel() {
        return this.myActionPanel;
    }

    public InplaceEditingLayer getInplaceEditingLayer() {
        return this.x;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.c.isVisible() ? this.myGlassLayer : this.A;
    }

    @Nullable
    public List<?> getExpandedComponents() {
        return this.w;
    }

    public void setExpandedComponents(@Nullable List<?> list2) {
        this.w = list2;
    }

    public Property getSelectionProperty(@Nullable String string) {
        return this.t.get(string);
    }

    public void setSelectionProperty(@Nullable String string, Property property) {
        this.t.put(string, property);
    }

    protected void storeState() {
        if (this.myRootComponent != null && this.f == null && this.g == null) {
            this.f = new int[this.w == null ? 0 : this.w.size()][];
            for (int i2 = 0; i2 < this.f.length; ++i2) {
                IntArrayList intArrayList = new IntArrayList();
                DesignerEditorPanel.a((RadComponent)((Object)this.w.get(i2)), intArrayList);
                this.f[i2] = intArrayList.toArray();
            }
            this.g = this.f();
            this.w = null;
            InputTool inputTool = this.myToolProvider.getActiveTool();
            if (!(inputTool instanceof MarqueeTracker || inputTool instanceof CreationTool || inputTool instanceof PasteTool)) {
                this.myToolProvider.loadDefaultTool();
            }
        }
    }

    private void e() {
        if (!CommonEditActionsProvider.isDeleting) {
            this.l.put(this.getEditorText(), this.f());
        }
    }

    private int[][] f() {
        return DesignerEditorPanel.getSelectionState(this.mySurfaceArea.getSelection());
    }

    protected static int[][] getSelectionState(List<RadComponent> list2) {
        int[][] nArrayArray = new int[list2.size()][];
        for (int i2 = 0; i2 < nArrayArray.length; ++i2) {
            IntArrayList intArrayList = new IntArrayList();
            DesignerEditorPanel.a(list2.get(i2), intArrayList);
            nArrayArray[i2] = intArrayList.toArray();
        }
        return nArrayArray;
    }

    private static void a(RadComponent radComponent, IntArrayList intArrayList) {
        RadComponent radComponent2 = radComponent.getParent();
        if (radComponent2 != null) {
            intArrayList.add(0, radComponent2.getChildren().indexOf((Object)radComponent));
            DesignerEditorPanel.a(radComponent2, intArrayList);
        }
    }

    protected void restoreState() {
        ArrayList<RadComponent> arrayList;
        DesignerToolWindowContent designerToolWindowContent = this.getDesignerToolWindow();
        if (this.f != null) {
            arrayList = new ArrayList<RadComponent>();
            for (int[] nArray : this.f) {
                DesignerEditorPanel.pathToComponent(arrayList, this.myRootComponent, nArray, 0);
            }
            this.w = arrayList;
            designerToolWindowContent.expandFromState();
            this.f = null;
        }
        arrayList = new ArrayList();
        int[][] nArray = this.l.get(this.getEditorText());
        if (nArray != null) {
            for (int[] nArray2 : nArray) {
                DesignerEditorPanel.pathToComponent(arrayList, this.myRootComponent, nArray2, 0);
            }
        }
        if (arrayList.isEmpty() && this.g != null) {
            for (int[] nArray2 : this.g) {
                DesignerEditorPanel.pathToComponent(arrayList, this.myRootComponent, nArray2, 0);
            }
        }
        if (arrayList.isEmpty()) {
            designerToolWindowContent.refresh(true);
        } else {
            this.mySurfaceArea.setSelection(arrayList);
        }
        this.g = null;
    }

    protected static void pathToComponent(List<RadComponent> list2, RadComponent radComponent, int[] nArray, int n2) {
        if (n2 == nArray.length) {
            list2.add(radComponent);
        } else {
            List<RadComponent> list3 = radComponent.getChildren();
            int n3 = nArray[n2];
            if (0 <= n3 && n3 < list3.size()) {
                DesignerEditorPanel.pathToComponent(list2, list3.get(n3), nArray, n2 + 1);
            }
        }
    }

    public abstract String getPlatformTarget();

    protected RadComponent findTarget(int n2, int n3, @Nullable ComponentTargetFilter componentTargetFilter) {
        if (this.myRootComponent != null) {
            FindComponentVisitor findComponentVisitor = new FindComponentVisitor(this.myLayeredPane, componentTargetFilter, n2, n3);
            this.myRootComponent.accept(findComponentVisitor, false);
            return findComponentVisitor.getResult();
        }
        return null;
    }

    protected abstract ComponentDecorator getRootSelectionDecorator();

    @Nullable
    protected EditOperation processRootOperation(OperationContext operationContext) {
        return null;
    }

    protected abstract boolean execute(ThrowableRunnable<Exception> var1, boolean var2);

    protected abstract void executeWithReparse(ThrowableRunnable<Exception> var1);

    protected abstract void execute(List<EditOperation> var1);

    public abstract List<PaletteGroup> getPaletteGroups();

    @NotNull
    public String getVersionLabel(@Nullable String string) {
        String string2 = StringUtil.notNullize((String)string);
        if (string2 == null) {
            DesignerEditorPanel.a(8);
        }
        return string2;
    }

    public boolean isDeprecated(@Nullable String string) {
        return !StringUtil.isEmpty((String)string);
    }

    protected InputTool createDefaultTool() {
        return new SelectionTool();
    }

    @NotNull
    protected abstract ComponentCreationFactory createCreationFactory(PaletteItem var1);

    @Nullable
    public abstract ComponentPasteFactory createPasteFactory(String var1);

    public abstract String getEditorText();

    public void activate() {
    }

    public void deactivate() {
    }

    @NotNull
    public DesignerEditorState createState() {
        DesignerEditorState designerEditorState = new DesignerEditorState(this.myFile, this.getZoom());
        if (designerEditorState == null) {
            DesignerEditorPanel.a(9);
        }
        return designerEditorState;
    }

    public boolean isEditorValid() {
        return this.myFile.isValid();
    }

    public Object getData(@NonNls String string) {
        return this.myActionPanel.getData(string);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.r);
        this.getDesignerWindowManager().dispose(this);
        this.getPaletteWindowManager().dispose(this);
        Disposer.dispose((Disposable)this.s);
    }

    protected AbstractToolWindowManager getDesignerWindowManager() {
        return DesignerToolWindowManager.getInstance(this.k);
    }

    protected AbstractToolWindowManager getPaletteWindowManager() {
        return PaletteToolWindowManager.getInstance(this.k);
    }

    public DesignerToolWindowContent getDesignerToolWindow() {
        return DesignerToolWindowManager.getInstance(this);
    }

    protected PaletteToolWindowContent getPaletteToolWindow() {
        return PaletteToolWindowManager.getInstance(this);
    }

    @Nullable
    public WrapInProvider getWrapInProvider() {
        return null;
    }

    @Override
    @Nullable
    public RadComponent getRootComponent() {
        return this.myRootComponent;
    }

    public Object[] getTreeRoots() {
        Object[] objectArray;
        if (this.myRootComponent == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.myRootComponent;
        }
        return objectArray;
    }

    public abstract TreeComponentDecorator getTreeDecorator();

    public void handleTreeArea(TreeEditableArea treeEditableArea) {
    }

    @NotNull
    public TablePanelActionPolicy getTablePanelActionPolicy() {
        TablePanelActionPolicy tablePanelActionPolicy = TablePanelActionPolicy.ALL;
        if (tablePanelActionPolicy == null) {
            DesignerEditorPanel.a(10);
        }
        return tablePanelActionPolicy;
    }

    @Nullable
    public PropertyTableTab[] getPropertyTableTabs() {
        return null;
    }

    public boolean isZoomSupported() {
        return false;
    }

    public void zoom(@NotNull ZoomType zoomType) {
        if (zoomType == null) {
            DesignerEditorPanel.a(11);
        }
    }

    public void setZoom(double d2) {
    }

    public double getZoom() {
        return 1.0;
    }

    protected void viewZoomed() {
        this.myQuickFixManager.hideHint();
    }

    public void loadInspections(ProgressIndicator progressIndicator) {
    }

    public void updateInspections() {
        this.myQuickFixManager.update();
    }

    @NotNull
    protected Dimension getSceneSize(Component component) {
        int n2 = 0;
        int n3 = 0;
        if (this.myRootComponent != null) {
            Rectangle rectangle = this.myRootComponent.getBounds(component);
            n2 = Math.max(n2, (int)rectangle.getMaxX());
            n3 = Math.max(n3, (int)rectangle.getMaxY());
            for (RadComponent radComponent : this.myRootComponent.getChildren()) {
                Rectangle rectangle2 = radComponent.getBounds(component);
                n2 = Math.max(n2, (int)rectangle2.getMaxX());
                n3 = Math.max(n3, (int)rectangle2.getMaxY());
            }
        }
        Dimension dimension = new Dimension(n2 += 50, n3 += 40);
        if (dimension == null) {
            DesignerEditorPanel.a(12);
        }
        return dimension;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/designSurface/DesignerEditorPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/designSurface/DesignerEditorPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionLabel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTablePanelActionPolicy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneSize";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class FixableMessageInfo {
        public final boolean myErrorIcon;
        public final String myBeforeLinkText;
        public final String myLinkText;
        public final String myAfterLinkText;
        public final Runnable myQuickFix;
        public final List<Pair<String, Runnable>> myAdditionalFixes;

        public FixableMessageInfo(boolean bl2, String string, String string2, String string3, Runnable runnable, List<Pair<String, Runnable>> list2) {
            this.myErrorIcon = bl2;
            this.myBeforeLinkText = string;
            this.myLinkText = string2;
            this.myAfterLinkText = string3;
            this.myQuickFix = runnable;
            this.myAdditionalFixes = list2;
        }
    }

    public static final class ErrorInfo {
        public String myMessage;
        public String myDisplayMessage;
        public final List<FixableMessageInfo> myMessages = new ArrayList<FixableMessageInfo>();
        public Throwable myThrowable;
        public boolean myShowMessage = true;
        public boolean myShowStack = true;
        public boolean myShowLog;
    }

    private class FixableMessageAction
    extends AbstractComboBoxAction<FixableMessageInfo> {
        private final DefaultActionGroup f = new DefaultActionGroup();
        private String e;
        private boolean d;

        public FixableMessageAction() {
            DesignerEditorPanel.this.myActionPanel.getActionGroup().add((AnAction)this.f);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setDescription("Warnings");
            presentation.setIcon(AllIcons.Ide.Warning_notifications);
        }

        public void show(List<FixableMessageInfo> list2) {
            if (!this.d) {
                this.e = Integer.toString(list2.size());
                this.setItems(list2, null);
                this.f.add((AnAction)this);
                DesignerEditorPanel.this.myActionPanel.update();
                this.d = true;
            }
        }

        public void hide() {
            if (this.d) {
                this.f.remove((AnAction)this);
                DesignerEditorPanel.this.myActionPanel.update();
                this.d = false;
            }
        }

        @Override
        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent jComponent) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            for (final FixableMessageInfo fixableMessageInfo : this.myItems) {
                Object object;
                if (fixableMessageInfo.myQuickFix != null && (fixableMessageInfo.myLinkText.length() > 0 || fixableMessageInfo.myAfterLinkText.length() > 0) || fixableMessageInfo.myAdditionalFixes != null && fixableMessageInfo.myAdditionalFixes.size() > 0) {
                    final AnAction[] anActionArray = new AnAction[1];
                    DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup(){

                        public boolean canBePerformed(DataContext dataContext) {
                            return true;
                        }

                        public void actionPerformed(AnActionEvent anActionEvent) {
                            anActionArray[0].actionPerformed(anActionEvent);
                        }
                    };
                    defaultActionGroup2.setPopup(true);
                    object = defaultActionGroup2;
                    if (fixableMessageInfo.myQuickFix != null && (fixableMessageInfo.myLinkText.length() > 0 || fixableMessageInfo.myAfterLinkText.length() > 0)) {
                        AnAction anAction = new AnAction(){

                            public void actionPerformed(AnActionEvent anActionEvent) {
                                fixableMessageInfo.myQuickFix.run();
                            }
                        };
                        anAction.getTemplatePresentation().setText(this.a(fixableMessageInfo.myLinkText + fixableMessageInfo.myAfterLinkText));
                        defaultActionGroup2.add(anAction);
                        anActionArray[0] = anAction;
                    }
                    if (fixableMessageInfo.myAdditionalFixes != null && fixableMessageInfo.myAdditionalFixes.size() > 0) {
                        for (final Pair pair2 : fixableMessageInfo.myAdditionalFixes) {
                            AnAction anAction = new AnAction(){

                                public void actionPerformed(AnActionEvent anActionEvent) {
                                    ((Runnable)pair2.second).run();
                                }
                            };
                            anAction.getTemplatePresentation().setText(this.a((String)pair2.first));
                            defaultActionGroup2.add(anAction);
                            if (anActionArray[0] != null) continue;
                            anActionArray[0] = anAction;
                        }
                    }
                } else {
                    object = new EmptyAction(true);
                }
                defaultActionGroup.add((AnAction)object);
                this.update(fixableMessageInfo, object.getTemplatePresentation(), true);
            }
            DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
            if (defaultActionGroup2 == null) {
                FixableMessageAction.b(0);
            }
            return defaultActionGroup2;
        }

        @Override
        protected void update(FixableMessageInfo fixableMessageInfo, Presentation presentation, boolean bl2) {
            if (bl2) {
                presentation.setText(this.a(fixableMessageInfo.myBeforeLinkText));
            } else {
                presentation.setText(this.e);
            }
        }

        private String a(String string) {
            if (string != null) {
                string = string.trim();
                string = StringUtil.replace((String)string, (String)"&nbsp;", (String)" ");
                string = StringUtil.replace((String)string, (String)"\n", (String)" ");
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = string.length();
                boolean bl2 = false;
                for (int i2 = 0; i2 < n2; ++i2) {
                    char c2 = string.charAt(i2);
                    if (c2 == ' ') {
                        if (bl2) continue;
                        bl2 = true;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl2 = false;
                    stringBuilder.append(c2);
                }
                string = stringBuilder.toString();
            }
            return string;
        }

        @Override
        protected boolean selectionChanged(FixableMessageInfo fixableMessageInfo) {
            return false;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel$FixableMessageAction", "createPopupActionGroup"));
        }
    }

    private final class MyLayeredPane
    extends JBLayeredPane
    implements Scrollable {
        private MyLayeredPane() {
        }

        public void doLayout() {
            for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
                Component component = this.getComponent(i2);
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Rectangle rectangle = DesignerEditorPanel.this.myScrollPane.getViewport().getBounds();
            Dimension dimension = DesignerEditorPanel.this.getSceneSize((Component)((Object)this));
            dimension.width = Math.max(dimension.width, rectangle.width);
            dimension.height = Math.max(dimension.height, rectangle.height);
            return dimension;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
            if (n2 == 0) {
                return rectangle.width - 10;
            }
            return rectangle.height - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    protected class DesignerToolProvider
    extends ToolProvider {
        protected DesignerToolProvider() {
        }

        @Override
        public void loadDefaultTool() {
            this.setActiveTool(DesignerEditorPanel.this.createDefaultTool());
        }

        @Override
        public void setActiveTool(InputTool inputTool) {
            if (this.getActiveTool() instanceof CreationTool && !(inputTool instanceof CreationTool)) {
                DesignerEditorPanel.this.getPaletteToolWindow().clearActiveItem();
            }
            if (!(inputTool instanceof SelectionTool)) {
                this.hideInspections();
            }
            super.setActiveTool(inputTool);
        }

        @Override
        public boolean execute(ThrowableRunnable<Exception> throwableRunnable, String string, boolean bl2) {
            DesignerEditorPanel.this.myLastExecuteCommand = string;
            Ref ref = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), () -> ref.set((Object)DesignerEditorPanel.this.execute(throwableRunnable, bl2)), string, null);
            return (Boolean)ref.get();
        }

        @Override
        public void executeWithReparse(ThrowableRunnable<Exception> throwableRunnable, String string) {
            DesignerEditorPanel.this.myLastExecuteCommand = string;
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), () -> DesignerEditorPanel.this.executeWithReparse(throwableRunnable), string, null);
        }

        @Override
        public void execute(List<EditOperation> list2, String string) {
            DesignerEditorPanel.this.myLastExecuteCommand = string;
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), () -> DesignerEditorPanel.this.execute(list2), string, null);
        }

        @Override
        public void startInplaceEditing(@Nullable InplaceContext inplaceContext) {
            DesignerEditorPanel.this.x.startEditing(inplaceContext);
        }

        @Override
        public void hideInspections() {
            DesignerEditorPanel.this.myQuickFixManager.hideHint();
        }

        @Override
        public void showError(@NonNls String string, Throwable throwable) {
            DesignerEditorPanel.this.showError(string, throwable);
        }

        @Override
        public boolean isZoomSupported() {
            return DesignerEditorPanel.this.isZoomSupported();
        }

        @Override
        public void zoom(@NotNull ZoomType zoomType) {
            if (zoomType == null) {
                DesignerToolProvider.a(0);
            }
            DesignerEditorPanel.this.zoom(zoomType);
        }

        @Override
        public void setZoom(double d2) {
            DesignerEditorPanel.this.setZoom(d2);
        }

        @Override
        public double getZoom() {
            return DesignerEditorPanel.this.getZoom();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/designer/designSurface/DesignerEditorPanel$DesignerToolProvider", "zoom"));
        }
    }

    protected class DesignerEditableArea
    extends ComponentEditableArea {
        public DesignerEditableArea() {
            super(DesignerEditorPanel.this.myLayeredPane);
        }

        @Override
        protected void fireSelectionChanged() {
            super.fireSelectionChanged();
            DesignerEditorPanel.this.myLayeredPane.revalidate();
            DesignerEditorPanel.this.myLayeredPane.repaint();
        }

        @Override
        public void scrollToSelection() {
            Rectangle rectangle;
            List<RadComponent> list2 = this.getSelection();
            if (list2.size() == 1 && (rectangle = list2.get(0).getBounds(DesignerEditorPanel.this.myLayeredPane)) != null) {
                DesignerEditorPanel.this.myLayeredPane.scrollRectToVisible(rectangle);
            }
        }

        @Override
        public RadComponent findTarget(int n2, int n3, @Nullable ComponentTargetFilter componentTargetFilter) {
            return DesignerEditorPanel.this.findTarget(n2, n3, componentTargetFilter);
        }

        @Override
        public InputTool findTargetTool(int n2, int n3) {
            return DesignerEditorPanel.this.u.findTargetTool(n2, n3);
        }

        @Override
        public void showSelection(boolean bl2) {
            DesignerEditorPanel.this.u.showSelection(bl2);
        }

        @Override
        public ComponentDecorator getRootSelectionDecorator() {
            return DesignerEditorPanel.this.getRootSelectionDecorator();
        }

        @Override
        @Nullable
        public EditOperation processRootOperation(OperationContext operationContext) {
            return DesignerEditorPanel.this.processRootOperation(operationContext);
        }

        @Override
        public FeedbackLayer getFeedbackLayer() {
            return DesignerEditorPanel.this.B;
        }

        @Override
        public RadComponent getRootComponent() {
            return DesignerEditorPanel.this.myRootComponent;
        }

        @Override
        public ActionGroup getPopupActions() {
            return DesignerEditorPanel.this.myActionPanel.getPopupActions(this);
        }

        @Override
        public String getPopupPlace() {
            return "GuiDesigner.EditorPopup";
        }
    }
}

