/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ComparatorUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class ExternalPSIChangeListener
extends PsiTreeChangeAdapter {
    private final Alarm a = new Alarm();
    protected final DesignerEditorPanel myDesigner;
    private final PsiFile e;
    private final int c;
    private final Runnable b;
    protected volatile boolean myRunState;
    private volatile boolean d;
    private String f;
    protected boolean myUpdateRenderer;

    public ExternalPSIChangeListener(DesignerEditorPanel designerEditorPanel, PsiFile psiFile, int n2, Runnable runnable) {
        this.myDesigner = designerEditorPanel;
        this.e = psiFile;
        this.c = n2;
        this.b = runnable;
        this.f = this.myDesigner.getEditorText();
        PsiManager.getInstance((Project)this.myDesigner.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this);
    }

    public void setInitialize() {
        this.d = true;
    }

    public void start() {
        if (!this.myRunState) {
            this.myRunState = true;
        }
    }

    public void dispose() {
        PsiManager.getInstance((Project)this.myDesigner.getProject()).removePsiTreeChangeListener((PsiTreeChangeListener)this);
        this.stop();
    }

    public void stop() {
        if (this.myRunState) {
            this.myRunState = false;
            this.clear();
        }
    }

    public void activate() {
        if (!this.myRunState) {
            this.start();
            if (!ComparatorUtil.equalsNullable((Object)this.f, (Object)this.myDesigner.getEditorText()) || this.myDesigner.getRootComponent() == null) {
                this.myUpdateRenderer = false;
                this.addRequest();
            }
            this.f = null;
        }
    }

    public void deactivate() {
        if (this.myRunState) {
            this.stop();
            this.f = this.myDesigner.getEditorText();
        }
        this.myUpdateRenderer = false;
    }

    public void addRequest() {
        this.addRequest(this.b);
    }

    public boolean isActive() {
        return this.myRunState;
    }

    public boolean isUpdateRenderer() {
        return this.myUpdateRenderer;
    }

    public boolean ensureUpdateRenderer() {
        if (this.myRunState) {
            return this.d && !this.myDesigner.isProjectClosed();
        }
        this.myUpdateRenderer = true;
        return false;
    }

    public void addRequest(Runnable runnable) {
        this.clear();
        this.a.addRequest(() -> {
            if (this.myRunState && this.d && !this.myDesigner.isProjectClosed()) {
                runnable.run();
            }
        }, this.c, ModalityState.stateForComponent((Component)this.myDesigner));
    }

    public void clear() {
        this.a.cancelAllRequests();
    }

    protected void updatePsi(PsiTreeChangeEvent psiTreeChangeEvent) {
        if (this.myRunState && this.e == psiTreeChangeEvent.getFile()) {
            this.addRequest();
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent psiTreeChangeEvent) {
        if (psiTreeChangeEvent == null) {
            ExternalPSIChangeListener.a(0);
        }
        this.updatePsi(psiTreeChangeEvent);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent psiTreeChangeEvent) {
        if (psiTreeChangeEvent == null) {
            ExternalPSIChangeListener.a(1);
        }
        this.updatePsi(psiTreeChangeEvent);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent psiTreeChangeEvent) {
        if (psiTreeChangeEvent == null) {
            ExternalPSIChangeListener.a(2);
        }
        this.updatePsi(psiTreeChangeEvent);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent psiTreeChangeEvent) {
        if (psiTreeChangeEvent == null) {
            ExternalPSIChangeListener.a(3);
        }
        this.updatePsi(psiTreeChangeEvent);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent psiTreeChangeEvent) {
        if (psiTreeChangeEvent == null) {
            ExternalPSIChangeListener.a(4);
        }
        this.updatePsi(psiTreeChangeEvent);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent psiTreeChangeEvent) {
        if (psiTreeChangeEvent == null) {
            ExternalPSIChangeListener.a(5);
        }
        this.updatePsi(psiTreeChangeEvent);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/designer/designSurface/ExternalPSIChangeListener";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

