/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.tools.DragTracker;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class NonResizeSelectionDecorator
extends ComponentDecorator {
    protected final Color myColor;
    private final int b;
    private final BasicStroke a;

    public NonResizeSelectionDecorator(Color color, int n2) {
        this.myColor = color;
        this.b = Math.max(n2, 1);
        this.a = this.b > 1 ? new BasicStroke(this.b) : null;
    }

    @Override
    public InputTool findTargetTool(DecorationLayer decorationLayer, RadComponent radComponent, int n2, int n3) {
        Rectangle rectangle = this.getBounds(decorationLayer, radComponent);
        int n4 = Math.max(this.b, 2);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n4);
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - n4, rectangle.width, n4);
        Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, n4, rectangle.height);
        Rectangle rectangle5 = new Rectangle(rectangle.x + rectangle.width - n4, rectangle.y, n4, rectangle.height);
        if (rectangle2.contains(n2, n3) || rectangle3.contains(n2, n3) || rectangle4.contains(n2, n3) || rectangle5.contains(n2, n3)) {
            return new DragTracker(radComponent);
        }
        return null;
    }

    @Override
    protected void paint(DecorationLayer decorationLayer, Graphics2D graphics2D, RadComponent radComponent) {
        graphics2D.setColor(this.myColor);
        if (this.a != null) {
            graphics2D.setStroke(this.a);
        }
        Rectangle rectangle = this.getBounds(decorationLayer, radComponent);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Rectangle getBounds(DecorationLayer decorationLayer, RadComponent radComponent) {
        return radComponent.getBounds(decorationLayer);
    }
}

