/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResizeTracker
extends InputTool {
    private final int i;
    private final String f;
    private OperationContext j;
    private List<EditOperation> g;
    private boolean h;

    public ResizeTracker(int n2, Object object, @Nullable String string) {
        this.i = n2;
        this.f = string;
        this.j = new OperationContext(object);
        this.j.setResizeDirection(n2);
        this.setDefaultCursor(Cursors.getResizeCursor(n2));
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    @Nullable
    protected String getDescription() {
        return this.f;
    }

    @Override
    public void deactivate() {
        this.f();
        this.j = null;
        this.g = null;
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 2) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (n2 == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.f();
            this.setExecuteEnabled(false);
        }
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 3) {
            this.myState = 0;
            this.f();
            this.b();
        }
    }

    @Override
    protected void handleDragStarted() {
        if (this.myState == 2) {
            this.myState = 3;
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.e();
            this.g();
            this.d();
        }
    }

    private void g() {
        for (EditOperation editOperation : this.c()) {
            editOperation.showFeedback();
        }
        this.h = true;
    }

    private void f() {
        if (this.h) {
            this.h = false;
            for (EditOperation editOperation : this.c()) {
                editOperation.eraseFeedback();
            }
        }
    }

    private void b() {
        if (this.myExecuteEnabled) {
            ArrayList<EditOperation> arrayList = new ArrayList<EditOperation>();
            for (EditOperation editOperation : this.c()) {
                if (!editOperation.canExecute()) continue;
                arrayList.add(editOperation);
            }
            this.myToolProvider.execute(arrayList, DesignerBundle.message("command.tool_operation", new Object[0]));
        }
    }

    private void d() {
        for (EditOperation editOperation : this.c()) {
            if (!editOperation.canExecute()) continue;
            this.setExecuteEnabled(true);
            return;
        }
        this.setExecuteEnabled(false);
    }

    private void e() {
        this.j.setArea(this.myArea);
        this.j.setInputEvent(this.myInputEvent);
        this.j.setModifiers(this.myModifiers);
        Point point = new Point();
        Dimension dimension = new Dimension();
        int n2 = this.moveDeltaWidth();
        if ((this.i & 4) != 0) {
            point.x += n2;
            dimension.width -= n2;
        } else if ((this.i & 8) != 0) {
            dimension.width += n2;
        }
        int n3 = this.moveDeltaHeight();
        if ((this.i & 1) != 0) {
            point.y += n3;
            dimension.height -= n3;
        } else if ((this.i & 2) != 0) {
            dimension.height += n3;
        }
        this.j.setMoveDelta(point);
        this.j.setSizeDelta(dimension);
        this.j.setLocation(this.getLocation());
    }

    private List<EditOperation> c() {
        if (this.g == null) {
            this.j.setComponents(new ArrayList<RadComponent>(this.myArea.getSelection()));
            this.g = new ArrayList<EditOperation>();
            for (RadComponent radComponent : this.j.getComponents()) {
                RadComponent radComponent2 = radComponent.getParent();
                EditOperation editOperation = radComponent2 == null ? this.myArea.processRootOperation(this.j) : radComponent2.getLayout().processChildOperation(this.j);
                if (editOperation == null) continue;
                this.g.add(editOperation);
                editOperation.setComponent(radComponent);
            }
        }
        return this.g;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2 = keyEvent.getModifiers() != this.myModifiers;
        super.keyPressed(keyEvent, editableArea);
        if (keyEvent.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        } else if (bl2) {
            this.a();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2 = keyEvent.getModifiers() != this.myModifiers;
        super.keyReleased(keyEvent, editableArea);
        if (bl2) {
            this.a();
        }
    }

    private void a() {
        if (this.j != null) {
            this.e();
            this.g();
            this.d();
        }
    }
}

