/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.PaletteToolWindowContent;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PaletteContainer;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteItemsComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PalettePanel
extends JPanel
implements DataProvider,
PaletteToolWindowContent {
    private final JPanel b = new PaletteContainer();
    private List<PaletteGroupComponent> a = Collections.emptyList();
    private List<PaletteItemsComponent> f = Collections.emptyList();
    private List<PaletteGroup> d = Collections.emptyList();
    private DesignerEditorPanel c;
    private final FocusListener e = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            for (PaletteItemsComponent paletteItemsComponent : PalettePanel.this.f) {
                paletteItemsComponent.clearSelection();
            }
        }
    };
    private final ListSelectionListener g = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PalettePanel.this.a(listSelectionEvent);
        }
    };
    private final DragSourceListener h = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            Component component = dragSourceDropEvent.getDragSourceContext().getComponent();
            if (!dragSourceDropEvent.getDropSuccess() && component instanceof PaletteItemsComponent && PalettePanel.this.c != null && PalettePanel.this.c.getRootPane() == ((JComponent)component).getRootPane()) {
                PalettePanel.this.c.getToolProvider().loadDefaultTool();
            }
        }
    };

    public PalettePanel() {
        super(new GridLayout(1, 1));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.b);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        new AnAction(){

            public void actionPerformed(AnActionEvent anActionEvent) {
                PalettePanel.this.clearActiveItem();
            }
        }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)jScrollPane);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().addDragSourceListener(this.h);
        }
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().removeDragSourceListener(this.h);
        }
    }

    @Nullable
    public PaletteItem getActiveItem() {
        for (PaletteGroupComponent paletteGroupComponent : this.a) {
            PaletteItem paletteItem;
            if (!paletteGroupComponent.isSelected() || (paletteItem = (PaletteItem)paletteGroupComponent.getItemsComponent().getSelectedValue()) == null) continue;
            return paletteItem;
        }
        return null;
    }

    @Override
    public void clearActiveItem() {
        if (this.getActiveItem() != null) {
            for (PaletteItemsComponent paletteItemsComponent : this.f) {
                paletteItemsComponent.clearSelection();
            }
            this.a(null);
        }
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    public void loadPalette(@Nullable DesignerEditorPanel designerEditorPanel) {
        if (this.c == null && designerEditorPanel == null) {
            return;
        }
        if (this.c != null && designerEditorPanel != null && this.d.equals(designerEditorPanel.getPaletteGroups())) {
            this.c = designerEditorPanel;
            this.a();
            return;
        }
        for (PaletteItemsComponent object : this.f) {
            object.removeListSelectionListener(this.g);
        }
        this.c = designerEditorPanel;
        this.b.removeAll();
        if (designerEditorPanel == null) {
            this.d = Collections.emptyList();
            this.a = Collections.emptyList();
            this.f = Collections.emptyList();
        } else {
            this.d = designerEditorPanel.getPaletteGroups();
            this.a = new ArrayList<PaletteGroupComponent>();
            this.f = new ArrayList<PaletteItemsComponent>();
        }
        for (PaletteGroup paletteGroup : this.d) {
            PaletteGroupComponent paletteGroupComponent = new PaletteGroupComponent(paletteGroup);
            PaletteItemsComponent paletteItemsComponent = new PaletteItemsComponent(paletteGroup, designerEditorPanel);
            paletteGroupComponent.setItemsComponent(paletteItemsComponent);
            paletteGroupComponent.addFocusListener(this.e);
            this.a.add(paletteGroupComponent);
            paletteItemsComponent.addListSelectionListener(this.g);
            this.f.add(paletteItemsComponent);
            this.b.add(paletteGroupComponent);
            this.b.add((Component)((Object)paletteItemsComponent));
        }
        this.b.revalidate();
        if (this.c != null) {
            this.a();
        }
    }

    private void a() {
        PaletteItem paletteItem = this.c.getActivePaletteItem();
        for (PaletteItemsComponent paletteItemsComponent : this.f) {
            paletteItemsComponent.restoreSelection(paletteItem);
        }
    }

    private void a(@Nullable ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null) {
            PaletteItemsComponent paletteItemsComponent = (PaletteItemsComponent)((Object)listSelectionEvent.getSource());
            for (int i2 = listSelectionEvent.getFirstIndex(); i2 <= listSelectionEvent.getLastIndex(); ++i2) {
                if (!paletteItemsComponent.isSelectedIndex(i2)) continue;
                for (PaletteItemsComponent paletteItemsComponent2 : this.f) {
                    if (paletteItemsComponent2 == paletteItemsComponent) continue;
                    paletteItemsComponent2.clearSelection();
                }
                PaletteItem paletteItem = (PaletteItem)paletteItemsComponent.getSelectedValue();
                if (paletteItem == null || paletteItem.isEnabled()) break;
                paletteItemsComponent.clearSelection();
                break;
            }
        }
        if (this.c != null) {
            this.c.activatePaletteItem(this.getActiveItem());
        }
    }

    public Object getData(@NonNls String string) {
        if (PlatformDataKeys.FILE_EDITOR.is(string) && this.c != null) {
            return this.c.getEditor();
        }
        return null;
    }
}

