/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.designer.propertyTable.TablePanelActionPolicy;
import com.intellij.designer.propertyTable.actions.IPropertyTableAction;
import com.intellij.designer.propertyTable.actions.RestoreDefault;
import com.intellij.designer.propertyTable.actions.ShowColumns;
import com.intellij.designer.propertyTable.actions.ShowExpert;
import com.intellij.designer.propertyTable.actions.ShowJavadoc;
import com.intellij.designer.propertyTable.actions.TableTabAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyTablePanel
extends JPanel
implements ListSelectionListener {
    private static final String i = "SWING_BUTTON_KEY";
    private final RadPropertyTable c;
    private final AnAction[] h;
    private final JPanel b;
    private final JPanel a;
    private PropertyTableTab[] g;
    private PropertyTableTab f;
    private TablePanelActionPolicy e;
    private final JLabel d;

    public PropertyTablePanel(final Project project2) {
        this.c = new RadPropertyTable(project2){

            protected void updateEditActions() {
                PropertyTablePanel.this.updateActions();
            }
        };
        this.setLayout(new GridBagLayout());
        int n2 = 0;
        this.d = new JLabel(DesignerBundle.message("designer.properties.title", new Object[0]));
        this.d.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.add((Component)this.d, new GridBagConstraints(n2++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 5, 2, 10), 0, 0));
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ShowJavadoc showJavadoc = new ShowJavadoc(this.c);
        showJavadoc.registerCustomShortcutSet(actionManager.getAction("QuickJavaDoc").getShortcutSet(), (JComponent)((Object)this.c));
        defaultActionGroup.add((AnAction)showJavadoc);
        defaultActionGroup.addSeparator();
        RestoreDefault restoreDefault = new RestoreDefault(this.c);
        restoreDefault.registerCustomShortcutSet(actionManager.getAction("$Delete").getShortcutSet(), (JComponent)((Object)this.c));
        defaultActionGroup.add((AnAction)restoreDefault);
        defaultActionGroup.add((AnAction)new ShowExpert(this.c));
        this.b = new JPanel(new FlowLayout(1, 5, 0));
        this.add((Component)this.b, new GridBagConstraints(n2++, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.a = new JPanel(new FlowLayout(1, 5, 0));
        this.add((Component)this.a, new GridBagConstraints(n2++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.h = defaultActionGroup.getChildren(null);
        for (AnAction anAction : this.h) {
            if (anAction instanceof Separator) continue;
            Presentation presentation = anAction.getTemplatePresentation();
            ActionButton actionButton = new ActionButton(anAction, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.a.add((Component)actionButton);
            presentation.putClientProperty(i, (Object)actionButton);
        }
        defaultActionGroup.add((AnAction)new ShowColumns(this.c));
        PopupHandler.installPopupHandler((JComponent)((Object)this.c), (ActionGroup)defaultActionGroup, (String)"GuiDesigner.PropertyInspectorPopup", (ActionManager)actionManager);
        this.c.getSelectionModel().addListSelectionListener(this);
        this.valueChanged(null);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.c));
        jScrollPane.setBorder(IdeBorderFactory.createBorder((int)2));
        this.c.initQuickFixManager(jScrollPane.getViewport());
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, n2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.c.setPropertyTablePanel(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                IdeFocusManager.getInstance((Project)project2).requestFocus((Component)((Object)PropertyTablePanel.this.c), true);
            }
        });
    }

    public void setArea(@Nullable DesignerEditorPanel designerEditorPanel, @Nullable EditableArea editableArea) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = objectArray2 = designerEditorPanel == null ? null : designerEditorPanel.getPropertyTableTabs();
        if (!Comparing.equal((Object[])this.g, (Object[])objectArray2)) {
            this.g = objectArray2;
            this.b.removeAll();
            if (objectArray2 != null && objectArray2.length > 1) {
                if (!ArrayUtil.contains((Object)this.f, (Object[])objectArray2)) {
                    this.f = objectArray2[0];
                }
                objectArray = objectArray2;
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = objectArray[i2];
                    this.b.add((Component)new TableTabAction(this, (PropertyTableTab)object).getButton());
                }
            } else {
                this.f = null;
            }
            this.d.setVisible(this.f == null);
            this.b.revalidate();
        }
        Object object = objectArray = designerEditorPanel == null ? TablePanelActionPolicy.EMPTY : designerEditorPanel.getTablePanelActionPolicy();
        if (!Comparing.equal((Object)this.e, (Object)objectArray)) {
            this.e = objectArray;
            for (AnAction anAction : this.h) {
                if (anAction instanceof Separator) continue;
                boolean bl2 = objectArray.showAction(anAction);
                Presentation presentation = anAction.getTemplatePresentation();
                presentation.setVisible(bl2);
                JComponent jComponent = (JComponent)presentation.getClientProperty(i);
                if (jComponent == null) continue;
                jComponent.setVisible(bl2);
            }
            this.a.revalidate();
        }
        this.c.setArea(designerEditorPanel, editableArea);
    }

    public RadPropertyTable getPropertyTable() {
        return this.c;
    }

    @Nullable
    public PropertyTableTab getCurrentTab() {
        return this.f;
    }

    public void setCurrentTab(@NotNull PropertyTableTab propertyTableTab) {
        if (propertyTableTab == null) {
            PropertyTablePanel.a(0);
        }
        this.f = propertyTableTab;
        for (Component component : this.b.getComponents()) {
            ActionButton actionButton = (ActionButton)component;
            TableTabAction tableTabAction = (TableTabAction)actionButton.getAction();
            tableTabAction.updateState();
        }
        this.c.update();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateActions();
    }

    public void updateActions() {
        for (AnAction anAction : this.h) {
            if (!(anAction instanceof IPropertyTableAction)) continue;
            ((IPropertyTableAction)anAction).update();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTab", "com/intellij/designer/propertyTable/PropertyTablePanel", "setCurrentTab"));
    }
}

