/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.actions;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.designer.propertyTable.actions.IPropertyTableAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;

public class ShowJavadoc
extends AnAction
implements IPropertyTableAction {
    private final RadPropertyTable a;

    public ShowJavadoc(RadPropertyTable radPropertyTable) {
        this.a = radPropertyTable;
        Presentation presentation = this.getTemplatePresentation();
        String string = DesignerBundle.message("designer.properties.show.javadoc", new Object[0]);
        presentation.setText(string);
        presentation.setDescription(string);
        presentation.setIcon(AllIcons.Actions.Help);
    }

    public void update(AnActionEvent anActionEvent) {
        ShowJavadoc.a(this.a, anActionEvent, anActionEvent.getPresentation());
    }

    @Override
    public void update() {
        ShowJavadoc.a(this.a, null, this.getTemplatePresentation());
    }

    private static void a(RadPropertyTable radPropertyTable, AnActionEvent anActionEvent, Presentation presentation) {
        Property property = radPropertyTable.getSelectionProperty();
        presentation.setEnabled(!(property == null || radPropertyTable.isEditing() || property.getJavadocElement() == null && StringUtil.isEmpty((String)property.getJavadocText()) || anActionEvent != null && anActionEvent.getProject() == null));
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        ActionCallback actionCallback;
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            return;
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)project2);
        DocumentationComponent documentationComponent = new DocumentationComponent(documentationManager);
        Property property = this.a.getSelectionProperty();
        if (property == null) {
            return;
        }
        PsiElement psiElement = property.getJavadocElement();
        if (psiElement == null) {
            actionCallback = new ActionCallback();
            documentationComponent.setText(property.getJavadocText(), null, true);
        } else {
            actionCallback = documentationManager.queueFetchDocInfo(psiElement, documentationComponent);
        }
        actionCallback.doWhenProcessed(() -> {
            JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)documentationComponent, (JComponent)documentationComponent).setProject(project2).setDimensionServiceKey(project2, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(DesignerBundle.message("designer.properties.javadoc.title", property.getName())).setCancelCallback(() -> {
                Disposer.dispose((Disposable)documentationComponent);
                return Boolean.TRUE;
            }).createPopup();
            documentationComponent.setHint(jBPopup);
            Disposer.register((Disposable)jBPopup, (Disposable)documentationComponent);
            jBPopup.show(new RelativePoint((Component)this.a.getParent(), new Point(0, 0)));
        });
        if (psiElement == null) {
            actionCallback.setDone();
        }
    }
}

