/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.jshell.JShellHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

class DropJShellStateAction
extends AnAction {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.execution.jshell.ExecuteJShellAction");
    private static final AnAction a = new DropJShellStateAction();

    private DropJShellStateAction() {
        super("Drop All Code Snippets", "Invalidate all code snippets in the associated JShell instance", AllIcons.Actions.Delete);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(anActionEvent.getDataContext());
        if (virtualFile == null) {
            return;
        }
        try {
            JShellHandler jShellHandler = JShellHandler.getAssociatedHandler(virtualFile);
            if (jShellHandler != null) {
                jShellHandler.toFront();
                jShellHandler.dropState();
            }
        }
        catch (Exception exception) {
            b.info((Throwable)exception);
        }
    }

    public static AnAction getSharedInstance() {
        return a;
    }
}

