/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.remote.RemoteConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements RunConfigurationWithSuppressedDefaultRunAction,
RemoteRunProfile {
    public boolean USE_SOCKET_TRANSPORT = true;
    public boolean SERVER_MODE;
    public String SHMEM_ADDRESS = "javadebug";
    public String HOST = "localhost";
    public String PORT = "5005";

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RemoteConfiguration.a(0);
        }
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RemoteConfiguration.a(1);
        }
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public RemoteConfiguration(Project project2, ConfigurationFactory configurationFactory) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project2, true), configurationFactory);
    }

    public RemoteConnection createRemoteConnection() {
        return new RemoteConnection(this.USE_SOCKET_TRANSPORT, this.HOST, this.USE_SOCKET_TRANSPORT ? this.PORT : this.SHMEM_ADDRESS, this.SERVER_MODE);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        GenericDebuggerRunnerSettings genericDebuggerRunnerSettings;
        if (executor == null) {
            RemoteConfiguration.a(2);
        }
        if (executionEnvironment == null) {
            RemoteConfiguration.a(3);
        }
        if ((genericDebuggerRunnerSettings = (GenericDebuggerRunnerSettings)executionEnvironment.getRunnerSettings()) != null) {
            genericDebuggerRunnerSettings.LOCAL = false;
            genericDebuggerRunnerSettings.setDebugPort(this.USE_SOCKET_TRANSPORT ? this.PORT : this.SHMEM_ADDRESS);
            genericDebuggerRunnerSettings.setTransport(this.USE_SOCKET_TRANSPORT ? 0 : 1);
        }
        return new RemoteStateState(this.getProject(), this.createRemoteConnection());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup settingsEditorGroup = new SettingsEditorGroup();
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new RemoteConfigurable(this.getProject()));
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup2 = settingsEditorGroup;
        if (settingsEditorGroup2 == null) {
            RemoteConfiguration.a(4);
        }
        return settingsEditorGroup2;
    }

    public Collection<Module> getValidModules() {
        return this.getAllModules();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/remote/RemoteConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/remote/RemoteConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

