/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.AbstractApplicationConfigurationProducer;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.execution.scratch.JavaScratchConfigurationType;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JavaScratchConfigurationProducer
extends AbstractApplicationConfigurationProducer<JavaScratchConfiguration> {
    public JavaScratchConfigurationProducer() {
        super(JavaScratchConfigurationType.getInstance());
    }

    @Override
    protected boolean setupConfigurationFromContext(JavaScratchConfiguration javaScratchConfiguration, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        Location location = configurationContext.getLocation();
        if (location != null && (virtualFile = location.getVirtualFile()) instanceof VirtualFileWithId && virtualFile.getFileType() == ScratchFileType.INSTANCE && (psiFile = location.getPsiElement().getContainingFile()) != null && psiFile.getLanguage() == JavaLanguage.INSTANCE) {
            javaScratchConfiguration.SCRATCH_FILE_ID = ((VirtualFileWithId)virtualFile).getId();
            return super.setupConfigurationFromContext(javaScratchConfiguration, configurationContext, ref);
        }
        return false;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext configurationFromContext, @NotNull ConfigurationFromContext configurationFromContext2) {
        if (configurationFromContext == null) {
            JavaScratchConfigurationProducer.a(0);
        }
        if (configurationFromContext2 == null) {
            JavaScratchConfigurationProducer.a(1);
        }
        return configurationFromContext2.isProducedBy(AbstractApplicationConfigurationProducer.class) && !configurationFromContext2.isProducedBy(JavaScratchConfigurationProducer.class);
    }

    @Override
    public boolean isConfigurationFromContext(JavaScratchConfiguration javaScratchConfiguration, ConfigurationContext configurationContext) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        PsiElement psiElement = configurationContext.getPsiLocation();
        PsiClass psiClass = ApplicationConfigurationType.getMainClass(psiElement);
        return psiClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass), (String)javaScratchConfiguration.getMainClassName()) && (virtualFile = javaScratchConfiguration.getScratchVirtualFile()) != null && (psiFile = psiClass.getContainingFile()) != null && virtualFile.equals(psiFile.getVirtualFile());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "self";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "other";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/scratch/JavaScratchConfigurationProducer";
        objectArray[2] = "shouldReplace";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

