/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.stacktrace;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.stacktrace.MethodLineLocation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;

public class StackTraceLine {
    private final Project b;
    private final String a;
    @NonNls
    protected static final String AT_STR = "at";
    protected static final String AT__STR = "at ";
    @NonNls
    protected static final String INIT_MESSAGE = "<init>";

    public StackTraceLine(Project project2, String string) {
        this.b = project2;
        this.a = string;
    }

    public String getClassName() {
        int n2 = this.a.indexOf(AT_STR);
        if (n2 < 0) {
            return null;
        }
        n2 += AT__STR.length();
        int n3 = this.b();
        if (n3 < 0) {
            return null;
        }
        if (n3 <= n2) {
            return null;
        }
        return this.a.substring(n2, n3);
    }

    private int b() {
        return this.a.lastIndexOf(46, this.a());
    }

    private int a() {
        return this.a.indexOf(40);
    }

    private int c() {
        return this.a.indexOf(41);
    }

    public int getLineNumber() throws NumberFormatException {
        int n2 = this.c();
        int n3 = this.a.lastIndexOf(58) + 1;
        if (n2 < 0 || n3 < 1 || n3 >= n2) {
            throw new NumberFormatException(this.a);
        }
        return Integer.parseInt(this.a.substring(n3, n2)) - 1;
    }

    public OpenFileDescriptor getOpenFileDescriptor(VirtualFile virtualFile) {
        int n2;
        try {
            n2 = this.getLineNumber();
        }
        catch (NumberFormatException numberFormatException) {
            return new OpenFileDescriptor(this.b, virtualFile);
        }
        return new OpenFileDescriptor(this.b, virtualFile, n2, 0);
    }

    public OpenFileDescriptor getOpenFileDescriptor(Project project2) {
        Location<PsiMethod> location = this.getMethodLocation(project2);
        if (location == null) {
            return null;
        }
        return this.getOpenFileDescriptor(((PsiMethod)location.getPsiElement()).getContainingFile().getVirtualFile());
    }

    public String getMethodName() {
        int n2 = this.b();
        if (n2 == -1) {
            return null;
        }
        return this.a.substring(this.b() + 1, this.a());
    }

    public Location<PsiMethod> getMethodLocation(Project project2) {
        PsiMethod psiMethod;
        PsiClass psiClass;
        PsiElement psiElement;
        int n2;
        String string = this.getClassName();
        String string2 = this.getMethodName();
        if (string == null || string2 == null) {
            return null;
        }
        try {
            n2 = this.getLineNumber();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        int n3 = string.indexOf(36);
        if (n3 != -1) {
            string = string.substring(0, n3);
        }
        PsiElement psiElement2 = psiElement = (psiClass = StackTraceLine.a(project2, string, n2)) == null ? null : psiClass.getNavigationElement();
        if (psiClass == null || psiElement instanceof PsiCompiledElement) {
            return null;
        }
        if (psiElement instanceof PsiClass && (psiMethod = StackTraceLine.a((PsiClass)psiElement, string2, n2)) != null) {
            return new MethodLineLocation(project2, psiMethod, (Location<PsiClass>)PsiLocation.fromPsiElement((PsiElement)((PsiClass)psiElement)), n2);
        }
        return null;
    }

    private static PsiClass a(Project project2, String string, int n2) {
        PsiElement psiElement;
        if (project2 == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(string, GlobalSearchScope.allScope((Project)project2));
        PsiElement psiElement2 = psiElement = psiClass == null ? null : psiClass.getNavigationElement();
        if (psiClass == null || psiElement instanceof PsiCompiledElement) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(StackTraceLine.a(psiFile, n2)), PsiClass.class, (boolean)false);
    }

    private static PsiMethod a(PsiClass psiClass, String string, int n2) {
        PsiMethod[] psiMethodArray = INIT_MESSAGE.equals(string) ? psiClass.getConstructors() : psiClass.findMethodsByName(string, true);
        if (psiMethodArray.length == 0) {
            return null;
        }
        PsiFile psiFile = psiMethodArray[0].getContainingFile();
        int n3 = StackTraceLine.a(psiFile, n2);
        for (PsiMethod psiMethod : psiMethodArray) {
            if (!psiMethod.getTextRange().contains(n3)) continue;
            return psiMethod;
        }
        return null;
    }

    private static int a(PsiFile psiFile, int n2) {
        LineTokenizer lineTokenizer = new LineTokenizer(psiFile.getViewProvider().getContents());
        for (int i2 = 0; i2 < n2; ++i2) {
            lineTokenizer.advance();
        }
        return lineTokenizer.getOffset();
    }
}

