/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.ResetConfigurationModuleAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaAwareTestConsoleProperties<T extends ModuleBasedConfiguration<JavaRunConfigurationModule>>
extends SMTRunnerConsoleProperties {
    public JavaAwareTestConsoleProperties(String string, RunConfiguration runConfiguration, Executor executor) {
        super(runConfiguration, string, executor);
        this.setPrintTestingStartedTime(false);
    }

    public boolean isPaused() {
        DebuggerSession debuggerSession = this.getDebugSession();
        return debuggerSession != null && debuggerSession.isPaused();
    }

    public T getConfiguration() {
        return (T)((ModuleBasedConfiguration)super.getConfiguration());
    }

    public int getSelectionMode() {
        return 4;
    }

    public boolean fixEmptySuite() {
        return ResetConfigurationModuleAdapter.tryWithAnotherModule(this.getConfiguration(), this.isDebug());
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String string) {
        if (location == null) {
            JavaAwareTestConsoleProperties.a(0);
        }
        if (string == null) {
            JavaAwareTestConsoleProperties.a(1);
        }
        return JavaAwareTestConsoleProperties.getStackTraceErrorNavigatable(location, string);
    }

    @Nullable
    public static Navigatable getStackTraceErrorNavigatable(@NotNull Location<?> location, @NotNull String string) {
        String[] stringArray;
        PsiLocation psiLocation;
        PsiClass psiClass;
        if (location == null) {
            JavaAwareTestConsoleProperties.a(2);
        }
        if (string == null) {
            JavaAwareTestConsoleProperties.a(3);
        }
        if ((psiClass = (PsiClass)(psiLocation = location.toPsiLocation()).getParentElement(PsiClass.class)) == null) {
            return null;
        }
        String string2 = psiClass.getQualifiedName();
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        Object object = psiLocation.getAncestors(PsiMethod.class, false);
        while (object.hasNext()) {
            stringArray = (String[])((Location)object.next()).getPsiElement();
            if (!psiClass.equals(stringArray.getContainingClass())) continue;
            string3 = stringArray.getName();
        }
        if (string3 == null) {
            return null;
        }
        object = null;
        for (String string4 : stringArray = new LineTokenizer(string).execute()) {
            StackTraceLine stackTraceLine = new StackTraceLine(psiClass.getProject(), string4);
            if (!string3.equals(stackTraceLine.getMethodName()) || !string2.equals(stackTraceLine.getClassName())) continue;
            object = stackTraceLine;
            break;
        }
        return object != null ? ((StackTraceLine)object).getOpenFileDescriptor(psiClass.getContainingFile().getVirtualFile()) : null;
    }

    @Nullable
    public DebuggerSession getDebugSession() {
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx(this.getProject());
        if (debuggerManagerEx == null) {
            return null;
        }
        Collection<DebuggerSession> collection = debuggerManagerEx.getSessions();
        for (DebuggerSession debuggerSession : collection) {
            if (this.getConsole() != debuggerSession.getProcess().getExecutionResult().getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    public boolean isEditable() {
        return Registry.is((String)"editable.java.test.console");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/JavaAwareTestConsoleProperties";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorNavigatable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStackTraceErrorNavigatable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

