/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParametersUtil {
    private JavaParametersUtil() {
    }

    public static void configureConfiguration(SimpleJavaParameters simpleJavaParameters, CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters) {
        String string;
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)simpleJavaParameters, (CommonProgramRunConfigurationParameters)commonJavaRunConfigurationParameters);
        Project project2 = commonJavaRunConfigurationParameters.getProject();
        Module module2 = ProgramParametersUtil.getModule((CommonProgramRunConfigurationParameters)commonJavaRunConfigurationParameters);
        String string2 = commonJavaRunConfigurationParameters.getAlternativeJrePath();
        if (string2 != null) {
            commonJavaRunConfigurationParameters.setAlternativeJrePath(ProgramParametersUtil.expandPath((String)string2, null, (Project)project2));
        }
        if ((string = commonJavaRunConfigurationParameters.getVMParameters()) != null) {
            string = ProgramParametersUtil.expandPath((String)string, (Module)module2, (Project)project2);
            for (Map.Entry entry : simpleJavaParameters.getEnv().entrySet()) {
                string = StringUtil.replace((String)string, (String)("$" + (String)entry.getKey() + "$"), (String)((String)entry.getValue()), (boolean)false);
            }
        }
        simpleJavaParameters.getVMParametersList().addParametersString(string);
    }

    public static int getClasspathType(RunConfigurationModule runConfigurationModule, String string, boolean bl2) throws CantRunException {
        return JavaParametersUtil.getClasspathType(runConfigurationModule, string, bl2, false);
    }

    public static int getClasspathType(RunConfigurationModule runConfigurationModule, String string, boolean bl2, boolean bl3) throws CantRunException {
        Module module2 = runConfigurationModule.getModule();
        if (module2 == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        Boolean bl4 = JavaParametersUtil.isClassInProductionSources(string, module2);
        if (bl4 == null) {
            if (!bl2) {
                return 7;
            }
            throw CantRunException.classNotFound((String)string, (Module)module2);
        }
        return bl4.booleanValue() ? (bl3 ? 11 : 3) : 7;
    }

    @Nullable(value="null if class not found")
    public static Boolean isClassInProductionSources(@NotNull String string, @NotNull Module module2) {
        ModuleFileIndex moduleFileIndex;
        Module module3;
        PsiClass psiClass;
        if (string == null) {
            JavaParametersUtil.a(0);
        }
        if (module2 == null) {
            JavaParametersUtil.a(1);
        }
        if ((psiClass = JavaExecutionUtil.findMainClass((Module)module2, (String)string)) == null) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module4 = module3 = psiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (module3 == null) {
            module3 = module2;
        }
        if ((moduleFileIndex = ModuleRootManager.getInstance((Module)module3).getFileIndex()).isInSourceContent(virtualFile)) {
            return !moduleFileIndex.isInTestSourceContent(virtualFile);
        }
        List list2 = moduleFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry orderEntry : list2) {
            if (!(orderEntry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)orderEntry).getScope() != DependencyScope.TEST) continue;
            return false;
        }
        return true;
    }

    public static void configureModule(RunConfigurationModule runConfigurationModule, JavaParameters javaParameters, int n2, @Nullable String string) throws CantRunException {
        Module module2 = runConfigurationModule.getModule();
        if (module2 == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        JavaParametersUtil.configureModule(module2, javaParameters, n2, string);
    }

    public static void configureModule(Module module2, JavaParameters javaParameters, int n2, @Nullable String string) throws CantRunException {
        javaParameters.configureByModule(module2, n2, JavaParametersUtil.createModuleJdk(module2, (n2 & 4) == 0, string));
    }

    public static void configureProject(Project project2, JavaParameters javaParameters, int n2, @Nullable String string) throws CantRunException {
        javaParameters.configureByProject(project2, n2, JavaParametersUtil.createProjectJdk(project2, string));
    }

    public static Sdk createModuleJdk(Module module2, boolean bl2, @Nullable String string) throws CantRunException {
        return string == null ? JavaParameters.getValidJdkToRunModule((Module)module2, (boolean)bl2) : JavaParametersUtil.a(string);
    }

    public static Sdk createProjectJdk(Project project2, @Nullable String string) throws CantRunException {
        return string == null ? JavaParametersUtil.a(project2) : JavaParametersUtil.a(string);
    }

    private static Sdk a(Project project2) throws CantRunException {
        Sdk sdk = PathUtilEx.getAnyJdk((Project)project2);
        if (sdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return sdk;
    }

    private static Sdk a(@NotNull String string) throws CantRunException {
        Sdk sdk;
        if (string == null) {
            JavaParametersUtil.a(2);
        }
        if ((sdk = ProjectJdkTable.getInstance().findJdk(string)) != null) {
            return sdk;
        }
        if (!JdkUtil.checkForJre((String)string)) {
            throw new CantRunException(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{string}));
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        return javaSdk.createJdk((String)ObjectUtils.notNull((Object)javaSdk.getVersionString(string), (Object)""), string);
    }

    public static void checkAlternativeJRE(@NotNull CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters) throws RuntimeConfigurationWarning {
        if (commonJavaRunConfigurationParameters == null) {
            JavaParametersUtil.a(3);
        }
        if (commonJavaRunConfigurationParameters.isAlternativeJrePathEnabled()) {
            JavaParametersUtil.checkAlternativeJRE(commonJavaRunConfigurationParameters.getAlternativeJrePath());
        }
    }

    public static void checkAlternativeJRE(@Nullable String string) throws RuntimeConfigurationWarning {
        if (StringUtil.isEmptyOrSpaces((String)string) || ProjectJdkTable.getInstance().findJdk(string) == null && !JdkUtil.checkForJre((String)string)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{string}));
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jreHome";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/util/JavaParametersUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassInProductionSources";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAlternativeJdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAlternativeJRE";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

