/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurableGroup;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetEditorImpl
extends UnnamedConfigurableGroup
implements UnnamedConfigurable,
FacetEditor {
    private final FacetEditorTab[] e;
    private final FacetErrorPanel h;
    private JComponent b;
    @Nullable
    private TabbedPaneWrapper a;
    private final FacetEditorContext f;
    private final Set<FacetEditorTab> g = new HashSet<FacetEditorTab>();
    private int d = 0;
    private final Disposable c = Disposer.newDisposable();

    public FacetEditorImpl(FacetEditorContext facetEditorContext, FacetConfiguration facetConfiguration) {
        this.f = facetEditorContext;
        this.h = new FacetErrorPanel();
        for (FacetEditorTab facetEditorTab : this.e = facetConfiguration.createEditorTabs(facetEditorContext, this.h.getValidatorsManager())) {
            this.add((UnnamedConfigurable)facetEditorTab);
        }
    }

    public void reset() {
        super.reset();
        this.h.getValidatorsManager().validate();
    }

    public JComponent getComponent() {
        if (this.b == null) {
            this.b = this.createComponent();
        }
        return this.b;
    }

    public JComponent createComponent() {
        JComponent jComponent;
        TabbedPaneWrapper tabbedPaneWrapper;
        if (this.e.length > 1) {
            tabbedPaneWrapper = new TabbedPaneWrapper(this.c);
            for (FacetEditorTab facetEditorTab : this.e) {
                JComponent jComponent2 = facetEditorTab.createComponent();
                UIUtil.addInsets((JComponent)jComponent2, (Insets)UIUtil.PANEL_SMALL_INSETS);
                tabbedPaneWrapper.addTab(facetEditorTab.getDisplayName(), jComponent2);
            }
            tabbedPaneWrapper.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(@NotNull ChangeEvent changeEvent) {
                    if (changeEvent == null) {
                        1.a(0);
                    }
                    FacetEditorImpl.this.e[FacetEditorImpl.this.d].onTabLeaving();
                    FacetEditorImpl.this.d = tabbedPaneWrapper.getSelectedIndex();
                    FacetEditorImpl.this.a(FacetEditorImpl.this.e[FacetEditorImpl.this.d]);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/facet/impl/ui/FacetEditorImpl$1", "stateChanged"));
                }
            });
            jComponent = tabbedPaneWrapper.getComponent();
            this.a = tabbedPaneWrapper;
        } else if (this.e.length == 1) {
            jComponent = this.e[0].createComponent();
            UIUtil.addInsets((JComponent)jComponent, (Insets)JBUI.insets((int)0, (int)5, (int)0, (int)0));
        } else {
            jComponent = new JPanel();
        }
        tabbedPaneWrapper = this.f.getFacet().getExternalSource();
        if (tabbedPaneWrapper != null) {
            this.h.getValidatorsManager().registerValidator(new FacetEditorValidator((ProjectModelExternalSource)tabbedPaneWrapper){
                final /* synthetic */ ProjectModelExternalSource val$externalSource;
                {
                    this.val$externalSource = projectModelExternalSource;
                }

                @NotNull
                public ValidationResult check() {
                    if (FacetEditorImpl.this.isModified()) {
                        String string = ModificationOfImportedModelWarningComponent.getWarningText("Facet '" + FacetEditorImpl.this.f.getFacetName() + "'", this.val$externalSource);
                        ValidationResult validationResult = new ValidationResult(string);
                        if (validationResult == null) {
                            2.a(0);
                        }
                        return validationResult;
                    }
                    ValidationResult validationResult = ValidationResult.OK;
                    if (validationResult == null) {
                        2.a(1);
                    }
                    return validationResult;
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorImpl$2", "check"));
                }
            }, new JComponent[]{jComponent});
        }
        JComponent jComponent3 = this.h.getComponent();
        UIUtil.addInsets((JComponent)jComponent3, (Insets)JBUI.insets((int)0, (int)5, (int)5, (int)0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", jComponent);
        jPanel.add("South", jComponent3);
        return jPanel;
    }

    private void a(FacetEditorTab facetEditorTab) {
        JComponent jComponent;
        facetEditorTab.onTabEntering();
        if (this.g.add(facetEditorTab) && (jComponent = facetEditorTab.getPreferredFocusedComponent()) != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (jComponent.isShowing()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)jComponent, true));
                }
            });
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.c);
        this.h.disposeUIResources();
        super.disposeUIResources();
    }

    @Nullable
    public String getHelpTopic() {
        return 0 <= this.d && this.d < this.e.length ? this.e[this.d].getHelpTopic() : null;
    }

    public void onFacetAdded(@NotNull Facet facet) {
        if (facet == null) {
            FacetEditorImpl.a(0);
        }
        for (FacetEditorTab facetEditorTab : this.e) {
            facetEditorTab.onFacetInitialized(facet);
        }
    }

    public void setSelectedTabName(String string) {
        this.getComponent();
        TabbedPaneWrapper tabbedPaneWrapper = this.a;
        if (tabbedPaneWrapper == null) {
            return;
        }
        for (int i2 = 0; i2 < tabbedPaneWrapper.getTabCount(); ++i2) {
            if (!string.equals(tabbedPaneWrapper.getTitleAt(i2))) continue;
            tabbedPaneWrapper.setSelectedIndex(i2);
            return;
        }
    }

    public FacetEditorContext getContext() {
        return this.f;
    }

    public void onFacetSelected() {
        if (this.d < this.e.length) {
            this.a(this.e[this.d]);
        }
    }

    public FacetEditorTab[] getEditorTabs() {
        return this.e;
    }

    public <T extends FacetEditorTab> T getEditorTab(@NotNull Class<T> clazz) {
        if (clazz == null) {
            FacetEditorImpl.a(1);
        }
        for (FacetEditorTab facetEditorTab : this.e) {
            if (!clazz.isInstance(facetEditorTab)) continue;
            return (T)((FacetEditorTab)clazz.cast(facetEditorTab));
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/facet/impl/ui/FacetEditorImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onFacetAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

