/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadingOptionsDialog
extends DialogWrapper {
    private static final Logger g = Logger.getInstance((String)"#com.intellij.facet.impl.ui.libraries.DownloadingOptionsDialog");
    private JPanel e;
    private CheckBoxList c;
    private TextFieldWithBrowseButton k;
    private JCheckBox j;
    private JCheckBox h;
    private JLabel l;
    private JLabel d;
    private JPanel b;
    private final JComboBox m;
    private final LibraryNameAndLevelPanel a;
    private final DownloadableLibraryType i;
    private FrameworkLibraryVersion f;

    public DownloadingOptionsDialog(@NotNull Component component, @NotNull LibraryDownloadSettings libraryDownloadSettings, @NotNull List<? extends FrameworkLibraryVersion> list2, boolean bl2) {
        int n2;
        if (component == null) {
            DownloadingOptionsDialog.a(0);
        }
        if (libraryDownloadSettings == null) {
            DownloadingOptionsDialog.a(1);
        }
        if (list2 == null) {
            DownloadingOptionsDialog.a(2);
        }
        super(component, true);
        this.c();
        this.setTitle("Downloading Options");
        this.i = libraryDownloadSettings.getLibraryType();
        g.assertTrue(!list2.isEmpty());
        FormBuilder formBuilder = LibraryNameAndLevelPanel.createFormBuilder();
        this.m = new ComboBox();
        for (FrameworkLibraryVersion frameworkLibraryVersion : list2) {
            this.m.addItem(frameworkLibraryVersion);
        }
        this.m.setRenderer(new ListCellRendererWrapper<FrameworkLibraryVersion>(){

            public void customize(JList jList, FrameworkLibraryVersion frameworkLibraryVersion, int n2, boolean bl2, boolean bl3) {
                this.setText(frameworkLibraryVersion.getDefaultLibraryName());
            }
        });
        this.m.setSelectedItem(libraryDownloadSettings.getVersion());
        if (list2.size() > 1) {
            formBuilder.addLabeledComponent("&Version:", (JComponent)this.m);
        }
        this.a = bl2 ? new LibraryNameAndLevelPanel(formBuilder, libraryDownloadSettings.getLibraryName(), libraryDownloadSettings.getLibraryLevel()) : null;
        this.b.add(formBuilder.getPanel());
        this.a(libraryDownloadSettings.getSelectedDownloads());
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DownloadingOptionsDialog.this.a(null);
            }
        });
        this.c.setBorder(null);
        this.l.setLabelFor((Component)this.c);
        this.k.addBrowseFolderListener(ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.title", (Object[])new Object[0]), ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.description", (Object[])new Object[0]), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.d.setLabelFor((Component)this.k);
        this.k.setText(FileUtil.toSystemDependentName((String)libraryDownloadSettings.getDirectoryForDownloadedLibrariesPath()));
        boolean bl3 = false;
        boolean bl4 = false;
        for (FrameworkLibraryVersion frameworkLibraryVersion : list2) {
            bl3 |= DownloadingOptionsDialog.a((List<? extends DownloadableLibraryFileDescription>)frameworkLibraryVersion.getFiles(), AdditionalDownloadType.SOURCES);
            n2 |= DownloadingOptionsDialog.a((List<? extends DownloadableLibraryFileDescription>)frameworkLibraryVersion.getFiles(), AdditionalDownloadType.DOCUMENTATION);
        }
        this.j.setVisible(bl3);
        this.h.setVisible(n2 != 0);
        this.c.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int n2, boolean bl2) {
                DownloadingOptionsDialog.this.a();
            }
        });
        this.a();
        this.j.setSelected(libraryDownloadSettings.isDownloadSources());
        this.h.setSelected(libraryDownloadSettings.isDownloadJavaDocs());
        this.init();
    }

    private void a() {
        boolean bl2;
        boolean bl3;
        FrameworkLibraryVersion frameworkLibraryVersion = this.getSelectedVersion();
        if (frameworkLibraryVersion == null) {
            bl3 = false;
            bl2 = false;
        } else {
            List<DownloadableLibraryFileDescription> list2 = this.a(frameworkLibraryVersion);
            bl2 = DownloadingOptionsDialog.a(list2, AdditionalDownloadType.SOURCES);
            bl3 = DownloadingOptionsDialog.a(list2, AdditionalDownloadType.DOCUMENTATION);
        }
        DownloadingOptionsDialog.a(this.j, bl2);
        DownloadingOptionsDialog.a(this.h, bl3);
    }

    private static void a(JCheckBox jCheckBox, boolean bl2) {
        if (!bl2) {
            jCheckBox.setSelected(false);
        }
        jCheckBox.setEnabled(bl2);
    }

    private static boolean a(List<? extends DownloadableLibraryFileDescription> list2, AdditionalDownloadType additionalDownloadType) {
        for (DownloadableLibraryFileDescription downloadableLibraryFileDescription : list2) {
            if ((additionalDownloadType != AdditionalDownloadType.SOURCES || downloadableLibraryFileDescription.getSourcesDescription() == null) && (additionalDownloadType != AdditionalDownloadType.DOCUMENTATION || downloadableLibraryFileDescription.getDocumentationDescription() == null)) continue;
            return true;
        }
        return false;
    }

    private void a(@Nullable List<? extends DownloadableLibraryFileDescription> list2) {
        FrameworkLibraryVersion frameworkLibraryVersion = this.getSelectedVersion();
        if (Comparing.equal((Object)this.f, (Object)frameworkLibraryVersion)) {
            return;
        }
        if (frameworkLibraryVersion != null) {
            List list3 = frameworkLibraryVersion.getFiles();
            this.c.setModel((ListModel)new CollectionListModel(ContainerUtil.map2Array((Collection)list3, JCheckBox.class, downloadableLibraryFileDescription -> {
                boolean bl2 = list2 != null ? list2.contains(downloadableLibraryFileDescription) : !downloadableLibraryFileDescription.isOptional();
                return new JCheckBox(downloadableLibraryFileDescription.getPresentableFileName(), bl2);
            })));
            if (this.a != null) {
                this.a.setDefaultName(frameworkLibraryVersion.getDefaultLibraryName());
            }
        }
        this.a();
        this.f = frameworkLibraryVersion;
    }

    protected JComponent createCenterPanel() {
        return this.e;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.c;
    }

    @Nullable
    public FrameworkLibraryVersion getSelectedVersion() {
        return (FrameworkLibraryVersion)this.m.getSelectedItem();
    }

    @Nullable
    public static LibraryDownloadSettings showDialog(@NotNull JComponent jComponent, @NotNull LibraryDownloadSettings libraryDownloadSettings, List<? extends FrameworkLibraryVersion> list2, boolean bl2) {
        DownloadingOptionsDialog downloadingOptionsDialog;
        if (jComponent == null) {
            DownloadingOptionsDialog.a(3);
        }
        if (libraryDownloadSettings == null) {
            DownloadingOptionsDialog.a(4);
        }
        if (!(downloadingOptionsDialog = new DownloadingOptionsDialog(jComponent, libraryDownloadSettings, list2, bl2)).showAndGet()) {
            return null;
        }
        return downloadingOptionsDialog.b();
    }

    private List<DownloadableLibraryFileDescription> a(FrameworkLibraryVersion frameworkLibraryVersion) {
        ArrayList<DownloadableLibraryFileDescription> arrayList = new ArrayList<DownloadableLibraryFileDescription>();
        List list2 = frameworkLibraryVersion.getFiles();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            if (!this.c.isItemSelected(i2)) continue;
            arrayList.add((DownloadableLibraryFileDescription)list2.get(i2));
        }
        return arrayList;
    }

    private LibraryDownloadSettings b() {
        LibrariesContainer.LibraryLevel libraryLevel;
        String string;
        FrameworkLibraryVersion frameworkLibraryVersion = this.getSelectedVersion();
        g.assertTrue(frameworkLibraryVersion != null);
        if (this.a != null) {
            string = this.a.getLibraryName();
            libraryLevel = this.a.getLibraryLevel();
        } else {
            string = frameworkLibraryVersion.getDefaultLibraryName();
            libraryLevel = LibrariesContainer.LibraryLevel.PROJECT;
        }
        String string2 = FileUtil.toSystemIndependentName((String)this.k.getText());
        List<DownloadableLibraryFileDescription> list2 = this.a(frameworkLibraryVersion);
        return new LibraryDownloadSettings(frameworkLibraryVersion, this.i, string2, string, libraryLevel, list2, this.j.isSelected(), this.h.isSelected());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/facet/impl/ui/libraries/DownloadingOptionsDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void c() {
        CheckBoxList checkBoxList;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JPanel jPanel2;
        this.e = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.l = jLabel2 = new JLabel();
        jLabel2.setText("Files to download:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.k = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 0, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        this.d = jLabel = new JLabel();
        jLabel.setText("Copy downloaded files to:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(22);
        jPanel2.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.j = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusable(false);
        jCheckBox2.setText("Download sources");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.h = jCheckBox = new JCheckBox();
        jCheckBox.setFocusable(false);
        jCheckBox.setText("Download javadocs");
        jCheckBox.setMnemonic('J');
        jCheckBox.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.b = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.c = checkBoxList = new CheckBoxList();
        jBScrollPane.setViewportView((Component)checkBoxList);
        jLabel2.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.e;
    }

    private static enum AdditionalDownloadType {
        SOURCES,
        DOCUMENTATION;

    }
}

