/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryCompositionSettings
implements Disposable {
    private final CustomLibraryDescription g;
    @NotNull
    private final NotNullComputable<String> d;
    private FrameworkLibraryVersionFilter i;
    private final List<? extends FrameworkLibraryVersion> k;
    private LibrariesContainer.LibraryLevel h;
    private NewLibraryEditor e;
    private Library f;
    private boolean b;
    private LibraryDownloadSettings c;
    private final Map<Library, ExistingLibraryEditor> j;
    private FrameworkLibraryProvider a;

    public LibraryCompositionSettings(@NotNull CustomLibraryDescription customLibraryDescription, @NotNull NotNullComputable<String> notNullComputable, @NotNull FrameworkLibraryVersionFilter frameworkLibraryVersionFilter, List<? extends FrameworkLibraryVersion> list2) {
        if (customLibraryDescription == null) {
            LibraryCompositionSettings.a(0);
        }
        if (notNullComputable == null) {
            LibraryCompositionSettings.a(1);
        }
        if (frameworkLibraryVersionFilter == null) {
            LibraryCompositionSettings.a(2);
        }
        this.j = ContainerUtil.newIdentityTroveMap();
        this.g = customLibraryDescription;
        this.d = notNullComputable;
        this.i = frameworkLibraryVersionFilter;
        this.h = customLibraryDescription.getDefaultLevel();
        this.k = list2;
        List<? extends FrameworkLibraryVersion> list3 = this.getCompatibleVersions();
        if (!list3.isEmpty()) {
            this.c = this.a(list3.get(0));
        }
    }

    private LibraryDownloadSettings a(FrameworkLibraryVersion frameworkLibraryVersion) {
        return new LibraryDownloadSettings(frameworkLibraryVersion, this.g.getDownloadableLibraryType(), this.h, LibraryCompositionSettings.a(this.getBaseDirectoryPath()));
    }

    public void setVersionFilter(@NotNull FrameworkLibraryVersionFilter frameworkLibraryVersionFilter) {
        if (frameworkLibraryVersionFilter == null) {
            LibraryCompositionSettings.a(3);
        }
        this.i = frameworkLibraryVersionFilter;
        if (this.c == null || !frameworkLibraryVersionFilter.isAccepted(this.c.getVersion())) {
            FrameworkLibraryVersion frameworkLibraryVersion = (FrameworkLibraryVersion)ContainerUtil.getFirstItem(this.getCompatibleVersions());
            this.c = frameworkLibraryVersion != null ? this.a(frameworkLibraryVersion) : null;
        }
    }

    public List<? extends FrameworkLibraryVersion> getCompatibleVersions() {
        ArrayList<FrameworkLibraryVersion> arrayList = new ArrayList<FrameworkLibraryVersion>();
        for (FrameworkLibraryVersion frameworkLibraryVersion : this.k) {
            if (!this.i.isAccepted(frameworkLibraryVersion)) continue;
            arrayList.add(frameworkLibraryVersion);
        }
        return arrayList;
    }

    private static String a(@NotNull String string) {
        if (string == null) {
            LibraryCompositionSettings.a(4);
        }
        return string.isEmpty() ? "lib" : string + "/lib";
    }

    public void setDownloadSettings(LibraryDownloadSettings libraryDownloadSettings) {
        this.c = libraryDownloadSettings;
    }

    public ExistingLibraryEditor getOrCreateEditor(@NotNull Library library) {
        ExistingLibraryEditor existingLibraryEditor;
        if (library == null) {
            LibraryCompositionSettings.a(5);
        }
        if ((existingLibraryEditor = this.j.get(library)) == null) {
            existingLibraryEditor = new ExistingLibraryEditor(library, null);
            Disposer.register((Disposable)this, (Disposable)existingLibraryEditor);
            this.j.put(library, existingLibraryEditor);
        }
        return existingLibraryEditor;
    }

    @NotNull
    public CustomLibraryDescription getLibraryDescription() {
        CustomLibraryDescription customLibraryDescription = this.g;
        if (customLibraryDescription == null) {
            LibraryCompositionSettings.a(6);
        }
        return customLibraryDescription;
    }

    @Nullable
    public LibraryDownloadSettings getDownloadSettings() {
        return this.c;
    }

    @NotNull
    public String getBaseDirectoryPath() {
        String string = (String)this.d.compute();
        if (string == null) {
            LibraryCompositionSettings.a(7);
        }
        return string;
    }

    public void setDownloadLibraries(boolean bl2) {
        this.b = bl2;
    }

    public void setSelectedExistingLibrary(@Nullable Library library) {
        this.f = library;
    }

    public void setNewLibraryLevel(LibrariesContainer.LibraryLevel libraryLevel) {
        this.h = libraryLevel;
    }

    public boolean downloadFiles(@NotNull JComponent jComponent) {
        NewLibraryEditor newLibraryEditor;
        if (jComponent == null) {
            LibraryCompositionSettings.a(8);
        }
        if (this.b && this.c != null && (newLibraryEditor = this.c.download(jComponent, this.getBaseDirectoryPath())) != null) {
            this.e = newLibraryEditor;
        }
        return true;
    }

    public boolean isLibraryConfigured() {
        return this.b || this.e != null || this.f != null || this.a != null;
    }

    @Nullable
    private Library a(ModifiableRootModel modifiableRootModel, @Nullable LibrariesContainer librariesContainer) {
        if (this.e != null) {
            return LibrariesContainerFactory.createLibrary(librariesContainer, LibrariesContainerFactory.createContainer(modifiableRootModel), this.e, this.a());
        }
        return null;
    }

    private LibrariesContainer.LibraryLevel a() {
        return this.b ? this.c.getLibraryLevel() : this.h;
    }

    public LibrariesContainer.LibraryLevel getNewLibraryLevel() {
        return this.h;
    }

    @Nullable
    public Library addLibraries(@NotNull ModifiableRootModel modifiableRootModel, @NotNull List<Library> list2, @Nullable LibrariesContainer librariesContainer) {
        DependencyScope dependencyScope;
        Library library;
        if (modifiableRootModel == null) {
            LibraryCompositionSettings.a(9);
        }
        if (list2 == null) {
            LibraryCompositionSettings.a(10);
        }
        if ((library = this.a(modifiableRootModel, librariesContainer)) != null) {
            list2.add(library);
            dependencyScope = LibraryDependencyScopeSuggester.getDefaultScope((Library)library);
            if (this.a() != LibrariesContainer.LibraryLevel.MODULE) {
                modifiableRootModel.addLibraryEntry(library).setScope(dependencyScope);
            } else {
                LibraryOrderEntry libraryOrderEntry = modifiableRootModel.findLibraryOrderEntry(library);
                assert (libraryOrderEntry != null);
                libraryOrderEntry.setScope(dependencyScope);
            }
        }
        if (this.f != null) {
            list2.add(this.f);
            modifiableRootModel.addLibraryEntry(this.f).setScope(LibraryDependencyScopeSuggester.getDefaultScope((Library)this.f));
        }
        if (this.a != null) {
            dependencyScope = this.a.createLibrary(this.g.getSuitableLibraryKinds());
            list2.add((Library)dependencyScope);
            modifiableRootModel.addLibraryEntry((Library)dependencyScope).setScope(LibraryDependencyScopeSuggester.getDefaultScope((Library)dependencyScope));
        }
        return library;
    }

    public void setNewLibraryEditor(@Nullable NewLibraryEditor newLibraryEditor) {
        this.e = newLibraryEditor;
    }

    public void setLibraryProvider(FrameworkLibraryProvider frameworkLibraryProvider) {
        this.a = frameworkLibraryProvider;
    }

    public void dispose() {
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectoryPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedLibraries";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectoryPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setVersionFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDownloadPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEditor";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

