/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.DownloadingOptionsDialog;
import com.intellij.facet.impl.ui.libraries.EditLibraryDialog;
import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.frameworkSupport.OldCustomLibraryDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryOptionsPanel
implements Disposable {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel");
    private JBLabel s;
    private JPanel o;
    private JButton e;
    private JComboBox<LibraryEditor> u;
    private JRadioButton j;
    private JPanel t;
    private JButton i;
    private JRadioButton h;
    private JRadioButton m;
    private JLabel p;
    private JLabel b;
    private JPanel n;
    private JRadioButton f;
    private JPanel v;
    private ButtonGroup w;
    private LibraryCompositionSettings c;
    private final CustomLibraryDescription q;
    private final LibrariesContainer k;
    private SortedComboBoxModel<LibraryEditor> g;
    private FrameworkLibraryProvider l;
    private boolean d;
    private RadioButtonEnumModel<Choice> r;

    public LibraryOptionsPanel(@NotNull CustomLibraryDescription customLibraryDescription, @NotNull String string, @NotNull FrameworkLibraryVersionFilter frameworkLibraryVersionFilter, @NotNull LibrariesContainer librariesContainer, boolean bl2) {
        if (customLibraryDescription == null) {
            LibraryOptionsPanel.a(0);
        }
        if (string == null) {
            LibraryOptionsPanel.a(1);
        }
        if (frameworkLibraryVersionFilter == null) {
            LibraryOptionsPanel.a(2);
        }
        if (librariesContainer == null) {
            LibraryOptionsPanel.a(3);
        }
        this(customLibraryDescription, (NotNullComputable<String>)((NotNullComputable)() -> {
            if (string == null) {
                LibraryOptionsPanel.a(9);
            }
            return string;
        }), frameworkLibraryVersionFilter, librariesContainer, bl2);
    }

    public LibraryOptionsPanel(final @NotNull CustomLibraryDescription customLibraryDescription, final @NotNull NotNullComputable<String> notNullComputable, final @NotNull FrameworkLibraryVersionFilter frameworkLibraryVersionFilter, @NotNull LibrariesContainer librariesContainer, final boolean bl2) {
        if (customLibraryDescription == null) {
            LibraryOptionsPanel.a(4);
        }
        if (notNullComputable == null) {
            LibraryOptionsPanel.a(5);
        }
        if (frameworkLibraryVersionFilter == null) {
            LibraryOptionsPanel.a(6);
        }
        if (librariesContainer == null) {
            LibraryOptionsPanel.a(7);
        }
        this.q = customLibraryDescription;
        this.k = librariesContainer;
        this.c();
        DownloadableLibraryDescription downloadableLibraryDescription = LibraryOptionsPanel.a(customLibraryDescription);
        if (downloadableLibraryDescription != null) {
            this.a("loading");
            downloadableLibraryDescription.fetchVersions((DownloadableFileSetVersions.FileSetVersionsCallback)new DownloadableFileSetVersions.FileSetVersionsCallback<FrameworkLibraryVersion>(){

                public void onSuccess(@NotNull List<? extends FrameworkLibraryVersion> list2) {
                    if (list2 == null) {
                        1.a(0);
                    }
                    SwingUtilities.invokeLater(() -> {
                        if (customLibraryDescription == null) {
                            1.a(1);
                        }
                        if (notNullComputable == null) {
                            1.a(2);
                        }
                        if (frameworkLibraryVersionFilter == null) {
                            1.a(3);
                        }
                        if (list2 == null) {
                            1.a(4);
                        }
                        if (!LibraryOptionsPanel.this.d) {
                            LibraryOptionsPanel.this.a(customLibraryDescription, (NotNullComputable<String>)notNullComputable, frameworkLibraryVersionFilter, bl2, list2);
                            LibraryOptionsPanel.this.onVersionChanged(LibraryOptionsPanel.this.a());
                        }
                    });
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "versions";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "libraryDescription";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pathProvider";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "versionFilter";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onSuccess$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            this.a(customLibraryDescription, notNullComputable, frameworkLibraryVersionFilter, bl2, new ArrayList());
        }
    }

    @Nullable
    private String a() {
        switch ((Choice)this.r.getSelected()) {
            case DOWNLOAD: {
                LibraryDownloadSettings libraryDownloadSettings = this.c.getDownloadSettings();
                if (libraryDownloadSettings == null) break;
                return libraryDownloadSettings.getVersion().getVersionNumber();
            }
            case USE_LIBRARY: {
                LibraryEditor libraryEditor = (LibraryEditor)this.g.getSelectedItem();
                if (!(libraryEditor instanceof ExistingLibraryEditor)) break;
                return libraryEditor.getName();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    protected void onVersionChanged(@Nullable String string) {
    }

    public JPanel getSimplePanel() {
        return this.v;
    }

    @Nullable
    private static DownloadableLibraryDescription a(CustomLibraryDescription customLibraryDescription) {
        DownloadableLibraryType downloadableLibraryType = customLibraryDescription.getDownloadableLibraryType();
        if (downloadableLibraryType != null) {
            return downloadableLibraryType.getLibraryDescription();
        }
        if (customLibraryDescription instanceof OldCustomLibraryDescription) {
            return ((OldCustomLibraryDescription)customLibraryDescription).getDownloadableDescription();
        }
        return null;
    }

    private void a(String string) {
        ((CardLayout)this.n.getLayout()).show(this.n, string);
    }

    private void a(CustomLibraryDescription customLibraryDescription, NotNullComputable<String> notNullComputable, FrameworkLibraryVersionFilter frameworkLibraryVersionFilter, boolean bl2, List<? extends FrameworkLibraryVersion> list2) {
        Object object;
        this.c = new LibraryCompositionSettings(customLibraryDescription, notNullComputable, frameworkLibraryVersionFilter, list2);
        Disposer.register((Disposable)this, (Disposable)this.c);
        List<Library> list3 = this.e();
        this.r = RadioButtonEnumModel.bindEnum(Choice.class, (ButtonGroup)this.w);
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptionsPanel.this.f();
                LibraryOptionsPanel.this.onVersionChanged(LibraryOptionsPanel.this.a());
            }
        });
        this.j.setVisible(bl2);
        this.g = new SortedComboBoxModel((libraryEditor, libraryEditor2) -> {
            String string = libraryEditor.getName();
            String string2 = libraryEditor2.getName();
            return -StringUtil.notNullize((String)string).compareToIgnoreCase(StringUtil.notNullize((String)string2));
        });
        for (Library library : list3) {
            object = this.k.getLibraryEditor(library);
            if (object == null) {
                object = this.c.getOrCreateEditor(library);
            }
            this.g.add(object);
        }
        this.u.setModel((ComboBoxModel<LibraryEditor>)this.g);
        if (list3.isEmpty()) {
            this.g.add(null);
        }
        this.u.setSelectedIndex(0);
        this.u.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && itemEvent.getItem() != null) {
                    LibraryOptionsPanel.this.r.setSelected((Enum)Choice.USE_LIBRARY);
                }
                LibraryOptionsPanel.this.f();
                LibraryOptionsPanel.this.onVersionChanged(LibraryOptionsPanel.this.a());
            }
        });
        this.u.setRenderer((ListCellRenderer<LibraryEditor>)new ColoredListCellRenderer<LibraryEditor>(this.u){

            protected void customizeCellRenderer(@NotNull JList<? extends LibraryEditor> jList, LibraryEditor libraryEditor, int n2, boolean bl2, boolean bl3) {
                if (jList == null) {
                    4.a(0);
                }
                if (libraryEditor == null) {
                    this.append("[No library selected]");
                } else if (libraryEditor instanceof ExistingLibraryEditor) {
                    Library library = ((ExistingLibraryEditor)libraryEditor).getLibrary();
                    boolean bl4 = !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty();
                    OrderEntryAppearanceService.getInstance().forLibrary(LibraryOptionsPanel.this.b(), library, bl4).customize((SimpleColoredComponent)this);
                } else if (libraryEditor instanceof NewLibraryEditor) {
                    this.setIcon(PlatformIcons.LIBRARY_ICON);
                    String string = libraryEditor.getName();
                    this.append(string != null ? string : "<unnamed>");
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel$4", "customizeCellRenderer"));
            }
        });
        boolean bl3 = this.c.getDownloadSettings() != null;
        boolean bl4 = this.l != null;
        this.h.setVisible(bl3);
        this.f.setVisible(bl4);
        if (bl4) {
            object = Choice.USE_FROM_PROVIDER;
        } else if (list3.isEmpty() && bl3) {
            object = Choice.DOWNLOAD;
        } else {
            object = Choice.USE_LIBRARY;
            this.a(true);
        }
        this.r.setSelected((Enum)object);
        if (!(bl3 || bl4 || bl2)) {
            this.m.setVisible(false);
            this.p.setVisible(true);
        } else {
            this.p.setVisible(false);
        }
        Dimension dimension = new Dimension(-1, this.s.getFontMetrics(this.s.getFont()).getHeight() * 2);
        this.b.setMinimumSize(dimension);
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptionsPanel.this.a(false);
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptionsPanel.this.g();
            }
        });
        this.f();
        this.a("editing");
    }

    private Project b() {
        Project project2 = this.k.getProject();
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return project2;
    }

    private void g() {
        switch ((Choice)this.r.getSelected()) {
            case DOWNLOAD: {
                LibraryDownloadSettings libraryDownloadSettings = this.c.getDownloadSettings();
                a.assertTrue(libraryDownloadSettings != null);
                LibraryDownloadSettings libraryDownloadSettings2 = DownloadingOptionsDialog.showDialog(this.o, libraryDownloadSettings, this.c.getCompatibleVersions(), true);
                if (libraryDownloadSettings2 == null) break;
                this.c.setDownloadSettings(libraryDownloadSettings2);
                break;
            }
            case USE_LIBRARY: {
                final Object object = this.u.getSelectedItem();
                if (!(object instanceof LibraryEditor)) break;
                EditLibraryDialog editLibraryDialog = new EditLibraryDialog(this.o, this.c, (LibraryEditor)object);
                editLibraryDialog.show();
                if (!(object instanceof ExistingLibraryEditor)) break;
                new WriteAction(){

                    protected void run(@NotNull Result result2) {
                        if (result2 == null) {
                            7.a(0);
                        }
                        ((ExistingLibraryEditor)object).commit();
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel$7", "run"));
                    }
                }.execute();
                break;
            }
        }
        this.f();
    }

    public void setLibraryProvider(@Nullable FrameworkLibraryProvider frameworkLibraryProvider) {
        if (frameworkLibraryProvider != null && !ContainerUtil.intersects(frameworkLibraryProvider.getAvailableLibraryKinds(), this.q.getSuitableLibraryKinds())) {
            frameworkLibraryProvider = null;
        }
        if (!Comparing.equal((Object)this.l, (Object)frameworkLibraryProvider)) {
            this.l = frameworkLibraryProvider;
            if (this.c != null) {
                if (frameworkLibraryProvider != null && !this.f.isVisible()) {
                    this.f.setSelected(true);
                }
                this.f.setVisible(frameworkLibraryProvider != null);
                this.f();
            }
        }
    }

    public void setVersionFilter(@NotNull FrameworkLibraryVersionFilter frameworkLibraryVersionFilter) {
        if (frameworkLibraryVersionFilter == null) {
            LibraryOptionsPanel.a(8);
        }
        if (this.c != null) {
            this.c.setVersionFilter(frameworkLibraryVersionFilter);
            this.f();
        }
    }

    private void a(boolean bl2) {
        NewLibraryConfiguration newLibraryConfiguration;
        NewLibraryConfiguration newLibraryConfiguration2 = newLibraryConfiguration = bl2 ? this.q.createNewLibraryWithDefaultSettings(this.h()) : this.q.createNewLibrary(this.i, this.h());
        if (newLibraryConfiguration != null) {
            NewLibraryEditor newLibraryEditor = new NewLibraryEditor(newLibraryConfiguration.getLibraryType(), newLibraryConfiguration.getProperties());
            newLibraryEditor.setName(this.k.suggestUniqueLibraryName(newLibraryConfiguration.getDefaultLibraryName()));
            newLibraryConfiguration.addRoots((LibraryEditor)newLibraryEditor);
            if (this.g.get(0) == null) {
                this.g.remove(0);
            }
            this.g.add((Object)newLibraryEditor);
            this.g.setSelectedItem((Object)newLibraryEditor);
            this.r.setSelected((Enum)Choice.USE_LIBRARY);
        }
    }

    private List<Library> e() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : this.k.getAllLibraries()) {
            if ((!(this.q instanceof OldCustomLibraryDescription) || !((OldCustomLibraryDescription)this.q).isSuitableLibrary(library, this.k)) && !LibraryPresentationManager.getInstance().isLibraryOfKind(library, this.k, this.q.getSuitableLibraryKinds())) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    @Nullable
    private VirtualFile h() {
        int n2;
        String string = this.c.getBaseDirectoryPath();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        if (virtualFile == null && (n2 = string.lastIndexOf(47)) >= 0) {
            string = string.substring(0, n2);
            virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        }
        return virtualFile;
    }

    private void f() {
        this.s.setIcon(null);
        this.e.setVisible(true);
        LibraryDownloadSettings libraryDownloadSettings = this.c.getDownloadSettings();
        this.h.setVisible(libraryDownloadSettings != null);
        this.f.setVisible(this.l != null);
        if (!this.f.isVisible() && this.f.isSelected()) {
            if (this.h.isVisible()) {
                this.h.setSelected(true);
            } else {
                this.m.setSelected(true);
            }
        }
        if (!this.h.isVisible() && this.h.isSelected() && this.m.isVisible()) {
            this.m.setSelected(true);
        }
        String string = "";
        boolean bl2 = true;
        switch ((Choice)this.r.getSelected()) {
            case DOWNLOAD: {
                string = this.d();
                break;
            }
            case USE_FROM_PROVIDER: {
                if (this.l != null) {
                    string = "Library from " + this.l.getPresentableName() + " will be used";
                }
                this.e.setVisible(false);
                break;
            }
            case USE_LIBRARY: {
                Object object = this.u.getSelectedItem();
                if (object == null) {
                    this.s.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
                    string = "<b>Error:</b> library is not specified";
                    this.e.setVisible(false);
                    break;
                }
                if (object instanceof NewLibraryEditor) {
                    LibraryEditor libraryEditor = (LibraryEditor)object;
                    string = IdeBundle.message((String)"label.library.will.be.created.description.text", (Object[])new Object[]{this.c.getNewLibraryLevel(), libraryEditor.getName(), libraryEditor.getFiles(OrderRootType.CLASSES).length});
                    break;
                }
                string = MessageFormat.format("<b>{0}</b> library will be used", ((ExistingLibraryEditor)object).getName());
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (this.l != null) {
            this.f.setText("Use library from " + this.l.getPresentableName());
        }
        if (this.c.getDownloadSettings() != null) {
            this.b.setText(this.d());
        } else {
            this.b.setText(IdeBundle.message((String)"label.library.will.be.created.description.text", (Object[])new Object[]{this.c.getNewLibraryLevel(), "name", 10}));
        }
        ((CardLayout)this.t.getLayout()).show(this.t, bl2 ? "configure" : "empty");
        this.s.setText(XmlStringUtil.wrapInHtml((CharSequence)string));
    }

    private String d() {
        LibraryDownloadSettings libraryDownloadSettings = this.c.getDownloadSettings();
        if (libraryDownloadSettings == null) {
            return "";
        }
        String string = libraryDownloadSettings.getDirectoryForDownloadedLibrariesPath();
        String string2 = this.c.getBaseDirectoryPath();
        String string3 = !StringUtil.isEmpty((String)string2) && FileUtil.startsWith((String)string, (String)string2) ? FileUtil.getRelativePath((String)string2, (String)string, (char)'/') : PathUtil.getFileName((String)string);
        return MessageFormat.format("{0} {0, choice, 1#JAR|2#JARs} will be downloaded into <b>{1}</b> directory<br>{2} library <b>{3}</b> will be created", new Object[]{libraryDownloadSettings.getSelectedDownloads().size(), string3, libraryDownloadSettings.getLibraryLevel(), libraryDownloadSettings.getLibraryName()});
    }

    public LibraryCompositionSettings getSettings() {
        return this.c;
    }

    @Nullable
    public LibraryCompositionSettings apply() {
        if (this.c == null) {
            return null;
        }
        Choice choice = (Choice)this.r.getSelected();
        this.c.setDownloadLibraries(choice == Choice.DOWNLOAD);
        Object object = this.u.getSelectedItem();
        if (choice == Choice.USE_LIBRARY && object instanceof ExistingLibraryEditor) {
            this.c.setSelectedExistingLibrary(((ExistingLibraryEditor)object).getLibrary());
        } else {
            this.c.setSelectedExistingLibrary(null);
        }
        if (choice == Choice.USE_LIBRARY && object instanceof NewLibraryEditor) {
            this.c.setNewLibraryEditor((NewLibraryEditor)object);
        } else {
            this.c.setNewLibraryEditor(null);
        }
        this.c.setLibraryProvider(choice == Choice.USE_FROM_PROVIDER ? this.l : null);
        return this.c;
    }

    public JComponent getMainPanel() {
        return this.n;
    }

    public void dispose() {
        this.d = true;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFilter";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesContainer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setVersionFilter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void c() {
        ButtonGroup buttonGroup;
        JRadioButton jRadioButton;
        JLabel jLabel;
        JBLabel jBLabel;
        JButton jButton;
        JPanel jPanel;
        JLabel jLabel2;
        JRadioButton jRadioButton2;
        JButton jButton2;
        JPanel jPanel2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.n = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.o = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(false);
        jPanel4.add((Component)jPanel3, "editing");
        this.h = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(false);
        jRadioButton4.setText("Download");
        jRadioButton4.setMnemonic('D');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(207, 22), null));
        this.j = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Set up library later");
        jRadioButton3.setMnemonic('L');
        jRadioButton3.setDisplayedMnemonicIndex(15);
        jPanel3.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.v = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.u = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.i = jButton2 = new JButton();
        jButton2.setText("Create...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.m = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Use library:");
        jRadioButton2.setMnemonic('U');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.p = jLabel2 = new JLabel();
        jLabel2.setText("Use library:");
        ((Component)jLabel2).setVisible(true);
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.t = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, "configure");
        this.e = jButton = new JButton();
        jButton.setText("Configure...");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.s = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setEnabled(true);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("<html>{} JARs will be downloaded into <b>lib</b> directory<br> Project level library <b>spring</b> will be created</html>");
        jPanel8.add((Component)jBLabel, "message");
        this.b = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel8.add((Component)jLabel, "hidden");
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel9, "empty");
        this.f = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use from provider");
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel10, "loading");
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Loading versions...");
        jPanel10.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.w = buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
    }

    private static enum Choice {
        USE_LIBRARY,
        DOWNLOAD,
        SETUP_LIBRARY_LATER,
        USE_FROM_PROVIDER;

    }
}

