/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WrappingVirtualFile;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureSelectInTarget
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext selectInContext) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)selectInContext.getProject()).getFileIndex();
        VirtualFile virtualFile = selectInContext.getVirtualFile();
        if (virtualFile instanceof WrappingVirtualFile) {
            Object object = ((WrappingVirtualFile)virtualFile).getWrappedObject(selectInContext.getProject());
            return object instanceof Facet;
        }
        return projectFileIndex.isInContent(virtualFile) || projectFileIndex.isInLibraryClasses(virtualFile) || projectFileIndex.isInLibrarySource(virtualFile) || StdFileTypes.IDEA_MODULE.equals(virtualFile.getFileType()) && ProjectStructureSelectInTarget.a(selectInContext.getProject(), virtualFile) != null;
    }

    public void selectIn(SelectInContext selectInContext, boolean bl2) {
        Object object;
        Facet facet;
        Object object2;
        Project project2 = selectInContext.getProject();
        VirtualFile virtualFile = selectInContext.getVirtualFile();
        if (virtualFile instanceof WrappingVirtualFile) {
            object2 = ((WrappingVirtualFile)virtualFile).getWrappedObject(project2);
            facet = object2 instanceof Facet ? (Facet)object2 : null;
            object = facet == null ? null : facet.getModule();
        } else {
            object2 = virtualFile.getFileType().equals(StdFileTypes.IDEA_MODULE) ? ProjectStructureSelectInTarget.a(project2, virtualFile) : null;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            object = object2 != null ? object2 : projectFileIndex.getModuleForFile(virtualFile);
            Facet facet2 = facet = projectFileIndex.isInSourceContent(virtualFile) ? null : ProjectStructureSelectInTarget.b(project2, virtualFile);
        }
        if (object != null || facet != null) {
            ApplicationManager.getApplication().invokeLater(() -> ProjectStructureSelectInTarget.a(facet, project2, (Module)object));
            return;
        }
        object2 = LibraryUtil.findLibraryEntry((VirtualFile)virtualFile, (Project)project2);
        if (object2 != null) {
            ApplicationManager.getApplication().invokeLater(() -> ProjectStructureSelectInTarget.a(project2, (OrderEntry)object2));
        }
    }

    @Nullable
    private static Module a(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        if (project2 == null) {
            ProjectStructureSelectInTarget.a(0);
        }
        if (virtualFile == null) {
            ProjectStructureSelectInTarget.a(1);
        }
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!ModuleUtilCore.isModuleFile((Module)module2, (VirtualFile)virtualFile)) continue;
            return module2;
        }
        return null;
    }

    @Nullable
    private static Facet b(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        if (project2 == null) {
            ProjectStructureSelectInTarget.a(2);
        }
        if (virtualFile == null) {
            ProjectStructureSelectInTarget.a(3);
        }
        for (FacetTypeId facetTypeId : FacetTypeRegistry.getInstance().getFacetTypeIds()) {
            Facet facet;
            if (!ProjectStructureSelectInTarget.a(project2, facetTypeId) || (facet = FacetFinder.getInstance((Project)project2).findFacet(virtualFile, facetTypeId)) == null) continue;
            return facet;
        }
        return null;
    }

    private static <F extends Facet> boolean a(@NotNull Project project2, @NotNull FacetTypeId<F> facetTypeId) {
        if (project2 == null) {
            ProjectStructureSelectInTarget.a(4);
        }
        if (facetTypeId == null) {
            ProjectStructureSelectInTarget.a(5);
        }
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Collection collection = FacetManager.getInstance((Module)module2).getFacetsByType(facetTypeId);
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) continue;
            return iterator.next() instanceof FacetRootsProvider;
        }
        return false;
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.project.settings", (Object[])new Object[0]);
    }

    public float getWeight() {
        return 10.0f;
    }

    private static /* synthetic */ void a(Project project2, OrderEntry orderEntry) {
        ProjectSettingsService.getInstance((Project)project2).openLibraryOrSdkSettings(orderEntry);
    }

    private static /* synthetic */ void a(Facet facet, Project project2, Module module2) {
        if (facet != null) {
            ModulesConfigurator.showFacetSettingsDialog(facet, null);
        } else {
            ProjectSettingsService.getInstance((Project)project2).openModuleSettings(module2);
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/ProjectStructureSelectInTarget";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleByModuleFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFacet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFacetWithRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

