/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.profiler.ui;

import com.intellij.ide.profiler.ui.AbstractDrawGraphics2DComponent;
import com.intellij.ide.profiler.ui.ChartNodeRenderer;
import com.intellij.ide.profiler.ui.TreeChartComponent;
import com.intellij.ide.profiler.ui.model.AbstractRenderableCallUsage;
import com.intellij.ide.profiler.ui.model.ChartNode;
import com.intellij.ide.profiler.ui.model.Range;
import com.intellij.ide.profiler.ui.model.WithRenderableText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.UtilKt;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u0000 $*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0002$%B5\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u001e\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u0014\u0010\"\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u00000\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent;", "T", "Lcom/intellij/ide/profiler/ui/model/AbstractRenderableCallUsage;", "", "Lcom/intellij/ide/profiler/ui/AbstractDrawGraphics2DComponent;", "root", "Lcom/intellij/ide/profiler/ui/model/ChartNode;", "renderer", "Lcom/intellij/ide/profiler/ui/ChartNodeRenderer;", "additionalNodeInfoArea", "Ljavax/swing/JTextArea;", "orientation", "Lcom/intellij/ide/profiler/ui/TreeChartComponent$Orientation;", "(Lcom/intellij/ide/profiler/ui/model/ChartNode;Lcom/intellij/ide/profiler/ui/ChartNodeRenderer;Ljavax/swing/JTextArea;Lcom/intellij/ide/profiler/ui/TreeChartComponent$Orientation;)V", "visibleNodes", "", "Lkotlin/Pair;", "Ljava/awt/geom/Rectangle2D$Double;", "xRange", "Lcom/intellij/ide/profiler/ui/model/Range;", "yRange", "draw", "", "g", "Ljava/awt/Graphics2D;", "size", "Ljava/awt/Dimension;", "initKeyboardEvents", "initMouseEvents", "rangeToPosition", "", "v", "renderChartNode", "node", "setData", "data", "Companion", "Orientation", "intellij.platform.commercial"})
public final class TreeChartComponent<T extends AbstractRenderableCallUsage<? extends String>>
extends AbstractDrawGraphics2DComponent {
    private Range m;
    private Range f;
    private final List<Pair<Rectangle2D.Double, T>> n;
    private ChartNode<T> i;
    private final ChartNodeRenderer<T> k;
    private final JTextArea l;
    private final Orientation c;
    private static final String d = "No data available.";
    private static final String h = "X range width is zero: Please use a wider range.";
    private static final int b = 2;
    private static final int e = 5;
    private static final int j = 20;
    private static final Logger g;
    public static final Companion Companion;

    public final void setData(@NotNull ChartNode<T> chartNode) {
        Intrinsics.checkParameterIsNotNull(chartNode, (String)"data");
        this.i = chartNode;
        this.n.clear();
        this.l.setText("");
        this.m = new Range(chartNode.getStart(), chartNode.getEnd());
        this.f = Range.Companion.getZERO_POINT();
    }

    @Override
    protected void draw(@NotNull Graphics2D graphics2D, @NotNull Dimension dimension) {
        int n2;
        Pair pair2;
        Object t2;
        Iterator iterator;
        int n3;
        int n4;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)graphics2D, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)dimension, (String)"size");
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartNode<T> chartNode = this.i;
        if (UtilKt.isNullOrEmpty((Collection)(chartNode != null ? chartNode.getChildren() : null))) {
            graphics2D.drawString(d, dimension.width / 2 - this.getDefaultFontMetrics().stringWidth(d), dimension.height / 2);
            return;
        }
        if (this.m.getLength() == 0.0) {
            graphics2D.drawString(h, dimension.width / 2 - this.getDefaultFontMetrics().stringWidth(h), dimension.height / 2);
            return;
        }
        this.n.clear();
        Stack stack = new Stack();
        ChartNode<T> chartNode2 = this.i;
        if (chartNode2 == null) {
            Intrinsics.throwNpe();
        }
        stack.addAll(chartNode2.getChildren());
        while (!stack.isEmpty()) {
            object = (ChartNode)stack.pop();
            ChartNode chartNode3 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)chartNode3, (String)"n");
            this.a(graphics2D, chartNode3);
            stack.addAll(((ChartNode)object).getChildren());
        }
        object = this.n;
        StringBuilder stringBuilder = new StringBuilder().append("rectangles count: ").append(this.n.size()).append(", with width < 1px: ");
        Logger logger = TreeChartComponent.Companion.a();
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            n4 = 0;
        } else {
            n3 = 0;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                t2 = iterator.next();
                pair2 = (Pair)t2;
                if (!(((Rectangle2D.Double)pair2.getFirst()).width < 1.0)) continue;
                ++n3;
            }
            n4 = n3;
        }
        int n5 = n4;
        object = this.n;
        stringBuilder = stringBuilder.append(n5).append(", with width == 1px ");
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            n2 = 0;
        } else {
            n3 = 0;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                t2 = iterator.next();
                pair2 = (Pair)t2;
                if (!(((Rectangle2D.Double)pair2.getFirst()).width == 0.0)) continue;
                ++n3;
            }
            n2 = n3;
        }
        n5 = n2;
        logger.info(stringBuilder.append(n5).toString());
    }

    private final void a(Graphics2D graphics2D, ChartNode<T> chartNode) {
        if ((double)chartNode.getStart() > this.m.getMax() || (double)chartNode.getEnd() < this.m.getMin()) {
            return;
        }
        double d2 = RangesKt.coerceAtLeast((double)this.a(chartNode.getStart()), (double)0.0);
        double d3 = RangesKt.coerceAtMost((double)this.a(chartNode.getEnd()), (double)this.getWidth());
        double d4 = d3 - d2;
        if (d4 < 1.0) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, (double)((this.getDefaultFontMetrics().getHeight() + 2) * chartNode.getDepth()) - this.f.getMin(), d4 - (double)2, this.getDefaultFontMetrics().getHeight());
        if (Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)Orientation.BOTTOM_UP))) {
            double_.y = (double)this.getHeight() - double_.y - double_.height;
        }
        T t2 = chartNode.getData();
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        this.n.add(new Pair((Object)double_, t2));
        T t3 = chartNode.getData();
        if (t3 == null) {
            Intrinsics.throwNpe();
        }
        this.k.render(graphics2D, (WithRenderableText)t3, double_);
    }

    private final double a(double d2) {
        double d3 = -this.m.getMin();
        double d4 = (double)this.getWidth() / (this.m.getMax() - this.m.getMin());
        return (d2 + d3) * d4;
    }

    private final void b() {
        Function1<Range, Unit> function1 = new Function1<Range, Unit>(this){
            final /* synthetic */ TreeChartComponent this$0;

            public final void invoke(@NotNull Range range) {
                Intrinsics.checkParameterIsNotNull((Object)range, (String)"newXRange");
                TreeChartComponent.access$setXRange$p(this.this$0, range);
                this.this$0.repaint();
            }
            {
                this.this$0 = treeChartComponent;
                super(1);
            }
        };
        Function1<Range, Unit> function12 = new Function1<Range, Unit>(this){
            final /* synthetic */ TreeChartComponent this$0;

            public final void invoke(@NotNull Range range) {
                Intrinsics.checkParameterIsNotNull((Object)range, (String)"newYRange");
                TreeChartComponent.access$setYRange$p(this.this$0, range);
                this.this$0.repaint();
            }
            {
                this.this$0 = treeChartComponent;
                super(1);
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(this, function1, function12){
            final /* synthetic */ TreeChartComponent this$0;
            final /* synthetic */ initKeyboardEvents.1 $updateX$1;
            final /* synthetic */ initKeyboardEvents.2 $updateY$2;

            public void keyReleased(@NotNull KeyEvent keyEvent) {
                Intrinsics.checkParameterIsNotNull((Object)keyEvent, (String)"e");
                switch (keyEvent.getKeyCode()) {
                    case 45: {
                        double d2;
                        double d3 = d2 = TreeChartComponent.access$getXRange$p(this.this$0).getLength() / (double)5;
                        this.$updateX$1.invoke(TreeChartComponent.access$getXRange$p(this.this$0).change(-d3, d3));
                        break;
                    }
                    case 61: {
                        double d4;
                        double d5 = d4 = TreeChartComponent.access$getXRange$p(this.this$0).getLength() / (double)5;
                        this.$updateX$1.invoke(TreeChartComponent.access$getXRange$p(this.this$0).change(d5, -d5));
                        break;
                    }
                    case 37: {
                        this.$updateX$1.invoke(TreeChartComponent.access$getXRange$p(this.this$0).shift((double)-1 * TreeChartComponent.access$getXRange$p(this.this$0).getLength() / (double)5));
                        break;
                    }
                    case 39: {
                        this.$updateX$1.invoke(TreeChartComponent.access$getXRange$p(this.this$0).shift(TreeChartComponent.access$getXRange$p(this.this$0).getLength() / (double)5));
                        break;
                    }
                    case 38: {
                        this.$updateY$2.invoke(TreeChartComponent.access$getYRange$p(this.this$0).shift(30.0));
                        break;
                    }
                    case 40: {
                        this.$updateY$2.invoke(TreeChartComponent.access$getYRange$p(this.this$0).shift(-30.0));
                    }
                }
            }
            {
                this.this$0 = treeChartComponent;
                this.$updateX$1 = var2_2;
                this.$updateY$2 = var3_3;
            }
        };
        this.addKeyListener(keyAdapter);
    }

    private final void a() {
        MouseAdapter mouseAdapter = new MouseAdapter(this){
            private Point a;
            private T b;
            final /* synthetic */ TreeChartComponent this$0;

            public void mouseClicked(@NotNull MouseEvent mouseEvent) {
                Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
                if (!this.this$0.hasFocus()) {
                    this.this$0.requestFocusInWindow();
                }
            }

            public void mouseMoved(@NotNull MouseEvent mouseEvent) {
                AbstractRenderableCallUsage<T> abstractRenderableCallUsage;
                Object v0;
                Object[] objectArray;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
                    object3 = object4 = (Iterable)TreeChartComponent.access$getVisibleNodes$p(this.this$0);
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        objectArray = (Object[])object;
                        if (!((Rectangle2D.Double)objectArray.getFirst()).contains(mouseEvent.getPoint())) continue;
                        v0 = object;
                        break block3;
                    }
                    v0 = null;
                }
                Pair pair2 = v0;
                AbstractRenderableCallUsage<T> abstractRenderableCallUsage2 = abstractRenderableCallUsage = pair2 != null ? (AbstractRenderableCallUsage<T>)pair2.getSecond() : null;
                if (Intrinsics.areEqual((Object)abstractRenderableCallUsage, this.b)) {
                    return;
                }
                if (abstractRenderableCallUsage == null) {
                    TreeChartComponent.access$getAdditionalNodeInfoArea$p(this.this$0).setText("");
                    return;
                }
                this.b = abstractRenderableCallUsage;
                object3 = StringCompanionObject.INSTANCE;
                object2 = "%.2f";
                Object object5 = object = new Object[]{Float.valueOf(abstractRenderableCallUsage.getPercentageOfParentCall() * (float)100)};
                String string = String.format((String)object2, Arrays.copyOf(object5, ((T)object5).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                object4 = string;
                object2 = StringCompanionObject.INSTANCE;
                object = "%.2f";
                objectArray = new Object[]{Float.valueOf(abstractRenderableCallUsage.getPercentageOfAllCalls() * (float)100)};
                String string2 = String.format(object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                object3 = string2;
                TreeChartComponent.access$getAdditionalNodeInfoArea$p(this.this$0).setText("" + abstractRenderableCallUsage.getText() + ' ' + abstractRenderableCallUsage.getInvocationCount() + " calls " + (String)object4 + "% of parent, " + (String)object3 + "% of all");
            }

            public void mousePressed(@NotNull MouseEvent mouseEvent) {
                Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
                Point point = mouseEvent.getPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                this.a = point;
            }

            public void mouseDragged(@NotNull MouseEvent mouseEvent) {
                Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
                double d2 = (double)mouseEvent.getPoint().x - (double)this.a.x;
                double d3 = (double)mouseEvent.getPoint().y - (double)this.a.y;
                TreeChartComponent.access$setYRange$p(this.this$0, TreeChartComponent.access$getYRange$p(this.this$0).shift(Intrinsics.areEqual((Object)((Object)TreeChartComponent.access$getOrientation$p(this.this$0)), (Object)((Object)Orientation.BOTTOM_UP)) ? d3 : -d3));
                TreeChartComponent.access$setXRange$p(this.this$0, TreeChartComponent.access$getXRange$p(this.this$0).shift(TreeChartComponent.access$getXRange$p(this.this$0).getLength() / (double)this.this$0.getWidth() * -d2));
                Point point = mouseEvent.getPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                this.a = point;
                this.this$0.repaint();
            }

            public void mouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
                Intrinsics.checkParameterIsNotNull((Object)mouseWheelEvent, (String)"e");
                double d2 = this.a(mouseWheelEvent.getX());
                double d3 = (d2 - TreeChartComponent.access$getXRange$p(this.this$0).getMin()) / (double)20 * (double)mouseWheelEvent.getWheelRotation();
                double d4 = (TreeChartComponent.access$getXRange$p(this.this$0).getMax() - d2) / (double)20 * (double)mouseWheelEvent.getWheelRotation();
                TreeChartComponent.access$setXRange$p(this.this$0, TreeChartComponent.access$getXRange$p(this.this$0).change(-d3, d4));
                this.this$0.repaint();
            }

            private final double a(double d2) {
                return d2 / (double)this.this$0.getWidth() * TreeChartComponent.access$getXRange$p(this.this$0).getLength() + TreeChartComponent.access$getXRange$p(this.this$0).getMin();
            }
            {
                this.this$0 = treeChartComponent;
                this.a = new Point();
            }
        };
        this.addMouseWheelListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    public TreeChartComponent(@Nullable ChartNode<T> chartNode, @NotNull ChartNodeRenderer<? super T> chartNodeRenderer, @NotNull JTextArea jTextArea, @NotNull Orientation orientation) {
        List list2;
        Intrinsics.checkParameterIsNotNull(chartNodeRenderer, (String)"renderer");
        Intrinsics.checkParameterIsNotNull((Object)jTextArea, (String)"additionalNodeInfoArea");
        Intrinsics.checkParameterIsNotNull((Object)((Object)orientation), (String)"orientation");
        super(null, 1, null);
        this.i = chartNode;
        this.k = chartNodeRenderer;
        this.l = jTextArea;
        this.c = orientation;
        this.m = Range.Companion.getZERO_POINT();
        this.f = Range.Companion.getZERO_POINT();
        TreeChartComponent treeChartComponent = this;
        treeChartComponent.n = list2 = (List)new ArrayList();
        this.b();
        this.a();
        this.setFocusable(true);
    }

    public /* synthetic */ TreeChartComponent(ChartNode chartNode, ChartNodeRenderer chartNodeRenderer, JTextArea jTextArea, Orientation orientation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            orientation = Orientation.BOTTOM_UP;
        }
        this(chartNode, chartNodeRenderer, jTextArea, orientation);
    }

    static {
        Companion = new Companion(null);
        g = Logger.getInstance((String)"#com.intellij.ide.profiler.ui.TreeChartComponent");
    }

    @NotNull
    public static final /* synthetic */ Range access$getXRange$p(TreeChartComponent treeChartComponent) {
        return treeChartComponent.m;
    }

    public static final /* synthetic */ void access$setXRange$p(TreeChartComponent treeChartComponent, @NotNull Range range) {
        treeChartComponent.m = range;
    }

    @NotNull
    public static final /* synthetic */ Range access$getYRange$p(TreeChartComponent treeChartComponent) {
        return treeChartComponent.f;
    }

    public static final /* synthetic */ void access$setYRange$p(TreeChartComponent treeChartComponent, @NotNull Range range) {
        treeChartComponent.f = range;
    }

    @NotNull
    public static final /* synthetic */ List access$getVisibleNodes$p(TreeChartComponent treeChartComponent) {
        return treeChartComponent.n;
    }

    @NotNull
    public static final /* synthetic */ JTextArea access$getAdditionalNodeInfoArea$p(TreeChartComponent treeChartComponent) {
        return treeChartComponent.l;
    }

    @NotNull
    public static final /* synthetic */ Orientation access$getOrientation$p(TreeChartComponent treeChartComponent) {
        return treeChartComponent.c;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent$Orientation;", "", "(Ljava/lang/String;I)V", "TOP_DOWN", "BOTTOM_UP", "intellij.platform.commercial"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation TOP_DOWN;
        public static final /* enum */ Orientation BOTTOM_UP;
        private static final /* synthetic */ Orientation[] a;

        static {
            Orientation[] orientationArray = new Orientation[2];
            Orientation[] orientationArray2 = orientationArray;
            orientationArray[0] = TOP_DOWN = new Orientation();
            orientationArray[1] = BOTTOM_UP = new Orientation();
            a = orientationArray;
        }

        public static Orientation[] values() {
            return (Orientation[])a.clone();
        }

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent$Companion;", "", "()V", "ACTION_MOVEMENT_FACTOR", "", "BORDER_PLUS_PADDING", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "NO_HTREE", "", "NO_RANGE", "ZOOM_FACTOR", "intellij.platform.commercial"})
    public static final class Companion {
        private final Logger a() {
            return g;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

