/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryTypeServiceImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.FormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLibraryFromFilesDialog
extends DialogWrapper {
    private final LibraryNameAndLevelPanel f;
    private final ModulesComboBox a;
    private final Project d;
    private final List<OrderRoot> e;
    private final JPanel b;
    private final String c;

    public CreateLibraryFromFilesDialog(@NotNull Project project2, @NotNull List<OrderRoot> list2) {
        if (project2 == null) {
            CreateLibraryFromFilesDialog.a(0);
        }
        if (list2 == null) {
            CreateLibraryFromFilesDialog.a(1);
        }
        super(project2, true);
        this.setTitle("Create Library");
        this.d = project2;
        this.e = list2;
        FormBuilder formBuilder = LibraryNameAndLevelPanel.createFormBuilder();
        this.c = LibrariesContainerFactory.createContainer(project2).suggestUniqueLibraryName(LibraryTypeServiceImpl.suggestLibraryName(list2));
        this.f = new LibraryNameAndLevelPanel(formBuilder, this.c, Arrays.asList(LibrariesContainer.LibraryLevel.values()), LibrariesContainer.LibraryLevel.PROJECT);
        this.f.setDefaultName(this.c);
        this.a = new ModulesComboBox();
        this.a.fillModules(this.d);
        this.a.setSelectedModule(this.a(list2));
        formBuilder.addLabeledComponent("&Add to module:", (JComponent)this.a);
        this.b = formBuilder.getPanel();
        this.f.getLibraryNameField().selectAll();
        this.f.getLevelComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateLibraryFromFilesDialog.this.a();
            }
        });
        this.f.getLibraryNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                CreateLibraryFromFilesDialog.this.c();
            }
        });
        this.init();
    }

    private void c() {
        this.setOKActionEnabled(!this.f.getLibraryName().isEmpty() || this.f.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE && this.e.size() == 1);
    }

    private void a() {
        if (this.f.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE) {
            this.f.setDefaultName(this.e.size() == 1 ? "" : this.c);
        } else {
            this.f.setDefaultName(this.c);
            if (this.f.getLibraryName().isEmpty()) {
                this.f.getLibraryNameField().setText(this.c);
            }
        }
        this.c();
    }

    @Nullable
    private Module a(List<OrderRoot> list2) {
        for (OrderRoot orderRoot : list2) {
            Module module2 = null;
            VirtualFile virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(orderRoot.getFile());
            if (virtualFile != null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)this.d);
            }
            if (module2 == null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)orderRoot.getFile(), (Project)this.d);
            }
            if (module2 == null) continue;
            return module2;
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.f.getLibraryNameField();
    }

    protected void doOKAction() {
        this.b();
        super.doOKAction();
    }

    private void b() {
        LibrariesContainer.LibraryLevel libraryLevel = this.f.getLibraryLevel();
        WriteAction.run(() -> {
            Module module2 = this.a.getSelectedModule();
            String string = this.f.getLibraryName();
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE) {
                ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                LibrariesContainerFactory.createContainer(modifiableRootModel).createLibrary(string, libraryLevel, this.e);
                modifiableRootModel.commit();
            } else {
                Library library = LibrariesContainerFactory.createContainer(this.d).createLibrary(string, libraryLevel, this.e);
                if (module2 != null) {
                    ModuleRootModificationUtil.addDependency((Module)module2, (Library)library);
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.b;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "roots";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/projectView/actions/CreateLibraryFromFilesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

