/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibrariesLayoutPanel;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class LibrariesDetectionStep
extends AbstractStepWithProgress<List<LibraryDescriptor>> {
    private final ProjectFromSourcesBuilder n;
    private final ProjectDescriptor l;
    private final ModuleInsight j;
    private final Icon i;
    private final String k;
    private LibrariesLayoutPanel m;
    int myPreviousStateHashCode = -1;

    public LibrariesDetectionStep(ProjectFromSourcesBuilder projectFromSourcesBuilder, ProjectDescriptor projectDescriptor, ModuleInsight moduleInsight, Icon icon, @NonNls String string) {
        super("Stop library analysis?");
        this.n = projectFromSourcesBuilder;
        this.l = projectDescriptor;
        this.j = moduleInsight;
        this.i = icon;
        this.k = string;
    }

    public void updateDataModel() {
        this.l.setLibraries(this.m.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.m = new LibrariesLayoutPanel(this.j);
        return this.m;
    }

    @Override
    protected String getProgressText() {
        return "Searching for libraries. Please wait.";
    }

    @Override
    protected boolean shouldRunProgress() {
        int n2 = this.b();
        try {
            boolean bl2 = n2 != this.myPreviousStateHashCode;
            return bl2;
        }
        finally {
            this.myPreviousStateHashCode = n2;
        }
    }

    private int b() {
        int n2 = this.n.getBaseProjectPath().hashCode();
        for (DetectedSourceRoot detectedSourceRoot : this.a()) {
            n2 = 31 * n2 + detectedSourceRoot.getDirectory().hashCode();
        }
        return n2;
    }

    @Override
    protected List<LibraryDescriptor> calculate() {
        List<DetectedSourceRoot> list2 = this.a();
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(FileTypeManager.getInstance().getIgnoredFilesList(), ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        this.j.setRoots(Collections.singletonList(new File(this.n.getBaseProjectPath())), list2, hashSet);
        this.j.scanLibraries();
        return this.j.getSuggestedLibraries();
    }

    private List<DetectedSourceRoot> a() {
        ArrayList<DetectedSourceRoot> arrayList = new ArrayList<DetectedSourceRoot>();
        for (ProjectStructureDetector projectStructureDetector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            for (DetectedProjectRoot detectedProjectRoot : this.n.getProjectRoots(projectStructureDetector)) {
                if (!this.j.isApplicableRoot(detectedProjectRoot)) continue;
                arrayList.add((DetectedSourceRoot)detectedProjectRoot);
            }
        }
        return arrayList;
    }

    @Override
    protected void onFinished(List<LibraryDescriptor> list2, boolean bl2) {
        this.m.rebuild();
    }

    public Icon getIcon() {
        return this.i;
    }

    public String getHelpId() {
        return this.k;
    }
}

