/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectLayoutPanel;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LibrariesLayoutPanel
extends ProjectLayoutPanel<LibraryDescriptor> {
    public LibrariesLayoutPanel(ModuleInsight moduleInsight) {
        super(moduleInsight);
    }

    @Override
    protected String getElementName(LibraryDescriptor libraryDescriptor) {
        return libraryDescriptor.getName();
    }

    @Override
    protected void setElementName(LibraryDescriptor libraryDescriptor, String string) {
        libraryDescriptor.setName(string);
    }

    @Override
    protected List<LibraryDescriptor> getEntries() {
        List<LibraryDescriptor> list2 = this.getInsight().getSuggestedLibraries();
        return list2 != null ? list2 : Collections.emptyList();
    }

    @Override
    protected Collection getDependencies(LibraryDescriptor libraryDescriptor) {
        return libraryDescriptor.getJars();
    }

    @Override
    protected LibraryDescriptor merge(List<LibraryDescriptor> list2) {
        ModuleInsight moduleInsight = this.getInsight();
        LibraryDescriptor libraryDescriptor = null;
        for (LibraryDescriptor libraryDescriptor2 : list2) {
            if (libraryDescriptor == null) {
                libraryDescriptor = libraryDescriptor2;
                continue;
            }
            Collection<File> collection = libraryDescriptor2.getJars();
            moduleInsight.moveJarsToLibrary(libraryDescriptor2, collection, libraryDescriptor);
        }
        return libraryDescriptor;
    }

    @Override
    protected LibraryDescriptor split(LibraryDescriptor libraryDescriptor, String string, Collection<File> collection) {
        return this.getInsight().splitLibrary(libraryDescriptor, string, collection);
    }

    @Override
    protected Collection<File> getContent(LibraryDescriptor libraryDescriptor) {
        return libraryDescriptor.getJars();
    }

    @Override
    protected String getEntriesChooserTitle() {
        return "Libraries";
    }

    @Override
    protected String getDependenciesTitle() {
        return "Library contents";
    }

    @Override
    protected String getElementTypeName() {
        return "library";
    }

    @Override
    protected String getSplitDialogChooseFilesPrompt() {
        return "&Select jars to extract to the new library:";
    }

    @Override
    protected String getNameAlreadyUsedMessage(String string) {
        return "library with name " + string + " already exists";
    }

    @Override
    protected String getStepDescriptionText() {
        return "Please review libraries found. At this stage you can set library names that will be used in the project,\nexclude particular libraries from the project, or move individual files between the libraries.";
    }
}

