/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleDescriptor {
    private String f;
    private final MultiMap<File, DetectedSourceRoot> b = new MultiMap();
    private final Set<File> g = new HashSet<File>();
    private final Set<ModuleDescriptor> a = new HashSet<ModuleDescriptor>();
    private static final Set<String> e = new THashSet(Arrays.asList("java", "src", "source", "sources", "C:", "D:", "E:", "F:", "temp", "tmp"), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private boolean h;
    private final List<ModuleBuilder.ModuleConfigurationUpdater> c = new SmartList();
    private final ModuleType d;

    public ModuleDescriptor(File file, ModuleType moduleType, Collection<? extends DetectedSourceRoot> collection) {
        this.f = ModuleDescriptor.a(file);
        this.b.putValues((Object)file, collection);
        this.d = moduleType;
    }

    public ModuleDescriptor(File file, ModuleType moduleType, DetectedSourceRoot detectedSourceRoot) {
        this(file, moduleType, Collections.singletonList(detectedSourceRoot));
    }

    public void reuseExisting(boolean bl2) {
        this.h = bl2;
    }

    public void addConfigurationUpdater(ModuleBuilder.ModuleConfigurationUpdater moduleConfigurationUpdater) {
        this.c.add(moduleConfigurationUpdater);
    }

    public void updateModuleConfiguration(Module module2, ModifiableRootModel modifiableRootModel) {
        for (ModuleBuilder.ModuleConfigurationUpdater moduleConfigurationUpdater : this.c) {
            moduleConfigurationUpdater.update(module2, modifiableRootModel);
        }
    }

    public boolean isReuseExistingElement() {
        return this.h;
    }

    public ModuleType getModuleType() {
        return this.d;
    }

    private static String a(File file) {
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            String string = file2.getName();
            if (e.contains(string)) continue;
            return string;
        }
        return file.getName();
    }

    public String getName() {
        return this.f;
    }

    public void setName(String string) {
        this.f = string;
    }

    public Set<File> getContentRoots() {
        return Collections.unmodifiableSet(this.b.keySet());
    }

    public Collection<? extends DetectedProjectRoot> getSourceRoots() {
        return this.b.values();
    }

    public Collection<DetectedSourceRoot> getSourceRoots(File file) {
        return this.b.get((Object)file);
    }

    public void addContentRoot(File file) {
        this.b.put((Object)file, new HashSet());
    }

    public Collection<DetectedSourceRoot> removeContentRoot(File file) {
        return this.b.remove((Object)file);
    }

    public void addSourceRoot(File file, DetectedSourceRoot detectedSourceRoot) {
        this.b.putValue((Object)file, (Object)detectedSourceRoot);
    }

    public void addDependencyOn(ModuleDescriptor moduleDescriptor) {
        this.a.add(moduleDescriptor);
    }

    public void removeDependencyOn(ModuleDescriptor moduleDescriptor) {
        this.a.remove(moduleDescriptor);
    }

    public void addLibraryFile(File file) {
        this.g.add(file);
    }

    public Set<File> getLibraryFiles() {
        return this.g;
    }

    public Set<ModuleDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.a);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Module: ").append(this.getContentRoots()).append(" | ");
        for (DetectedProjectRoot detectedProjectRoot : this.getSourceRoots()) {
            stringBuilder.append(detectedProjectRoot.getDirectory().getName()).append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void clearModuleDependencies() {
        this.a.clear();
    }

    public void clearLibraryFiles() {
        this.g.clear();
    }

    @NotNull
    public String computeModuleFilePath() throws InvalidDataException {
        String string = this.getName();
        Set<File> set = this.getContentRoots();
        if (set.size() > 0) {
            String string2 = set.iterator().next().getPath() + File.separator + string + ".iml";
            if (string2 == null) {
                ModuleDescriptor.a(0);
            }
            return string2;
        }
        throw new InvalidDataException("Module " + string + " has no content roots and will not be created.");
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleDescriptor", "computeModuleFilePath"));
    }
}

