/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ModulesLayoutPanel;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class ModulesDetectionStep
extends AbstractStepWithProgress<List<ModuleDescriptor>> {
    private final ProjectStructureDetector o;
    private final ProjectFromSourcesBuilder j;
    private final ProjectDescriptor m;
    private final ModuleInsight i;
    private final Icon l;
    private final String k;
    private ModulesLayoutPanel n;
    int myPreviousStateHashCode = -1;

    public ModulesDetectionStep(ProjectStructureDetector projectStructureDetector, ProjectFromSourcesBuilder projectFromSourcesBuilder, ProjectDescriptor projectDescriptor, ModuleInsight moduleInsight, Icon icon, @NonNls String string) {
        super("Stop module analysis?");
        this.o = projectStructureDetector;
        this.j = projectFromSourcesBuilder;
        this.m = projectDescriptor;
        this.i = moduleInsight;
        this.l = icon;
        this.k = string;
    }

    public void updateDataModel() {
        this.m.setModules(this.n.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.n = new ModulesLayoutPanel(this.i, new ModulesLayoutPanel.LibraryFilter(){

            @Override
            public boolean isLibraryChosen(LibraryDescriptor libraryDescriptor) {
                return ModulesDetectionStep.this.m.isLibraryChosen(libraryDescriptor);
            }
        });
        return this.n;
    }

    @Override
    protected String getProgressText() {
        return "Searching for modules. Please wait.";
    }

    @Override
    protected boolean shouldRunProgress() {
        int n2 = this.a();
        try {
            boolean bl2 = n2 != this.myPreviousStateHashCode;
            return bl2;
        }
        finally {
            this.myPreviousStateHashCode = n2;
        }
    }

    private int a() {
        String string = this.j.getBaseProjectPath();
        int n2 = string != null ? string.hashCode() : 1;
        for (DetectedProjectRoot object2 : this.j.getProjectRoots(this.o)) {
            n2 = 31 * n2 + object2.getDirectory().hashCode();
        }
        List<LibraryDescriptor> list2 = this.m.getLibraries();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            LibraryDescriptor libraryDescriptor = (LibraryDescriptor)iterator.next();
            Collection<File> collection = libraryDescriptor.getJars();
            for (File file : collection) {
                n2 = 31 * n2 + file.hashCode();
            }
        }
        return n2;
    }

    @Override
    protected List<ModuleDescriptor> calculate() {
        this.i.scanModules();
        List<ModuleDescriptor> list2 = this.i.getSuggestedModules();
        return list2 != null ? list2 : Collections.emptyList();
    }

    @Override
    public boolean validate() throws ConfigurationException {
        boolean bl2 = super.validate();
        if (!bl2) {
            return false;
        }
        List list2 = this.n.getChosenEntries();
        LinkedHashMap<String, ModuleDescriptor> linkedHashMap = new LinkedHashMap<String, ModuleDescriptor>();
        for (Object object : list2) {
            try {
                Object object2 = ((ModuleDescriptor)object).computeModuleFilePath();
                if (!new File((String)object2).exists()) continue;
                linkedHashMap.put(IdeBundle.message((String)"warning.message.the.module.file.0.already.exist.and.will.be.overwritten", (Object[])new Object[]{object2}), (ModuleDescriptor)object);
            }
            catch (InvalidDataException invalidDataException) {
                linkedHashMap.put(invalidDataException.getMessage(), (ModuleDescriptor)object);
            }
        }
        if (!linkedHashMap.isEmpty()) {
            int n2 = Messages.showYesNoCancelDialog((Component)this.getComponent(), (String)IdeBundle.message((String)"warning.text.0.do.you.want.to.overwrite.these.files", (Object[])new Object[]{StringUtil.join(linkedHashMap.keySet(), (String)"\n"), linkedHashMap.size()}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (String)"Overwrite", (String)"Reuse", (String)"Cancel", (Icon)Messages.getQuestionIcon());
            if (n2 == 2) {
                return false;
            }
            if (n2 != 0) {
                for (Object object2 : linkedHashMap.values()) {
                    ((ModuleDescriptor)object2).reuseExisting(true);
                }
            }
        }
        return true;
    }

    @Override
    protected void onFinished(List<ModuleDescriptor> list2, boolean bl2) {
        this.n.rebuild();
    }

    @NonNls
    public String getHelpId() {
        return this.k;
    }

    public Icon getIcon() {
        return this.l;
    }
}

