/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectLayoutPanel<T>
extends JPanel {
    private final ElementsChooser<T> b;
    private final JList d;
    private final ModuleInsight c;
    private final Comparator<T> a = (object, object2) -> {
        int n2;
        int n3 = this.getWeight(object);
        if (n3 != (n2 = this.getWeight(object2))) {
            return n3 - n2;
        }
        return ProjectLayoutPanel.getElementText(object).compareToIgnoreCase(ProjectLayoutPanel.getElementText(object2));
    };

    public ProjectLayoutPanel(ModuleInsight moduleInsight) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.c = moduleInsight;
        this.b = new ElementsChooser<T>(true){

            public String getItemText(@NotNull T t2) {
                if (t2 == null) {
                    1.a(0);
                }
                return ProjectLayoutPanel.getElementText(t2);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/importProject/ProjectLayoutPanel$1", "getItemText"));
            }
        };
        this.d = this.b();
        Splitter splitter = new Splitter(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.b, "Center");
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)StringUtil.capitalize((String)StringUtil.pluralize((String)this.getElementTypeName())), (boolean)false));
        splitter.setFirstComponent((JComponent)jPanel);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.d);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.getDependenciesTitle(), (boolean)false));
        splitter.setSecondComponent((JComponent)jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.a().getComponent(), "North");
        jPanel3.add((Component)splitter, "Center");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        MultiLineLabel multiLineLabel = new MultiLineLabel(this.getStepDescriptionText());
        this.add((Component)multiLineLabel, "North");
        this.add((Component)jPanel3, "Center");
        this.b.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                List list2 = ProjectLayoutPanel.this.getSelectedEntries();
                Collection collection = ProjectLayoutPanel.this.getDependencies(list2);
                DefaultListModel defaultListModel = (DefaultListModel)ProjectLayoutPanel.this.d.getModel();
                defaultListModel.clear();
                for (Object e2 : ProjectLayoutPanel.this.a(new ArrayList(collection))) {
                    defaultListModel.addElement(e2);
                }
            }
        });
    }

    private ActionToolbar a() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        RenameAction renameAction = new RenameAction();
        renameAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(117, 64)), this);
        defaultActionGroup.add((AnAction)renameAction);
        MergeAction mergeAction = new MergeAction();
        mergeAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(114, 0)), this);
        defaultActionGroup.add((AnAction)mergeAction);
        SplitAction splitAction = new SplitAction();
        splitAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), this);
        defaultActionGroup.add((AnAction)splitAction);
        return ActionManager.getInstance().createActionToolbar("ProjectLayoutPanel.Entries", (ActionGroup)defaultActionGroup, true);
    }

    public final ModuleInsight getInsight() {
        return this.c;
    }

    private JList b() {
        JBList jBList = new JBList(new DefaultListModel());
        jBList.getSelectionModel().setSelectionMode(2);
        jBList.setCellRenderer(new MyListCellRenderer());
        return jBList;
    }

    public final Collection getDependencies(List<T> list2) {
        HashSet hashSet = new HashSet();
        for (T t2 : list2) {
            hashSet.addAll(this.getDependencies(t2));
        }
        return hashSet;
    }

    @NotNull
    public List<T> getSelectedEntries() {
        List list2 = this.b.getSelectedElements();
        if (list2 == null) {
            ProjectLayoutPanel.a(0);
        }
        return list2;
    }

    @NotNull
    public List<T> getChosenEntries() {
        List list2 = this.b.getMarkedElements();
        if (list2 == null) {
            ProjectLayoutPanel.a(1);
        }
        return list2;
    }

    public void rebuild() {
        this.b.clear();
        for (T t2 : this.a(this.getEntries())) {
            this.b.addElement(t2, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(t2));
        }
        if (this.b.getElementCount() > 0) {
            this.b.selectElements(Collections.singleton(this.b.getElementAt(0)));
        }
    }

    private List<T> a(List<T> list2) {
        Collections.sort(list2, this.a);
        return list2;
    }

    @Nullable
    protected Icon getElementIcon(Object object) {
        if (object instanceof ModuleDescriptor) {
            return ((ModuleDescriptor)object).getModuleType().getIcon();
        }
        if (object instanceof LibraryDescriptor) {
            return PlatformIcons.LIBRARY_ICON;
        }
        if (object instanceof File) {
            File file = (File)object;
            return file.isDirectory() ? PlatformIcons.DIRECTORY_CLOSED_ICON : PlatformIcons.JAR_ICON;
        }
        return null;
    }

    protected int getWeight(Object object) {
        if (object instanceof File) {
            return 10;
        }
        if (object instanceof ModuleDescriptor) {
            return 20;
        }
        if (object instanceof LibraryDescriptor) {
            return ((LibraryDescriptor)object).getJars().size() > 1 ? 30 : 40;
        }
        return Integer.MAX_VALUE;
    }

    protected static String getElementText(Object object) {
        if (object instanceof LibraryDescriptor) {
            File file;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((LibraryDescriptor)object).getName());
            Collection<File> collection = ((LibraryDescriptor)object).getJars();
            if (collection.size() == 1 && (file = collection.iterator().next().getParentFile()) != null) {
                stringBuilder.append(" (");
                stringBuilder.append(file.getPath());
                stringBuilder.append(")");
            }
            return stringBuilder.toString();
        }
        if (object instanceof File) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((File)object).getName());
            File file = ((File)object).getParentFile();
            if (file != null) {
                stringBuilder.append(" (");
                stringBuilder.append(file.getPath());
                stringBuilder.append(")");
            }
            return stringBuilder.toString();
        }
        if (object instanceof ModuleDescriptor) {
            Collection<? extends DetectedProjectRoot> collection;
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(moduleDescriptor.getName());
            Set<File> set = moduleDescriptor.getContentRoots();
            int n2 = set.size();
            if (n2 > 0) {
                stringBuilder.append(" (");
                stringBuilder.append(set.iterator().next().getPath());
                if (n2 > 1) {
                    stringBuilder.append("...");
                }
                stringBuilder.append(")");
            }
            if ((collection = moduleDescriptor.getSourceRoots()).size() > 0) {
                stringBuilder.append(" [");
                Iterator<? extends DetectedProjectRoot> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DetectedProjectRoot detectedProjectRoot = iterator.next();
                    stringBuilder.append(detectedProjectRoot.getDirectory().getName());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    protected abstract List<T> getEntries();

    protected abstract Collection getDependencies(T var1);

    @Nullable
    protected abstract T merge(List<T> var1);

    @Nullable
    protected abstract T split(T var1, String var2, Collection<File> var3);

    protected abstract Collection<File> getContent(T var1);

    protected abstract String getElementName(T var1);

    protected abstract void setElementName(T var1, String var2);

    protected abstract String getSplitDialogChooseFilesPrompt();

    protected abstract String getNameAlreadyUsedMessage(String var1);

    protected abstract String getStepDescriptionText();

    protected abstract String getEntriesChooserTitle();

    protected abstract String getDependenciesTitle();

    protected abstract String getElementTypeName();

    private boolean a(String string) {
        HashSet hashSet = new HashSet(this.b.getSelectedElements());
        for (T t2 : this.getEntries()) {
            if (hashSet.contains(t2) || !string.equals(this.getElementName(t2))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/importProject/ProjectLayoutPanel";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEntries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenEntries";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EntryProperties
    implements MultiStateElementsChooser.ElementProperties {
        private final T a;

        public EntryProperties(T t2) {
            this.a = t2;
        }

        public Icon getIcon() {
            return ProjectLayoutPanel.this.getElementIcon(this.a);
        }
    }

    private class SplitDialog
    extends DialogWrapper {
        final JTextField myNameField;
        final ElementsChooser<File> myChooser;

        private SplitDialog(Collection<File> collection) {
            super((Component)ProjectLayoutPanel.this.b, true);
            this.setTitle("Split " + StringUtil.capitalize((String)ProjectLayoutPanel.this.getElementTypeName()));
            this.myNameField = new JTextField();
            this.myChooser = new ElementsChooser<File>(true){

                protected String getItemText(@NotNull File file) {
                    if (file == null) {
                        1.a(0);
                    }
                    return ProjectLayoutPanel.getElementText(file);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitDialog$1", "getItemText"));
                }
            };
            for (final File file : collection) {
                this.myChooser.addElement((Object)file, false, new MultiStateElementsChooser.ElementProperties(){

                    public Icon getIcon() {
                        return ProjectLayoutPanel.this.getElementIcon(file);
                    }
                });
            }
            this.myChooser.selectElements((Collection)ContainerUtil.createMaybeSingletonList((Object)ContainerUtil.getFirstItem(collection)));
            this.myChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)new ElementsChooser.ElementsMarkListener<File>(){

                public void elementMarkChanged(File file, boolean bl2) {
                    SplitDialog.this.a();
                }
            });
            this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent documentEvent) {
                    SplitDialog.this.a();
                }
            });
            this.init();
            this.a();
        }

        private void a() {
            this.setOKActionEnabled(!this.getName().isEmpty() && !this.getChosenFiles().isEmpty());
        }

        protected void doOKAction() {
            String string = this.getName();
            if (ProjectLayoutPanel.this.a(string)) {
                Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(string), (String)"");
                return;
            }
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            FormBuilder formBuilder = FormBuilder.createFormBuilder().setVertical(true);
            formBuilder.addLabeledComponent("&Name:", (JComponent)this.myNameField);
            formBuilder.addLabeledComponent(ProjectLayoutPanel.this.getSplitDialogChooseFilesPrompt(), this.myChooser);
            this.myChooser.setPreferredSize((Dimension)JBUI.size((int)450, (int)300));
            return formBuilder.getPanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public String getName() {
            return this.myNameField.getText().trim();
        }

        public Collection<File> getChosenFiles() {
            return this.myChooser.getMarkedElements();
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            this.setText(ProjectLayoutPanel.getElementText(object));
            this.setIcon(ProjectLayoutPanel.this.getElementIcon(object));
            return component;
        }
    }

    private class RenameAction
    extends AnAction {
        private RenameAction() {
            super("Rename", "", IconUtil.getEditIcon());
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            List list2 = ProjectLayoutPanel.this.b.getSelectedElements();
            if (list2.size() == 1) {
                Object e2 = list2.get(0);
                String string = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)("New name for " + ProjectLayoutPanel.this.getElementTypeName() + " '" + ProjectLayoutPanel.this.getElementName(e2) + "':"), (String)("Rename " + StringUtil.capitalize((String)ProjectLayoutPanel.this.getElementTypeName())), (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName(e2), (InputValidator)new InputValidator(){

                    public boolean checkInput(String string) {
                        return true;
                    }

                    public boolean canClose(String string) {
                        if (ProjectLayoutPanel.this.a(string.trim())) {
                            Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(string), (String)"");
                            return false;
                        }
                        return true;
                    }
                });
                if (string != null) {
                    ProjectLayoutPanel.this.setElementName(e2, string);
                    ProjectLayoutPanel.this.b.sort(ProjectLayoutPanel.this.a);
                    ProjectLayoutPanel.this.b.selectElements(Collections.singleton(e2));
                }
            }
        }

        public void update(AnActionEvent anActionEvent) {
            super.update(anActionEvent);
            anActionEvent.getPresentation().setEnabled(ProjectLayoutPanel.this.b.getSelectedElements().size() == 1);
        }
    }

    private class SplitAction
    extends AnAction {
        private SplitAction() {
            super("Split", "", AllIcons.Modules.Split);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            Collection<File> collection;
            String string;
            Object e2;
            Object e3;
            Collection<File> collection2;
            SplitDialog splitDialog;
            List list2 = ProjectLayoutPanel.this.b.getSelectedElements();
            if (list2.size() == 1 && (splitDialog = new SplitDialog(collection2 = ProjectLayoutPanel.this.getContent(e3 = list2.get(0)))).showAndGet() && (e2 = ProjectLayoutPanel.this.split(e3, string = splitDialog.getName(), collection = splitDialog.getChosenFiles())) != null) {
                if (!ProjectLayoutPanel.this.getEntries().contains(e3)) {
                    ProjectLayoutPanel.this.b.removeElement(e3);
                }
                ProjectLayoutPanel.this.b.addElement(e2, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(e2));
                ProjectLayoutPanel.this.b.sort(ProjectLayoutPanel.this.a);
                ProjectLayoutPanel.this.b.selectElements(Collections.singleton(e2));
            }
        }

        public void update(AnActionEvent anActionEvent) {
            List list2 = ProjectLayoutPanel.this.b.getSelectedElements();
            anActionEvent.getPresentation().setEnabled(list2.size() == 1 && ProjectLayoutPanel.this.getContent(list2.get(0)).size() > 1);
        }
    }

    private class MergeAction
    extends AnAction {
        private MergeAction() {
            super("Merge", "", AllIcons.Modules.Merge);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            String string;
            List list2 = ProjectLayoutPanel.this.b.getSelectedElements();
            if (list2.size() > 1 && (string = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)"Enter new name for merge result:", (String)"Merge", (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName(list2.get(0)), (InputValidator)new InputValidator(){

                public boolean checkInput(String string) {
                    return true;
                }

                public boolean canClose(String string) {
                    if (ProjectLayoutPanel.this.a(string.trim())) {
                        Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(string), (String)"");
                        return false;
                    }
                    return true;
                }
            })) != null) {
                Object t2 = ProjectLayoutPanel.this.merge(list2);
                ProjectLayoutPanel.this.setElementName(t2, string);
                for (Object e2 : list2) {
                    ProjectLayoutPanel.this.b.removeElement(e2);
                }
                ProjectLayoutPanel.this.b.addElement(t2, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(t2));
                ProjectLayoutPanel.this.b.sort(ProjectLayoutPanel.this.a);
                ProjectLayoutPanel.this.b.selectElements(Collections.singleton(t2));
            }
        }

        public void update(AnActionEvent anActionEvent) {
            super.update(anActionEvent);
            anActionEvent.getPresentation().setEnabled(ProjectLayoutPanel.this.b.getSelectedElements().size() > 1);
        }
    }
}

