/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.projectWizard.importSources.DetectedContentRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RootDetectionProcessor {
    private static final Logger d = Logger.getInstance((String)"#com.intellij.ide.util.importProject.RootDetectionProcessor");
    private final File e;
    private final ProjectStructureDetector[] b;
    private final List<DetectedProjectRoot>[] a;
    private final FileTypeManager c;
    private final ProgressIndicator f;

    @NotNull
    public static List<DetectedRootData> detectRoots(@NotNull File file) {
        if (file == null) {
            RootDetectionProcessor.a(0);
        }
        List<DetectedRootData> list2 = new RootDetectionProcessor(file, (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()).a();
        if (list2 == null) {
            RootDetectionProcessor.a(1);
        }
        return list2;
    }

    public RootDetectionProcessor(File file, ProjectStructureDetector[] projectStructureDetectorArray) {
        this.e = RootDetectionProcessor.a(file);
        this.b = projectStructureDetectorArray;
        this.a = new List[this.b.length];
        this.c = FileTypeManager.getInstance();
        this.f = ProgressManager.getInstance().getProgressIndicator();
    }

    private static File a(File file) {
        try {
            return new File(FileUtil.resolveShortWindowsName((String)file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            d.info((Throwable)iOException);
            return file;
        }
    }

    public static MultiMap<ProjectStructureDetector, DetectedProjectRoot> createRootsMap(List<DetectedRootData> list2) {
        MultiMap multiMap = new MultiMap();
        for (DetectedRootData detectedRootData : list2) {
            for (ProjectStructureDetector projectStructureDetector : detectedRootData.getSelectedDetectors()) {
                multiMap.putValue((Object)projectStructureDetector, (Object)detectedRootData.getSelectedRoot());
            }
        }
        return multiMap;
    }

    public Map<ProjectStructureDetector, List<DetectedProjectRoot>> runDetectors() {
        if (!this.e.isDirectory()) {
            return Collections.emptyMap();
        }
        BitSet bitSet = new BitSet(this.b.length);
        bitSet.set(0, this.b.length);
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.a[i2] = new ArrayList<DetectedProjectRoot>();
        }
        THashSet tHashSet = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (File file = this.e.getParentFile(); file != null; file = file.getParentFile()) {
            tHashSet.add(file);
        }
        this.a(this.e, bitSet, (Set<File>)tHashSet);
        LinkedHashMap<ProjectStructureDetector, List<DetectedProjectRoot>> linkedHashMap = new LinkedHashMap<ProjectStructureDetector, List<DetectedProjectRoot>>();
        for (int i3 = 0; i3 < this.b.length; ++i3) {
            if (this.a[i3].isEmpty()) continue;
            linkedHashMap.put(this.b[i3], this.a[i3]);
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<File, Integer>> a(File file, BitSet bitSet, Set<File> set) {
        SmartList smartList = new SmartList();
        if (this.c.isFileIgnored(file.getName())) {
            return smartList;
        }
        if (this.f != null) {
            if (this.f.isCanceled()) {
                return smartList;
            }
            this.f.setText2(file.getPath());
        }
        if (FileSystemUtil.isSymLink((File)file)) {
            try {
                if (set.contains(file.getCanonicalFile())) {
                    return smartList;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            set.add(file);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                fileArray = ArrayUtil.EMPTY_FILE_ARRAY;
            }
            BitSet bitSet2 = bitSet;
            int n2 = this.b.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file2;
                if (!bitSet.get(i2)) continue;
                ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = this.b[i2].detectRoots(file, fileArray, this.e, this.a[i2]);
                if (!directoryProcessingResult.isProcessChildren()) {
                    if (bitSet2 == bitSet) {
                        bitSet2 = new BitSet();
                        bitSet2.or(bitSet);
                    }
                    bitSet2.set(i2, false);
                }
                if ((file2 = directoryProcessingResult.getParentToSkip()) == null || FileUtil.filesEqual((File)file2, (File)file)) continue;
                smartList.add(Pair.create((Object)file2, (Object)i2));
            }
            if (!bitSet2.isEmpty()) {
                for (File file2 : fileArray) {
                    List<Pair<File, Integer>> list2;
                    if (!file2.isDirectory() || (list2 = this.a(file2, bitSet2, set)).isEmpty()) continue;
                    if (bitSet2 == bitSet) {
                        bitSet2 = new BitSet();
                        bitSet2.or(bitSet);
                    }
                    for (Pair<File, Integer> pair2 : list2) {
                        bitSet2.set((int)((Integer)pair2.getSecond()), false);
                        if (FileUtil.filesEqual((File)((File)pair2.getFirst()), (File)file)) continue;
                        smartList.add(pair2);
                    }
                    if (bitSet2.isEmpty()) break;
                }
            }
            SmartList smartList2 = smartList;
            return smartList2;
        }
        finally {
            set.remove(file);
        }
    }

    private static void b(DetectedProjectRoot detectedProjectRoot, Map<File, DetectedRootData> map) {
        DetectedRootData[] detectedRootDataArray;
        for (DetectedRootData detectedRootData : detectedRootDataArray = map.values().toArray(new DetectedRootData[0])) {
            File file = detectedRootData.getDirectory();
            if (!FileUtil.isAncestor((File)detectedProjectRoot.getDirectory(), (File)file, (boolean)true)) continue;
            for (DetectedProjectRoot detectedProjectRoot2 : detectedRootData.getAllRoots()) {
                if (detectedProjectRoot.canContainRoot(detectedProjectRoot2)) continue;
                detectedRootData.removeRoot(detectedProjectRoot2);
            }
            if (!detectedRootData.isEmpty()) continue;
            map.remove(file);
        }
    }

    private static boolean a(DetectedProjectRoot detectedProjectRoot, Map<File, DetectedRootData> map) {
        for (File file = detectedProjectRoot.getDirectory().getParentFile(); file != null; file = file.getParentFile()) {
            DetectedRootData detectedRootData = map.get(file);
            if (detectedRootData == null) continue;
            for (DetectedProjectRoot detectedProjectRoot2 : detectedRootData.getAllRoots()) {
                if (detectedProjectRoot2.canContainRoot(detectedProjectRoot)) continue;
                return true;
            }
        }
        return false;
    }

    private List<DetectedRootData> a() {
        Map<ProjectStructureDetector, List<DetectedProjectRoot>> map = this.runDetectors();
        if (this.f != null) {
            this.f.setText2("Processing " + map.values().size() + " project roots...");
        }
        LinkedHashMap<File, DetectedRootData> linkedHashMap = new LinkedHashMap<File, DetectedRootData>();
        for (ProjectStructureDetector projectStructureDetector : map.keySet()) {
            for (DetectedProjectRoot detectedProjectRoot : map.get(projectStructureDetector)) {
                if (RootDetectionProcessor.a(detectedProjectRoot, linkedHashMap)) continue;
                DetectedRootData detectedRootData = (DetectedRootData)linkedHashMap.get(detectedProjectRoot.getDirectory());
                if (detectedRootData == null) {
                    linkedHashMap.put(detectedProjectRoot.getDirectory(), new DetectedRootData(projectStructureDetector, detectedProjectRoot));
                } else {
                    detectedProjectRoot = detectedRootData.addRoot(projectStructureDetector, detectedProjectRoot);
                }
                RootDetectionProcessor.b(detectedProjectRoot, linkedHashMap);
            }
        }
        List<DetectedRootData> list2 = this.a(linkedHashMap);
        if (this.f != null) {
            this.f.setText2("");
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private List<DetectedRootData> a(Map<File, DetectedRootData> map) {
        d.debug(map.size() + " roots found, merging content roots");
        boolean bl2 = false;
        HashSet hashSet = new HashSet();
        HashSet<ModuleType> hashSet2 = new HashSet<ModuleType>();
        block0: for (DetectedRootData object : map.values()) {
            for (DetectedProjectRoot detectedProjectRoot : object.getAllRoots()) {
                if (detectedProjectRoot instanceof DetectedContentRoot) {
                    Collections.addAll(hashSet, ((DetectedContentRoot)detectedProjectRoot).getTypesToReplace());
                    hashSet2.add(((DetectedContentRoot)detectedProjectRoot).getModuleType());
                    continue;
                }
                if (!(detectedProjectRoot instanceof DetectedSourceRoot)) continue;
                d.debug("Source root found: " + detectedProjectRoot.getDirectory() + ", content roots will be ignored");
                bl2 = true;
                continue block0;
            }
        }
        hashSet2.removeAll(hashSet);
        if (bl2 || hashSet2.size() <= 1) {
            void var7_12;
            void var6_8;
            Iterator<DetectedRootData> iterator = map.values().iterator();
            Object var6_7 = null;
            Object var7_11 = null;
            while (iterator.hasNext()) {
                DetectedRootData detectedRootData = iterator.next();
                for (DetectedProjectRoot detectedProjectRoot : detectedRootData.getAllRoots()) {
                    if (!(detectedProjectRoot instanceof DetectedContentRoot)) continue;
                    d.debug("Removed detected " + detectedProjectRoot.getRootTypeName() + " content root: " + detectedProjectRoot.getDirectory());
                    Collection<ProjectStructureDetector> collection = detectedRootData.removeRoot(detectedProjectRoot);
                    if (var6_8 != null && var7_12 != null || !hashSet2.contains(((DetectedContentRoot)detectedProjectRoot).getModuleType())) continue;
                    DetectedContentRoot detectedContentRoot = (DetectedContentRoot)detectedProjectRoot;
                    ProjectStructureDetector projectStructureDetector = (ProjectStructureDetector)ContainerUtil.getFirstItem(collection);
                }
                if (!detectedRootData.isEmpty()) continue;
                iterator.remove();
            }
            if (!bl2 && var6_8 != null && var7_12 != null) {
                DetectedContentRoot detectedContentRoot = new DetectedContentRoot(this.e, var6_8.getRootTypeName(), var6_8.getModuleType(), new ModuleType[0]);
                DetectedRootData detectedRootData = map.get(this.e);
                if (detectedRootData == null) {
                    map.put(this.e, new DetectedRootData((ProjectStructureDetector)var7_12, detectedContentRoot));
                } else {
                    detectedRootData.addRoot((ProjectStructureDetector)var7_12, detectedContentRoot);
                }
                d.debug("Added " + var6_8.getRootTypeName() + " content root for " + this.e);
            }
        }
        return new ArrayList<DetectedRootData>(map.values());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseProjectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/importProject/RootDetectionProcessor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/importProject/RootDetectionProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

