/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.importProject.DetectedRootsChooser;
import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RootsDetectionStep
extends AbstractStepWithProgress<List<DetectedRootData>> {
    private static final String q = "roots_found";
    private static final String m = "roots_not_found";
    private final ProjectFromSourcesBuilderImpl l;
    private final WizardContext n;
    private final StepSequence i;
    private final Icon p;
    private final String k;
    private DetectedRootsChooser o;
    private String r = null;
    private JPanel j;

    public RootsDetectionStep(ProjectFromSourcesBuilderImpl projectFromSourcesBuilderImpl, WizardContext wizardContext, StepSequence stepSequence, Icon icon, @NonNls String string) {
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.l = projectFromSourcesBuilderImpl;
        this.n = wizardContext;
        this.i = stepSequence;
        this.p = icon;
        this.k = string;
    }

    @Override
    protected JComponent createResultsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.o = new DetectedRootsChooser();
        this.o.addSelectionListener(new DetectedRootsChooser.RootSelectionListener(){

            @Override
            public void selectionChanged() {
                RootsDetectionStep.this.b();
            }
        });
        String string = IdeBundle.message((String)"label.project.roots.have.been.found", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.o.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton jButton2 = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RootsDetectionStep.this.o.setAllElementsMarked(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RootsDetectionStep.this.o.setAllElementsMarked(false);
            }
        });
        this.j = new JPanel(new CardLayout());
        this.j.add(q, jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(JBUI.Borders.empty((int)5));
        jPanel2.add("North", (Component)new MultiLineLabel(IdeBundle.message((String)"label.project.roots.not.found", (Object[])new Object[0])));
        this.j.add(m, jPanel2);
        return this.j;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.o.getComponent();
    }

    public void updateDataModel() {
        List<DetectedRootData> list2 = this.o.getMarkedElements();
        this.l.setupProjectStructure(RootDetectionProcessor.createRootsMap(list2));
        this.b();
    }

    private void b() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("Existing Sources");
        for (DetectedRootData detectedRootData : this.o.getMarkedElements()) {
            for (ProjectStructureDetector projectStructureDetector : detectedRootData.getSelectedDetectors()) {
                linkedHashSet.add(projectStructureDetector.getDetectorId());
            }
        }
        this.i.setTypes(linkedHashSet);
        this.n.requestWizardButtonsUpdate();
    }

    @Override
    protected boolean shouldRunProgress() {
        String string = this.a();
        return this.r == null ? string != null : !this.r.equals(string);
    }

    @Override
    protected void onFinished(List<DetectedRootData> list2, boolean bl2) {
        CardLayout cardLayout = (CardLayout)this.j.getLayout();
        if (list2.size() > 0 && !bl2) {
            this.r = this.a();
            this.o.setElements(list2);
            this.b();
            cardLayout.show(this.j, q);
        } else {
            this.r = null;
            cardLayout.show(this.j, m);
        }
        this.j.revalidate();
    }

    @Override
    protected List<DetectedRootData> calculate() {
        String string = this.a();
        if (string == null) {
            return Collections.emptyList();
        }
        return RootDetectionProcessor.detectRoots(new File(string));
    }

    @Nullable
    private String a() {
        return this.l.getBaseProjectPath();
    }

    @Override
    protected String getProgressText() {
        String string = this.a();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{string != null ? string.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.p;
    }

    public String getHelpId() {
        return this.k;
    }
}

