/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetector;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSourceRootDetectionUtil {
    private static final TokenSet a = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.MODIFIER_BIT_SET, ElementType.CLASS_KEYWORD_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.AT, JavaTokenType.IMPORT_KEYWORD})});

    private JavaSourceRootDetectionUtil() {
    }

    @NotNull
    public static Collection<JavaModuleSourceRoot> suggestRoots(@NotNull File file) {
        if (file == null) {
            JavaSourceRootDetectionUtil.a(0);
        }
        List list2 = ContainerUtil.findAll((Object[])ProjectStructureDetector.EP_NAME.getExtensions(), JavaSourceRootDetector.class);
        RootDetectionProcessor rootDetectionProcessor = new RootDetectionProcessor(file, list2.toArray(new JavaSourceRootDetector[0]));
        Map<ProjectStructureDetector, List<DetectedProjectRoot>> map = rootDetectionProcessor.runDetectors();
        HashMap<File, JavaModuleSourceRoot> hashMap = new HashMap<File, JavaModuleSourceRoot>();
        for (List<DetectedProjectRoot> list3 : map.values()) {
            for (DetectedProjectRoot detectedProjectRoot : list3) {
                if (!(detectedProjectRoot instanceof JavaModuleSourceRoot)) continue;
                JavaModuleSourceRoot javaModuleSourceRoot = (JavaModuleSourceRoot)detectedProjectRoot;
                File file2 = javaModuleSourceRoot.getDirectory();
                JavaModuleSourceRoot javaModuleSourceRoot2 = (JavaModuleSourceRoot)hashMap.remove(file2);
                if (javaModuleSourceRoot2 != null) {
                    hashMap.put(file2, javaModuleSourceRoot2.combineWith(javaModuleSourceRoot));
                    continue;
                }
                hashMap.put(file2, javaModuleSourceRoot);
            }
        }
        Collection<JavaModuleSourceRoot> collection = hashMap.values();
        if (collection == null) {
            JavaSourceRootDetectionUtil.a(1);
        }
        return collection;
    }

    @Nullable
    public static String getPackageName(CharSequence charSequence) {
        Lexer lexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);
        lexer.start(charSequence);
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        JavaSourceRootDetectionUtil.a(lexer);
        IElementType iElementType = lexer.getTokenType();
        if (iElementType != JavaTokenType.PACKAGE_KEYWORD) {
            if (a.contains(iElementType)) {
                return "";
            }
            return null;
        }
        lexer.advance();
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        StringBuilder stringBuilder = new StringBuilder();
        while (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            stringBuilder.append(charSequence, lexer.getTokenStart(), lexer.getTokenEnd());
            lexer.advance();
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
            if (lexer.getTokenType() != JavaTokenType.DOT) break;
            stringBuilder.append('.');
            lexer.advance();
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
        String string = stringBuilder.toString();
        if (string.length() == 0 || StringUtil.endsWithChar((CharSequence)string, (char)'.')) {
            return null;
        }
        return string;
    }

    public static void skipWhiteSpaceAndComments(Lexer lexer) {
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    private static void a(Lexer lexer) {
        while (lexer.getTokenType() == JavaTokenType.AT) {
            lexer.advance();
            JavaSourceRootDetectionUtil.b(lexer);
            JavaSourceRootDetectionUtil.c(lexer);
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
    }

    private static void b(Lexer lexer) {
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            lexer.advance();
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
            while (lexer.getTokenType() == JavaTokenType.DOT) {
                lexer.advance();
                JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
                if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) break;
                lexer.advance();
                JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
            }
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
    }

    private static void c(Lexer lexer) {
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        if (lexer.getTokenType() == JavaTokenType.LPARENTH) {
            lexer.advance();
            int n2 = 1;
            while (n2 > 0) {
                IElementType iElementType = lexer.getTokenType();
                if (iElementType == JavaTokenType.LPARENTH) {
                    ++n2;
                } else if (iElementType == JavaTokenType.RPARENTH) {
                    --n2;
                } else if (iElementType == null) break;
                lexer.advance();
            }
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetectionUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestRoots";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

