/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.util.CommonSourceRootDetectionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.NullableFunction;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaSourceRootDetector
extends ProjectStructureDetector {
    @Override
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File file, @NotNull File[] fileArray, @NotNull File file2, @NotNull List<DetectedProjectRoot> list2) {
        if (file == null) {
            JavaSourceRootDetector.b(0);
        }
        if (fileArray == null) {
            JavaSourceRootDetector.b(1);
        }
        if (file2 == null) {
            JavaSourceRootDetector.b(2);
        }
        if (list2 == null) {
            JavaSourceRootDetector.b(3);
        }
        if (file.getName().equals("node_modules")) {
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                JavaSourceRootDetector.b(4);
            }
            return directoryProcessingResult;
        }
        String string = this.getFileExtension();
        if ("java".equals(string)) {
            for (File file3 : fileArray) {
                if (!file3.isFile() || !"module-info.java".equals(file3.getName())) continue;
                JavaModuleSourceRoot javaModuleSourceRoot = new JavaModuleSourceRoot(file, this.getLanguageName(), true);
                list2.add(javaModuleSourceRoot);
                ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
                if (directoryProcessingResult == null) {
                    JavaSourceRootDetector.b(5);
                }
                return directoryProcessingResult;
            }
        }
        for (File file3 : fileArray) {
            if (!file3.isFile() || !FileUtilRt.extensionEquals((String)file3.getName(), (String)string)) continue;
            Pair<File, String> pair2 = CommonSourceRootDetectionUtil.IO_FILE.suggestRootForFileWithPackageStatement(file3, file2, this.getPackageNameFetcher(), true);
            if (pair2 != null) {
                JavaModuleSourceRoot javaModuleSourceRoot = new JavaModuleSourceRoot((File)pair2.getFirst(), (String)pair2.getSecond(), this.getLanguageName());
                list2.add(javaModuleSourceRoot);
                if (JavaSourceRootDetector.a(list2, javaModuleSourceRoot, 20)) {
                    ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.skipChildrenAndParentsUpTo((File)pair2.getFirst());
                    if (directoryProcessingResult == null) {
                        JavaSourceRootDetector.b(6);
                    }
                    return directoryProcessingResult;
                }
            }
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                JavaSourceRootDetector.b(7);
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            JavaSourceRootDetector.b(8);
        }
        return directoryProcessingResult;
    }

    private static boolean a(List<DetectedProjectRoot> list2, JavaModuleSourceRoot javaModuleSourceRoot, int n2) {
        if (list2.size() < n2) {
            return false;
        }
        List<DetectedProjectRoot> list3 = list2.subList(list2.size() - n2, list2.size());
        for (DetectedProjectRoot detectedProjectRoot : list3) {
            if (!(detectedProjectRoot instanceof JavaModuleSourceRoot)) {
                return false;
            }
            JavaModuleSourceRoot javaModuleSourceRoot2 = (JavaModuleSourceRoot)detectedProjectRoot;
            if (FileUtil.filesEqual((File)javaModuleSourceRoot2.getDirectory(), (File)javaModuleSourceRoot.getDirectory()) && javaModuleSourceRoot2.getPackagePrefix().equals(javaModuleSourceRoot.getPackagePrefix()) && javaModuleSourceRoot2.getRootTypeName().equals(javaModuleSourceRoot.getRootTypeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDetectorId() {
        return "Java";
    }

    @NotNull
    protected abstract String getLanguageName();

    @NotNull
    protected abstract String getFileExtension();

    @NotNull
    protected abstract NullableFunction<CharSequence, String> getPackageNameFetcher();

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

