/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.jarFinder.MavenCentralSourceSearcher;
import com.intellij.jarFinder.SonatypeSourceSearcher;
import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternetAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger b = Logger.getInstance(InternetAttachSourceProvider.class);
    private static final Pattern c = Pattern.compile("[A-Za-z0-9\\.\\-_]+");

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> list2, final @Nullable PsiFile psiFile) {
        Object object2;
        final VirtualFile virtualFile = InternetAttachSourceProvider.getJarByPsiFile(psiFile);
        if (virtualFile == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list3 = Collections.emptyList();
            if (list3 == null) {
                InternetAttachSourceProvider.b(0);
            }
            return list3;
        }
        final String string = virtualFile.getNameWithoutExtension();
        int n2 = string.lastIndexOf(45);
        if (n2 == -1) {
            List<AttachSourcesProvider.AttachSourcesAction> list4 = Collections.emptyList();
            if (list4 == null) {
                InternetAttachSourceProvider.b(1);
            }
            return list4;
        }
        final String string2 = string.substring(n2 + 1);
        final String string3 = string.substring(0, n2);
        if (!c.matcher(string2).matches() || !c.matcher(string3).matches()) {
            List<AttachSourcesProvider.AttachSourcesAction> list5 = Collections.emptyList();
            if (list5 == null) {
                InternetAttachSourceProvider.b(2);
            }
            return list5;
        }
        HashSet hashSet = new HashSet();
        for (LibraryOrderEntry object22 : list2) {
            ContainerUtil.addIfNotNull(hashSet, (Object)object22.getLibrary());
        }
        if (hashSet.isEmpty()) {
            List<AttachSourcesProvider.AttachSourcesAction> list6 = Collections.emptyList();
            if (list6 == null) {
                InternetAttachSourceProvider.b(3);
            }
            return list6;
        }
        String string4 = string + "-sources.jar";
        for (Object object2 : hashSet) {
            for (VirtualFile virtualFile2 : object2.getFiles(OrderRootType.SOURCES)) {
                if (!virtualFile2.getPath().contains(string4) || !InternetAttachSourceProvider.a(virtualFile2)) continue;
                List<AttachSourcesProvider.AttachSourcesAction> list7 = Collections.emptyList();
                if (list7 == null) {
                    InternetAttachSourceProvider.b(4);
                }
                return list7;
            }
        }
        final File file = InternetAttachSourceProvider.getLibrarySourceDir();
        object2 = new File(file, string4);
        if (((File)object2).exists()) {
            Set<1> set = Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction((File)object2, hashSet){
                final /* synthetic */ File val$sourceFile;
                final /* synthetic */ Set val$libraries;
                {
                    this.val$sourceFile = file;
                    this.val$libraries = set;
                }

                public String getName() {
                    return "Attach downloaded source";
                }

                public String getBusyText() {
                    return this.getName();
                }

                public ActionCallback perform(List<LibraryOrderEntry> list2) {
                    InternetAttachSourceProvider.attachSourceJar(this.val$sourceFile, this.val$libraries);
                    return ActionCallback.DONE;
                }
            });
            if (set == null) {
                InternetAttachSourceProvider.b(5);
            }
            return set;
        }
        Set<2> set = Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction((File)object2, string4, hashSet){
            final /* synthetic */ File val$sourceFile;
            final /* synthetic */ String val$sourceFileName;
            final /* synthetic */ Set val$libraries;
            {
                this.val$sourceFile = file2;
                this.val$sourceFileName = string4;
                this.val$libraries = set;
            }

            public String getName() {
                return "Download...";
            }

            public String getBusyText() {
                return "Searching...";
            }

            public ActionCallback perform(List<LibraryOrderEntry> list2) {
                Task.Modal modal = new Task.Modal(psiFile.getProject(), "Searching source...", true){

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            1.a(0);
                        }
                        String string = null;
                        SourceSearcher[] sourceSearcherArray = new SourceSearcher[]{new MavenCentralSourceSearcher(), new SonatypeSourceSearcher()};
                        for (SourceSearcher sourceSearcher : sourceSearcherArray) {
                            try {
                                string = sourceSearcher.findSourceJar(progressIndicator, string3, string2, virtualFile);
                            }
                            catch (SourceSearchException sourceSearchException) {
                                b.warn((Throwable)sourceSearchException);
                                this.a("Downloading failed", sourceSearchException.getMessage(), NotificationType.ERROR);
                                continue;
                            }
                            if (string != null) break;
                        }
                        if (string == null) {
                            this.a("Sources not found", "Sources for '" + string + ".jar' not found", NotificationType.WARNING);
                            return;
                        }
                        if (!file.isDirectory() && !file.mkdirs()) {
                            this.a("Downloading failed", "Failed to create directory to store sources: " + file, NotificationType.ERROR);
                            return;
                        }
                        try {
                            File file = FileUtil.createTempFile((File)file, (String)"download.", (String)".tmp", (boolean)false, (boolean)false);
                            HttpRequests.request((String)string).saveToFile(file, progressIndicator);
                            if (!val$sourceFile.exists() && !file.renameTo(val$sourceFile)) {
                                b.warn("Failed to rename file " + file + " to " + val$sourceFileName);
                            }
                        }
                        catch (IOException iOException) {
                            b.warn((Throwable)iOException);
                            this.a("Downloading failed", "Connection problem. See log for more details.", NotificationType.ERROR);
                        }
                    }

                    public void onSuccess() {
                        InternetAttachSourceProvider.attachSourceJar(val$sourceFile, val$libraries);
                    }

                    private void a(String string, String string2, NotificationType notificationType) {
                        new Notification("Source searcher", string, string2, notificationType).notify(this.getProject());
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/InternetAttachSourceProvider$2$1", "run"));
                    }
                };
                modal.queue();
                return ActionCallback.DONE;
            }
        });
        if (set == null) {
            InternetAttachSourceProvider.b(6);
        }
        return set;
    }

    private static boolean a(VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        return !(virtualFile.getFileSystem() instanceof JarFileSystem) || (virtualFile2 = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile)) != null && VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile2).exists();
    }

    public static void attachSourceJar(@NotNull File file, @NotNull Collection<Library> collection) {
        VirtualFile virtualFile;
        if (file == null) {
            InternetAttachSourceProvider.b(7);
        }
        if (collection == null) {
            InternetAttachSourceProvider.b(8);
        }
        if ((virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)) == null) {
            return;
        }
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile[] virtualFileArray = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(null, new VirtualFile[]{virtualFile2});
        if (virtualFileArray.length == 0) {
            virtualFileArray = new VirtualFile[]{virtualFile2};
        }
        InternetAttachSourceProvider.a(collection, virtualFileArray);
    }

    private static void a(@NotNull Collection<Library> collection, VirtualFile[] virtualFileArray) {
        if (collection == null) {
            InternetAttachSourceProvider.b(9);
        }
        WriteAction.run(() -> {
            if (collection == null) {
                InternetAttachSourceProvider.b(10);
            }
            for (Library library : collection) {
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                HashSet hashSet = ContainerUtil.newHashSet((Object[])modifiableModel.getFiles(OrderRootType.SOURCES));
                for (VirtualFile virtualFile : virtualFileArray) {
                    if (hashSet.contains(virtualFile)) continue;
                    modifiableModel.addRoot(virtualFile, OrderRootType.SOURCES);
                }
                modifiableModel.commit();
            }
        });
    }

    public static File getLibrarySourceDir() {
        String string = System.getProperty("idea.library.source.dir");
        return string != null ? new File(string) : new File(SystemProperties.getUserHome(), ".ideaLibSources");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/InternetAttachSourceProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceJar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/InternetAttachSourceProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "attachSourceJar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doAttachSourceJars";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doAttachSourceJars$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

