/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RepositoryAttachDialog
extends DialogWrapper {
    @NonNls
    private static final String x = "Downloaded.Files.Path";
    @NonNls
    private static final String l = "Downloaded.Files.Path.Enabled";
    @NonNls
    private static final String v = "Repository.Attach.JavaDocs";
    @NonNls
    private static final String q = "Repository.Attach.Sources";
    @NotNull
    private final Mode e;
    private final Project o;
    private JBLabel g;
    private JCheckBox m;
    private JCheckBox p;
    private AsyncProcessIcon y;
    private ComboboxWithBrowseButton n;
    private JPanel c;
    private TextFieldWithBrowseButton j;
    private JBCheckBox u;
    private JBLabel t;
    private JPanel r;
    private JBCheckBox k;
    private JPanel i;
    private JBCheckBox f;
    private final JComboBox s;
    private final Map<String, RepositoryArtifactDescription> h;
    private final List<String> w;
    private final String b;
    private String a;
    private boolean d;

    public RepositoryAttachDialog(@NotNull Project project2, @Nullable String string, @NotNull Mode mode) {
        if (project2 == null) {
            RepositoryAttachDialog.a(0);
        }
        if (mode == null) {
            RepositoryAttachDialog.a(1);
        }
        super(project2, true);
        this.e();
        this.h = ContainerUtil.newTroveMap();
        this.w = ContainerUtil.newArrayList();
        this.e = mode;
        this.setTitle(mode == Mode.DOWNLOAD ? "Download Library from Maven Repository" : "Search Library in Maven Repositories");
        this.o = project2;
        this.y.suspend();
        this.t.setText(XmlStringUtil.wrapInHtml((CharSequence)StringUtil.escapeXml((String)"keyword or class name to search by or exact Maven coordinates, i.e. 'spring', 'Logger' or 'ant:ant-junit:1.6.5'")));
        this.g.setPreferredSize(new Dimension(this.g.getFontMetrics(this.g.getFont()).stringWidth("Showing: 1000"), this.g.getPreferredSize().height));
        this.n.setButtonIcon(AllIcons.Actions.Menu_find);
        this.n.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryAttachDialog.this.d();
            }
        });
        this.s = this.n.getComboBox();
        this.s.setModel(new CollectionComboBoxModel(this.w, null));
        this.s.setEditable(true);
        final JTextField jTextField = (JTextField)this.s.getEditor().getEditorComponent();
        jTextField.setColumns(20);
        if (string != null) {
            jTextField.setText(string);
        }
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (RepositoryAttachDialog.this.y.isDisposed()) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (RepositoryAttachDialog.this.y.isDisposed()) {
                            return;
                        }
                        RepositoryAttachDialog.a(documentEvent, jTextField);
                        RepositoryAttachDialog.this.a(false);
                    });
                    RepositoryAttachDialog.this.a(false);
                });
            }
        });
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = RepositoryAttachDialog.this.s.isPopupVisible();
                if (!(RepositoryAttachDialog.this.d || bl2 && !RepositoryAttachDialog.this.h.isEmpty())) {
                    RepositoryAttachDialog.this.d();
                } else {
                    String string = (String)RepositoryAttachDialog.this.s.getSelectedItem();
                    if (StringUtil.isNotEmpty((String)string)) {
                        ((JTextField)RepositoryAttachDialog.this.s.getEditor().getEditorComponent()).setText(string);
                    }
                }
            }
        });
        VirtualFile virtualFile = !this.o.isDefault() ? this.o.getBaseDir() : null;
        this.b = virtualFile != null ? FileUtil.toSystemDependentName((String)(virtualFile.getPath() + "/lib")) : "";
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.o);
        this.u.setSelected(propertiesComponent.isTrueValue(l));
        this.j.setText(StringUtil.notNullize((String)StringUtil.nullize((String)propertiesComponent.getValue(x)), (String)this.b));
        this.j.setEnabled(this.u.isSelected());
        this.u.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryAttachDialog.this.j.setEnabled(RepositoryAttachDialog.this.u.isSelected());
            }
        });
        this.m.setSelected(propertiesComponent.isTrueValue(v));
        this.p.setSelected(propertiesComponent.isTrueValue(q));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.putUserData(FileChooserDialog.PREFER_LAST_OVER_TO_SELECT, (Object)Boolean.TRUE);
        this.j.addBrowseFolderListener(ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.title", (Object[])new Object[0]), ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.description", (Object[])new Object[0]), null, fileChooserDescriptor);
        this.b();
        this.r.setVisible(mode == Mode.DOWNLOAD);
        this.i.setVisible(mode == Mode.SEARCH);
        this.init();
    }

    private static void a(DocumentEvent documentEvent, JTextField jTextField) {
        String string;
        if (documentEvent.getType() == DocumentEvent.EventType.INSERT && RepositoryAttachDialog.a(string = jTextField.getText())) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                try {
                    Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
                    String string2 = RepositoryAttachDialog.e(document);
                    if (string2 != null) {
                        jTextField.setText(string2);
                    }
                }
                catch (IOException | SAXException exception) {}
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
    }

    public boolean getAttachJavaDoc() {
        return this.m.isSelected();
    }

    public boolean getAttachSources() {
        return this.p.isSelected();
    }

    public boolean getIncludeTransitiveDependencies() {
        return this.e == Mode.DOWNLOAD ? this.k.isSelected() : this.f.isSelected();
    }

    @Nullable
    public String getDirectoryPath() {
        return this.u.isSelected() ? this.j.getText() : null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.s;
    }

    private void a(boolean bl2) {
        Object object;
        boolean bl3;
        boolean bl4;
        String string = this.a;
        JTextComponent jTextComponent = (JTextComponent)this.s.getEditor().getEditorComponent();
        int n2 = jTextComponent.getCaretPosition();
        this.a = jTextComponent.getText();
        if (!bl2 && Comparing.equal((String)this.a, (String)string)) {
            return;
        }
        int n3 = this.w.size();
        this.w.clear();
        this.d = true;
        boolean bl5 = bl4 = this.h.containsKey(this.a) && Comparing.strEqual((String)((String)this.s.getSelectedItem()), (String)this.a, (boolean)false);
        if (bl4) {
            this.w.addAll(this.h.keySet());
            bl3 = false;
        } else {
            object = this.a.split(" ");
            block0: for (String object2 : this.h.keySet()) {
                for (String string2 : object) {
                    if (!StringUtil.containsIgnoreCase((String)object2, (String)string2)) continue block0;
                }
                this.w.add(object2);
            }
            boolean bl6 = bl3 = !this.w.isEmpty();
            if (!bl3) {
                this.w.addAll(this.h.keySet());
            }
            this.s.setSelectedItem(null);
        }
        object = new ArrayList(this.w.size());
        for (String string3 : this.w) {
            ((ArrayList)object).add(new LibItem(string3));
        }
        Collections.sort(object, (libItem, libItem2) -> Comparing.compare((Comparable)libItem, (Comparable)libItem2));
        this.w.clear();
        Iterator<String> iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            LibItem libItem3 = (LibItem)((Object)iterator.next());
            this.w.add(libItem3.coord);
        }
        ((CollectionComboBoxModel)this.s.getModel()).update();
        this.d = false;
        jTextComponent.setText(this.a);
        jTextComponent.setCaretPosition(n2);
        this.b();
        if (bl3) {
            if (n3 < 10 && this.w.size() > n3 && this.s.isPopupVisible()) {
                this.s.setPopupVisible(false);
            }
            if (!this.s.isPopupVisible()) {
                this.s.setPopupVisible(true);
            }
        }
    }

    private boolean d() {
        String string = this.getCoordinateText();
        if (this.y.isRunning() || StringUtil.isEmptyOrSpaces((String)string) || this.h.containsKey(string)) {
            return false;
        }
        this.y.resume();
        JarRepositoryManager.searchArtifacts(this.o, string, collection -> {
            try {
                if (this.y.isDisposed()) {
                    return;
                }
                this.y.suspend();
                int n2 = this.h.size();
                for (Pair pair2 : collection) {
                    RepositoryArtifactDescription repositoryArtifactDescription = (RepositoryArtifactDescription)pair2.first;
                    this.h.put(repositoryArtifactDescription.getGroupId() + ":" + repositoryArtifactDescription.getArtifactId() + ":" + repositoryArtifactDescription.getVersion(), repositoryArtifactDescription);
                }
                this.a(n2 != this.h.size());
            }
            finally {
                this.setOKActionEnabled(true);
            }
        });
        return true;
    }

    private void b() {
        this.g.setText("<html>Found: " + this.h.size() + "<br>Showing: " + this.s.getModel().getSize() + "</html>");
    }

    protected ValidationInfo doValidate() {
        File file;
        if (!this.a()) {
            return new ValidationInfo("Please enter valid coordinate, discover it or select one from the list", (JComponent)this.s);
        }
        if (this.u.isSelected() && (!(file = new File(this.j.getText())).exists() && !file.mkdirs() || !file.isDirectory())) {
            return new ValidationInfo("Please enter valid library files path", (JComponent)this.j.getTextField());
        }
        return super.doValidate();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        return this.c;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.y);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.o);
        propertiesComponent.setValue(l, String.valueOf(this.u.isSelected()));
        String string = this.j.getText();
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            string = this.b;
        }
        propertiesComponent.setValue(x, string, this.b);
        propertiesComponent.setValue(v, String.valueOf(this.m.isSelected()));
        propertiesComponent.setValue(q, String.valueOf(this.p.isSelected()));
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return RepositoryAttachDialog.class.getName() + "-" + (Object)((Object)this.e);
    }

    private boolean a() {
        String string = this.getCoordinateText();
        return string.split(":").length == 3;
    }

    public String getCoordinateText() {
        JTextField jTextField = (JTextField)this.s.getEditor().getEditorComponent();
        return jTextField.getText();
    }

    private void c() {
        this.y = new AsyncProcessIcon("Progress");
    }

    private static boolean a(String string) {
        String string2 = string.trim();
        return string2.startsWith("<dependency>") && string2.endsWith("</dependency>");
    }

    @Nullable
    private static String e(Document document) {
        String string = RepositoryAttachDialog.b(document);
        String string2 = RepositoryAttachDialog.a(document);
        if (string.isEmpty() && string2.isEmpty()) {
            return null;
        }
        String string3 = RepositoryAttachDialog.d(document);
        String string4 = RepositoryAttachDialog.c(document);
        String string5 = string4.isEmpty() ? "" : ":" + string4;
        return string + ":" + string2 + ":" + string3 + string5;
    }

    private static String d(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(2);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("version"));
    }

    private static String a(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(3);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("artifactId"));
    }

    private static String b(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(4);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("groupId"));
    }

    private static String c(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(5);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("classifier"));
    }

    private static String a(@NotNull NodeList nodeList) {
        Node node;
        if (nodeList == null) {
            RepositoryAttachDialog.a(6);
        }
        return (node = nodeList.item(0)) != null ? node.getTextContent() : "";
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarRepository/RepositoryAttachDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifactId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "firstOrEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void e() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JPanel jPanel3;
        this.c();
        this.c = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 15, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.n = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel4.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.y;
        jPanel4.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.g = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("Info");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.t = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Description");
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.r = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        this.j = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.p = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Sources");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.m = jCheckBox = new JCheckBox();
        jCheckBox.setText("JavaDocs");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(4);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.k = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setSelected(true);
        jBCheckBox3.setText("Transitive dependencies");
        jBCheckBox3.setMnemonic('T');
        jBCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBCheckBox3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.u = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Download to:  ");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.i = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.f = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Include transitive dependencies");
        jBCheckBox.setMnemonic('T');
        jBCheckBox.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.c;
    }

    private static final class LibItem
    implements Comparable<LibItem> {
        final String prefix;
        final Version ver;
        final String coord;

        public LibItem(String string) {
            this.coord = string;
            JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = new JpsMavenRepositoryLibraryDescriptor(string);
            this.prefix = jpsMavenRepositoryLibraryDescriptor.getGroupId() + ":" + jpsMavenRepositoryLibraryDescriptor.getArtifactId();
            Version version = null;
            try {
                version = ArtifactRepositoryManager.asVersion((String)jpsMavenRepositoryLibraryDescriptor.getVersion());
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
            this.ver = version;
        }

        @Override
        public int compareTo(@NotNull LibItem libItem) {
            int n2;
            if (libItem == null) {
                LibItem.a(0);
            }
            return (n2 = this.prefix.compareTo(libItem.prefix)) != 0 ? n2 : Comparing.compare((Comparable)libItem.ver, (Comparable)this.ver);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/jarRepository/RepositoryAttachDialog$LibItem", "compareTo"));
        }
    }

    public static enum Mode {
        SEARCH,
        DOWNLOAD;

    }
}

