/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import java.util.Collection;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryWithDescriptionEditor
extends LibraryPropertiesEditorBase<RepositoryLibraryProperties, RepositoryLibraryType> {
    public RepositoryLibraryWithDescriptionEditor(LibraryEditorComponent<RepositoryLibraryProperties> libraryEditorComponent) {
        super(libraryEditorComponent, RepositoryLibraryType.getInstance(), null);
    }

    public void apply() {
    }

    @Override
    protected void edit() {
        RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)this.myEditorComponent.getProperties();
        boolean bl2 = RepositoryLibraryType.getInstance().getDescription(repositoryLibraryProperties).equals(this.myEditorComponent.getLibraryEditor().getName());
        RepositoryLibraryPropertiesModel repositoryLibraryPropertiesModel = new RepositoryLibraryPropertiesModel(repositoryLibraryProperties.getVersion(), RepositoryUtils.libraryHasSources(this.myEditorComponent.getLibraryEditor()), RepositoryUtils.libraryHasJavaDocs(this.myEditorComponent.getLibraryEditor()), repositoryLibraryProperties.isIncludeTransitiveDependencies());
        Project project2 = this.myEditorComponent.getProject();
        assert (project2 != null) : "EditorComponent's project must not be null in order to be used with RepositoryLibraryWithDescriptionEditor";
        RepositoryLibraryPropertiesDialog repositoryLibraryPropertiesDialog = new RepositoryLibraryPropertiesDialog(project2, repositoryLibraryPropertiesModel, RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)repositoryLibraryProperties), true, true);
        if (!repositoryLibraryPropertiesDialog.showAndGet()) {
            return;
        }
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).changeVersion(repositoryLibraryPropertiesModel.getVersion());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setIncludeTransitiveDependencies(repositoryLibraryPropertiesModel.isIncludeTransitiveDependencies());
        if (bl2) {
            this.myEditorComponent.renameLibrary(RepositoryLibraryType.getInstance().getDescription(repositoryLibraryProperties));
        }
        LibraryEditor libraryEditor = this.myEditorComponent.getLibraryEditor();
        String string = RepositoryUtils.getStorageRoot(this.myEditorComponent.getLibraryEditor().getUrls(OrderRootType.CLASSES), project2);
        Collection<OrderRoot> collection = JarRepositoryManager.loadDependenciesModal(project2, repositoryLibraryProperties, repositoryLibraryPropertiesModel.isDownloadSources(), repositoryLibraryPropertiesModel.isDownloadJavaDocs(), string, null);
        libraryEditor.removeAllRoots();
        if (collection != null) {
            libraryEditor.addRoots(collection);
        }
        this.myEditorComponent.updateRootsTree();
        this.updateDescription();
    }
}

