/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.PsiElementsValidityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionValidatorWrapper
implements Validator {
    private final InspectionValidator b;
    private final PsiManager c;
    private final CompilerManager d;
    private final InspectionManager e;
    private final InspectionProjectProfileManager a;
    private final PsiDocumentManager f;
    private static final ThreadLocal<Boolean> g = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public InspectionValidatorWrapper(CompilerManager compilerManager, InspectionManager inspectionManager, InspectionProjectProfileManager inspectionProjectProfileManager, PsiDocumentManager psiDocumentManager, PsiManager psiManager, InspectionValidator inspectionValidator) {
        this.d = compilerManager;
        this.e = inspectionManager;
        this.a = inspectionProjectProfileManager;
        this.f = psiDocumentManager;
        this.c = psiManager;
        this.b = inspectionValidator;
    }

    public static boolean isCompilationThread() {
        return g.get();
    }

    private static List<ProblemDescriptor> a(@NotNull PsiFile psiFile, @NotNull LocalInspectionTool localInspectionTool) {
        if (psiFile == null) {
            InspectionValidatorWrapper.a(0);
        }
        if (localInspectionTool == null) {
            InspectionValidatorWrapper.a(1);
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)psiFile.getProject());
        GlobalInspectionContext globalInspectionContext = inspectionManager.createNewGlobalContext(false);
        return InspectionEngine.runInspectionOnFile((PsiFile)psiFile, (InspectionToolWrapper)new LocalInspectionToolWrapper(localInspectionTool), (GlobalInspectionContext)globalInspectionContext);
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext compileContext) {
        Project project2 = compileContext.getProject();
        if (project2.isDefault() || !ValidationConfiguration.shouldValidate((Compiler)this, compileContext)) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                InspectionValidatorWrapper.a(2);
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        ExcludesConfiguration excludesConfiguration = ValidationConfiguration.getExcludedEntriesConfiguration(project2);
        List list2 = (List)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
            CompileScope compileScope = compileContext.getCompileScope();
            if (!this.b.isAvailableOnScope(compileScope)) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            Processor processor = virtualFile -> {
                PsiFile psiFile;
                if (!virtualFile.isValid()) {
                    return true;
                }
                if (this.d.isExcludedFromCompilation(virtualFile) || excludesConfiguration.isExcluded(virtualFile)) {
                    return true;
                }
                Module module2 = compileContext.getModuleByFile(virtualFile);
                if (module2 != null && (psiFile = this.c.findFile(virtualFile)) != null) {
                    arrayList.add(new MyValidatorProcessingItem(psiFile));
                }
                return true;
            };
            ContainerUtil.process((Iterable)this.b.getFilesToProcess(this.c.getProject(), compileContext), (Processor)processor);
            return arrayList;
        });
        if (list2 == null) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                InspectionValidatorWrapper.a(3);
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = list2.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        if (processingItemArray == null) {
            InspectionValidatorWrapper.a(4);
        }
        return processingItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(CompileContext compileContext, FileProcessingCompiler.ProcessingItem[] processingItemArray) {
        compileContext.getProgressIndicator().setText(this.b.getProgressIndicatorText());
        ArrayList<MyValidatorProcessingItem> arrayList = new ArrayList<MyValidatorProcessingItem>();
        ArrayList<LocalInspectionTool> arrayList2 = new ArrayList<LocalInspectionTool>();
        for (Class clazz : this.b.getInspectionToolClasses(compileContext)) {
            try {
                arrayList2.add((LocalInspectionTool)clazz.newInstance());
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
        for (int i2 = 0; i2 < processingItemArray.length; ++i2) {
            MyValidatorProcessingItem myValidatorProcessingItem = (MyValidatorProcessingItem)processingItemArray[i2];
            compileContext.getProgressIndicator().checkCanceled();
            compileContext.getProgressIndicator().setFraction((double)i2 / (double)processingItemArray.length);
            try {
                g.set(Boolean.TRUE);
                if (!this.a(arrayList2, myValidatorProcessingItem, compileContext)) continue;
                arrayList.add(myValidatorProcessingItem);
                continue;
            }
            finally {
                g.set(Boolean.FALSE);
            }
        }
        return arrayList.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
    }

    private boolean a(List<LocalInspectionTool> list2, MyValidatorProcessingItem myValidatorProcessingItem, CompileContext compileContext) {
        boolean bl2 = false;
        if (!this.b(myValidatorProcessingItem, compileContext, (Computable<Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> this.b.checkAdditionally(myValidatorProcessingItem.getPsiFile())))) {
            bl2 = true;
        }
        if (!this.b(myValidatorProcessingItem, compileContext, (Computable<Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> {
            PsiFile psiFile = myValidatorProcessingItem.getPsiFile();
            if (psiFile instanceof XmlFile) {
                return this.a((XmlFile)psiFile);
            }
            return Collections.emptyMap();
        }))) {
            bl2 = true;
        }
        InspectionProfileImpl inspectionProfileImpl = this.a.getCurrentProfile();
        for (LocalInspectionTool localInspectionTool : list2) {
            if (this.b(myValidatorProcessingItem, compileContext, (Computable<Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> InspectionValidatorWrapper.a(myValidatorProcessingItem, localInspectionTool, (InspectionProfile)inspectionProfileImpl)))) continue;
            bl2 = true;
        }
        return !bl2;
    }

    private boolean b(MyValidatorProcessingItem myValidatorProcessingItem, CompileContext compileContext, Computable<Map<ProblemDescriptor, HighlightDisplayLevel>> computable) {
        return (Boolean)DumbService.getInstance((Project)compileContext.getProject()).runReadActionInSmartMode(() -> {
            PsiFile psiFile = myValidatorProcessingItem.getPsiFile();
            if (psiFile == null) {
                return false;
            }
            Document document = this.f.getCachedDocument(psiFile);
            if (document != null && this.f.isUncommited(document)) {
                String string = psiFile.getViewProvider().getVirtualFile().getUrl();
                compileContext.addMessage(CompilerMessageCategory.WARNING, CompilerBundle.message((String)"warning.text.file.has.been.changed", (Object[])new Object[0]), string, -1, -1);
                return false;
            }
            if (this.a(compileContext, (Map)computable.compute())) {
                return false;
            }
            return true;
        });
    }

    private boolean a(CompileContext compileContext, Map<ProblemDescriptor, HighlightDisplayLevel> map) {
        if (map.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        for (Map.Entry<ProblemDescriptor, HighlightDisplayLevel> entry : map.entrySet()) {
            VirtualFile virtualFile;
            ProblemDescriptor problemDescriptor = entry.getKey();
            PsiElement psiElement = problemDescriptor.getPsiElement();
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            CompilerMessageCategory compilerMessageCategory = this.b.getCategoryByHighlightDisplayLevel(entry.getValue(), virtualFile, compileContext);
            Document document = this.f.getDocument(psiFile);
            int n2 = problemDescriptor.getStartElement().getTextOffset();
            assert (document != null);
            int n3 = document.getLineNumber(n2);
            int n4 = n2 - document.getLineStartOffset(n3);
            compileContext.addMessage(compilerMessageCategory, problemDescriptor.getDescriptionTemplate(), virtualFile.getUrl(), n3 + 1, n4 + 1);
            if (CompilerMessageCategory.ERROR != compilerMessageCategory) continue;
            bl2 = true;
        }
        return bl2;
    }

    private static Map<ProblemDescriptor, HighlightDisplayLevel> a(PsiFile psiFile, LocalInspectionTool localInspectionTool, HighlightDisplayLevel highlightDisplayLevel) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (ProblemDescriptor problemDescriptor : InspectionValidatorWrapper.a(psiFile, localInspectionTool)) {
            ProblemHighlightType problemHighlightType = problemDescriptor.getHighlightType();
            HighlightDisplayLevel highlightDisplayLevel2 = problemHighlightType == ProblemHighlightType.WEAK_WARNING ? HighlightDisplayLevel.WEAK_WARNING : (problemHighlightType == ProblemHighlightType.INFORMATION ? HighlightDisplayLevel.DO_NOT_SHOW : highlightDisplayLevel);
            linkedHashMap.put(problemDescriptor, highlightDisplayLevel2);
        }
        return linkedHashMap;
    }

    private static HighlightDisplayLevel a(LocalInspectionTool localInspectionTool, InspectionProfile inspectionProfile, PsiElement psiElement) {
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)localInspectionTool.getShortName());
        return inspectionProfile.isToolEnabled(highlightDisplayKey, psiElement) ? inspectionProfile.getErrorLevel(highlightDisplayKey, psiElement) : HighlightDisplayLevel.DO_NOT_SHOW;
    }

    private Map<ProblemDescriptor, HighlightDisplayLevel> a(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            InspectionValidatorWrapper.a(5);
        }
        AnnotationHolderImpl annotationHolderImpl = new AnnotationHolderImpl(new AnnotationSession((PsiFile)xmlFile));
        List list2 = ExternalLanguageAnnotators.allForFile((Language)StdLanguages.XML, (PsiFile)xmlFile);
        for (Object object : list2) {
            InspectionValidatorWrapper.a(xmlFile, annotationHolderImpl, object);
        }
        if (!annotationHolderImpl.hasAnnotations()) {
            return Collections.emptyMap();
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Annotation annotation : annotationHolderImpl) {
            PsiElement psiElement;
            HighlightInfo highlightInfo = HighlightInfo.fromAnnotation((Annotation)annotation);
            if (highlightInfo.getSeverity() == HighlightSeverity.INFORMATION) continue;
            PsiElement psiElement2 = xmlFile.findElementAt(highlightInfo.startOffset);
            PsiElement psiElement3 = psiElement = highlightInfo.startOffset == highlightInfo.endOffset ? psiElement2 : xmlFile.findElementAt(highlightInfo.endOffset - 1);
            if (psiElement2 == null || psiElement == null) continue;
            ProblemDescriptor problemDescriptor = this.e.createProblemDescriptor(psiElement2, psiElement, highlightInfo.getDescription(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
            HighlightDisplayLevel highlightDisplayLevel = highlightInfo.getSeverity() == HighlightSeverity.ERROR ? HighlightDisplayLevel.ERROR : HighlightDisplayLevel.WARNING;
            linkedHashMap.put(problemDescriptor, highlightDisplayLevel);
        }
        return linkedHashMap;
    }

    private static <X, Y> void a(@NotNull XmlFile xmlFile, AnnotationHolderImpl annotationHolderImpl, ExternalAnnotator<X, Y> externalAnnotator) {
        Object object;
        Object object2;
        if (xmlFile == null) {
            InspectionValidatorWrapper.a(6);
        }
        if ((object2 = externalAnnotator.collectInformation((PsiFile)xmlFile)) != null && (object = externalAnnotator.doAnnotate(object2)) != null) {
            externalAnnotator.apply((PsiFile)xmlFile, object, (AnnotationHolder)annotationHolderImpl);
        }
    }

    @NotNull
    public String getDescription() {
        String string = this.b.getDescription();
        if (string == null) {
            InspectionValidatorWrapper.a(7);
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope compileScope) {
        return true;
    }

    public ValidityState createValidityState(DataInput dataInput) throws IOException {
        return PsiElementsValidityState.load(dataInput);
    }

    private static /* synthetic */ Map a(MyValidatorProcessingItem myValidatorProcessingItem, LocalInspectionTool localInspectionTool, InspectionProfile inspectionProfile) {
        PsiFile psiFile = myValidatorProcessingItem.getPsiFile();
        if (psiFile != null && InspectionValidatorWrapper.a(localInspectionTool, inspectionProfile, (PsiElement)psiFile) != HighlightDisplayLevel.DO_NOT_SHOW) {
            return InspectionValidatorWrapper.a(psiFile, localInspectionTool, InspectionValidatorWrapper.a(localInspectionTool, inspectionProfile, (PsiElement)psiFile));
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTool";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runXmlFileSchemaValidation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processAnnotator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyValidatorProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final VirtualFile c;
        private final PsiManager b;
        private PsiElementsValidityState a;

        public MyValidatorProcessingItem(PsiFile psiFile) {
            if (psiFile == null) {
                MyValidatorProcessingItem.a(0);
            }
            this.c = psiFile.getVirtualFile();
            this.b = psiFile.getManager();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.c;
            if (virtualFile == null) {
                MyValidatorProcessingItem.a(1);
            }
            return virtualFile;
        }

        @Nullable
        public ValidityState getValidityState() {
            if (this.a == null) {
                this.a = this.a();
            }
            return this.a;
        }

        private PsiElementsValidityState a() {
            PsiElementsValidityState psiElementsValidityState = new PsiElementsValidityState();
            PsiFile psiFile = this.getPsiFile();
            if (psiFile != null) {
                for (PsiElement psiElement : InspectionValidatorWrapper.this.b.getDependencies(psiFile)) {
                    psiElementsValidityState.addDependency(psiElement);
                }
            }
            return psiElementsValidityState;
        }

        @Nullable
        public PsiFile getPsiFile() {
            return this.c.isValid() ? this.b.findFile(this.c) : null;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

