/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentUtilImpl
extends DeploymentUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.openapi.deployment.MakeUtilImpl");

    public void copyFile(@NotNull File file, @NotNull File file2, @NotNull CompileContext compileContext, @Nullable Set<String> set, @Nullable FileFilter fileFilter) throws IOException {
        if (file == null) {
            DeploymentUtilImpl.a(0);
        }
        if (file2 == null) {
            DeploymentUtilImpl.a(1);
        }
        if (compileContext == null) {
            DeploymentUtilImpl.a(2);
        }
        if (fileFilter != null && !fileFilter.accept(file)) {
            if (a.isDebugEnabled()) {
                a.debug("Skipping " + file.getAbsolutePath() + ": it wasn't accepted by filter " + fileFilter);
            }
            return;
        }
        DeploymentUtilImpl.a(file);
        DeploymentUtilImpl.a(file2);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            file2.mkdirs();
            for (File file3 : fileArray) {
                this.copyFile(file3, new File(file2, file3.getName()), compileContext, set, fileFilter);
            }
            return;
        }
        if (file2.isDirectory()) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"message.text.destination.is.directory", (Object[])new Object[]{DeploymentUtilImpl.a(file, file2)}), null, -1, -1);
            return;
        }
        if (FileUtil.filesEqual((File)file, (File)file2) || set != null && !set.add(file2.getPath())) {
            if (a.isDebugEnabled()) {
                a.debug("Skipping " + file.getAbsolutePath() + ": " + file2.getAbsolutePath() + " is already written");
            }
            return;
        }
        if (!FileUtil.isFilePathAcceptable((File)file2, (FileFilter)fileFilter)) {
            if (a.isDebugEnabled()) {
                a.debug("Skipping " + file.getAbsolutePath() + ": " + file2.getAbsolutePath() + " wasn't accepted by filter " + fileFilter);
            }
            return;
        }
        compileContext.getProgressIndicator().setText("Copying files");
        compileContext.getProgressIndicator().setText2(file.getPath());
        try {
            File file4;
            if (a.isDebugEnabled()) {
                a.debug("Copy file '" + file + "' to '" + file2 + "'");
            }
            if (file2.exists() && !SystemInfo.isFileSystemCaseSensitive && !(file4 = file2.getCanonicalFile()).getAbsolutePath().equals(file2.getAbsolutePath())) {
                FileUtil.delete((File)file2);
            }
            FileUtil.copy((File)file, (File)file2);
        }
        catch (IOException iOException) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, DeploymentUtilImpl.a(file, file2) + ": " + iOException.getLocalizedMessage(), null, -1, -1);
        }
    }

    private static void a(File file) {
        String string;
        File file2;
        String string2 = file.getPath();
        int n2 = string2.indexOf("..");
        if (n2 != -1 && (file2 = new File(string = string2.substring(0, n2 - 1))).exists() && !file2.isDirectory()) {
            a.error("Incorrect file path: '" + string2 + '\'');
        }
    }

    private static String a(File file, File file2) {
        return CompilerBundle.message((String)"message.text.error.copying.file.to.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)file.getPath()), FileUtil.toSystemDependentName((String)file2.getPath())});
    }

    public void reportDeploymentDescriptorDoesNotExists(ConfigFile configFile, CompileContext compileContext, Module module2) {
        String string = ModuleType.get((Module)module2).getName() + " '" + module2.getName() + '\'';
        String string2 = VfsUtil.urlToPath((String)configFile.getUrl());
        String string3 = CompilerBundle.message((String)"message.text.compiling.item.deployment.descriptor.could.not.be.found", (Object[])new Object[]{string, string2});
        compileContext.addMessage(CompilerMessageCategory.ERROR, string3, null, -1, -1);
    }

    public void checkConfigFile(ConfigFile configFile, CompileContext compileContext, Module module2) {
        if (new File(VfsUtil.urlToPath((String)configFile.getUrl())).exists()) {
            String string = this.getConfigFileErrorMessage(configFile);
            if (string != null) {
                String string2 = ModuleType.get((Module)module2).getName() + " '" + module2.getName() + '\'';
                compileContext.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"message.text.compiling.module.message", (Object[])new Object[]{string2, string}), configFile.getUrl(), -1, -1);
            }
        } else {
            DeploymentUtil.getInstance().reportDeploymentDescriptorDoesNotExists(configFile, compileContext, module2);
        }
    }

    @Nullable
    public String getConfigFileErrorMessage(ConfigFile configFile) {
        XmlDocument xmlDocument;
        if (configFile.getVirtualFile() == null) {
            String string = FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configFile.getUrl()));
            return CompilerBundle.message((String)"mesage.text.deployment.descriptor.file.not.exist", (Object[])new Object[]{string});
        }
        PsiFile psiFile = configFile.getPsiFile();
        if (psiFile == null || !psiFile.isValid()) {
            return CompilerBundle.message((String)"message.text.deployment.description.invalid.file", (Object[])new Object[0]);
        }
        if (psiFile instanceof XmlFile && ((xmlDocument = ((XmlFile)psiFile).getDocument()) == null || xmlDocument.getRootTag() == null)) {
            return CompilerBundle.message((String)"message.text.xml.file.invalid", (Object[])new Object[]{FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configFile.getUrl()))});
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fromFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/deployment/DeploymentUtilImpl";
        objectArray[2] = "copyFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

