/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.module.Module;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemActionUtil {
    public static void executeAction(String string, InputEvent inputEvent) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction(string);
        if (anAction != null) {
            Presentation presentation = new Presentation();
            AnActionEvent anActionEvent = new AnActionEvent(inputEvent, DataManager.getInstance().getDataContext(inputEvent.getComponent()), "", presentation, actionManager, 0);
            anAction.update(anActionEvent);
            if (presentation.isEnabled()) {
                anAction.actionPerformed(anActionEvent);
            }
        }
    }

    @Nullable
    public static Module getModule(DataContext dataContext) {
        Module module2 = (Module)LangDataKeys.MODULE.getData(dataContext);
        return module2 != null ? module2 : (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
    }

    public static <E> void setElements(ElementsChooser<E> elementsChooser, Collection<E> collection, Collection<E> collection2, Comparator<E> comparator) {
        List list2 = elementsChooser.getSelectedElements();
        elementsChooser.clear();
        TreeSet<E> treeSet = new TreeSet<E>(comparator);
        treeSet.addAll(collection);
        for (Object e2 : treeSet) {
            elementsChooser.addElement(e2, collection2.contains(e2));
        }
        elementsChooser.selectElements((Collection)list2);
    }

    public static void installCheckboxRenderer(final SimpleTree simpleTree, final CheckboxHandler checkboxHandler) {
        final JCheckBox jCheckBox = new JCheckBox();
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jCheckBox, "West");
        final TreeCellRenderer treeCellRenderer = simpleTree.getCellRenderer();
        simpleTree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
                Component component = treeCellRenderer.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (!checkboxHandler.isVisible(object2)) {
                    return component;
                }
                Color color = bl2 ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground();
                Color color2 = bl2 ? UIUtil.getTreeSelectionBackground((boolean)bl5) : UIUtil.getTreeTextBackground();
                jPanel.add(component, "Center");
                jPanel.setBackground(color2);
                jPanel.setForeground(color);
                CheckBoxState checkBoxState = checkboxHandler.getState(object2);
                jCheckBox.setSelected(checkBoxState != CheckBoxState.UNCHECKED);
                jCheckBox.setEnabled(checkBoxState != CheckBoxState.PARTIAL);
                jCheckBox.setBackground(color2);
                jCheckBox.setForeground(color);
                return jPanel;
            }
        });
        simpleTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n2 = simpleTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n2 >= 0) {
                    TreePath treePath = simpleTree.getPathForRow(n2);
                    if (!ExternalSystemActionUtil.a(treePath, checkboxHandler)) {
                        return;
                    }
                    Rectangle rectangle = jCheckBox.getBounds();
                    rectangle.setLocation(simpleTree.getRowBounds(n2).getLocation());
                    if (rectangle.contains(mouseEvent.getPoint())) {
                        checkboxHandler.toggle(treePath, mouseEvent);
                        mouseEvent.consume();
                        simpleTree.setSelectionRow(n2);
                    }
                }
            }
        });
        simpleTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                TreePath[] treePathArray;
                if (keyEvent.getKeyCode() == 32 && (treePathArray = simpleTree.getSelectionPaths()) != null) {
                    for (TreePath treePath : treePathArray) {
                        if (!ExternalSystemActionUtil.a(treePath, checkboxHandler)) continue;
                        checkboxHandler.toggle(treePath, keyEvent);
                    }
                    keyEvent.consume();
                }
            }
        });
    }

    private static boolean a(TreePath treePath, CheckboxHandler checkboxHandler) {
        Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        return checkboxHandler.isVisible(object);
    }

    @NotNull
    public static ExternalTaskExecutionInfo buildTaskInfo(@NotNull TaskData taskData) {
        if (taskData == null) {
            ExternalSystemActionUtil.a(0);
        }
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        externalSystemTaskExecutionSettings.setExternalProjectPath(taskData.getLinkedExternalProjectPath());
        externalSystemTaskExecutionSettings.setTaskNames(Collections.singletonList(taskData.getName()));
        externalSystemTaskExecutionSettings.setTaskDescriptions(Collections.singletonList(taskData.getDescription()));
        externalSystemTaskExecutionSettings.setExternalSystemIdString(taskData.getOwner().toString());
        ExternalTaskExecutionInfo externalTaskExecutionInfo = new ExternalTaskExecutionInfo(externalSystemTaskExecutionSettings, DefaultRunExecutor.EXECUTOR_ID);
        if (externalTaskExecutionInfo == null) {
            ExternalSystemActionUtil.a(1);
        }
        return externalTaskExecutionInfo;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/ExternalSystemActionUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemActionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTaskInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTaskInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CheckBoxState {
        CHECKED,
        UNCHECKED,
        PARTIAL;

    }

    public static interface CheckboxHandler {
        public void toggle(TreePath var1, InputEvent var2);

        public boolean isVisible(Object var1);

        public CheckBoxState getState(Object var1);
    }
}

