/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public abstract class ExternalSystemToggleAction
extends ToggleAction
implements DumbAware {
    public void update(AnActionEvent anActionEvent) {
        super.update(anActionEvent);
        Presentation presentation = anActionEvent.getPresentation();
        boolean bl2 = this.isVisible(anActionEvent);
        presentation.setVisible(bl2);
        presentation.setEnabled(bl2 && this.isEnabled(anActionEvent));
    }

    protected boolean isEnabled(AnActionEvent anActionEvent) {
        return this.hasProject(anActionEvent);
    }

    protected boolean isVisible(AnActionEvent anActionEvent) {
        return true;
    }

    public boolean isSelected(AnActionEvent anActionEvent) {
        if (!this.isEnabled(anActionEvent)) {
            return false;
        }
        return this.doIsSelected(anActionEvent);
    }

    protected abstract boolean doIsSelected(AnActionEvent var1);

    protected Project getProject(AnActionEvent anActionEvent) {
        return anActionEvent.getProject();
    }

    protected boolean hasProject(AnActionEvent anActionEvent) {
        return this.getProject(anActionEvent) != null;
    }

    protected ProjectSystemId getSystemId(AnActionEvent anActionEvent) {
        return (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(anActionEvent.getDataContext());
    }

    protected void setText(String string) {
        this.getTemplatePresentation().setText(string);
    }

    protected void setDescription(String string) {
        this.getTemplatePresentation().setDescription(string);
    }

    protected void setText(AnActionEvent anActionEvent, String string) {
        anActionEvent.getPresentation().setText(string);
    }

    protected void setDescription(AnActionEvent anActionEvent, String string) {
        anActionEvent.getPresentation().setDescription(string);
    }
}

