/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class RefreshAllExternalProjectsAction
extends AnAction
implements AnAction.TransparentUpdate {
    public RefreshAllExternalProjectsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.all.projects.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.all.projects.description", (Object[])new Object[]{"external"}));
    }

    public void update(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            anActionEvent.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> list2 = RefreshAllExternalProjectsAction.a(anActionEvent);
        if (list2.isEmpty()) {
            anActionEvent.getPresentation().setEnabled(false);
            return;
        }
        String string = StringUtil.join(list2, projectSystemId -> projectSystemId.getReadableName(), (String)",");
        anActionEvent.getPresentation().setText(ExternalSystemBundle.message((String)"action.refresh.all.projects.text", (Object[])new Object[]{string}));
        anActionEvent.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.all.projects.description", (Object[])new Object[]{string}));
        ExternalSystemProcessingManager externalSystemProcessingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        anActionEvent.getPresentation().setEnabled(!externalSystemProcessingManager.hasTaskOfTypeInProgress(ExternalSystemTaskType.RESOLVE_PROJECT, project2));
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            anActionEvent.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> list2 = RefreshAllExternalProjectsAction.a(anActionEvent);
        if (list2.isEmpty()) {
            anActionEvent.getPresentation().setEnabled(false);
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (ProjectSystemId projectSystemId : list2) {
            ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, projectSystemId).forceWhenUptodate(true).use(ProgressExecutionMode.IN_BACKGROUND_ASYNC));
        }
    }

    private static List<ProjectSystemId> a(AnActionEvent anActionEvent) {
        ArrayList arrayList = ContainerUtil.newArrayList();
        ProjectSystemId projectSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(anActionEvent.getDataContext());
        if (projectSystemId != null) {
            arrayList.add(projectSystemId);
        } else {
            for (ExternalSystemManager externalSystemManager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                arrayList.add(externalSystemManager.getSystemId());
            }
        }
        return arrayList;
    }
}

