/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStorage;
import com.intellij.openapi.externalSystem.configurationStore.PersistentMapManagerKt;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J$\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/FileSystemExternalSystemStorage;", "Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStorage;", "dirName", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "dir", "Ljava/nio/file/Path;", "getDir", "()Ljava/nio/file/Path;", "<set-?>", "", "hasSomeData", "getHasSomeData", "()Z", "setHasSomeData", "(Z)V", "isDirty", "forceSave", "", "nameToPath", "name", "read", "Lorg/jdom/Element;", "remove", "rename", "oldName", "newName", "write", "element", "filter", "Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;", "intellij.platform.externalSystem.impl"})
public abstract class FileSystemExternalSystemStorage
implements ExternalSystemStorage {
    private final boolean a = false;
    @NotNull
    private final Path c;
    private boolean b;

    @Override
    public boolean isDirty() {
        return this.a;
    }

    @NotNull
    protected final Path getDir() {
        return this.c;
    }

    public final boolean getHasSomeData() {
        return this.b;
    }

    private final void a(boolean bl2) {
        this.b = bl2;
    }

    @NotNull
    protected Path nameToPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
        Path path = this.c.resolve(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir.resolve(name)");
        return path;
    }

    @Override
    public void forceSave() {
    }

    @Override
    public void remove(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
        if (!this.b) {
            return;
        }
        PathKt.delete((Path)this.nameToPath(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element read(@NotNull String string) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
        if (!this.b) {
            return null;
        }
        InputStream inputStream2 = PathKt.inputStreamIfExists((Path)this.nameToPath(string));
        if (inputStream2 != null) {
            Closeable closeable = inputStream2;
            Throwable throwable = null;
            try {
                InputStream inputStream3 = (InputStream)closeable;
                inputStream3 = JdomKt.loadElement((InputStream)inputStream3);
                inputStream = inputStream3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    public void write(@NotNull String string, @Nullable Element element, @Nullable JDOMUtil.ElementOutputFilter elementOutputFilter) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
        if (element == null) {
            this.remove(string);
            return;
        }
        this.b = true;
        JdomKt.write$default((Parent)((Parent)element), (Path)this.nameToPath(string), null, (JDOMUtil.ElementOutputFilter)elementOutputFilter, (int)2, null);
    }

    @Override
    public void rename(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"oldName");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"newName");
        if (!this.b) {
            return;
        }
        Path path = this.nameToPath(string);
        if (PathKt.exists((Path)path)) {
            PathKt.move((Path)path, (Path)this.nameToPath(string2));
        }
    }

    public FileSystemExternalSystemStorage(@NotNull String string, @NotNull Project project2) {
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"dirName");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Path path = ExternalProjectsDataStorage.getProjectConfigurationDir(project2).resolve(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ExternalProjectsDataStor\u2026project).resolve(dirName)");
        this.c = path;
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)this.c);
        if (basicFileAttributes == null) {
            bl2 = false;
        } else if (basicFileAttributes.isRegularFile()) {
            Path path2 = this.c.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dir.parent");
            PathKt.deleteChildrenStartingWith((Path)path2, (String)((Object)this.c.getFileName()).toString());
            bl2 = false;
        } else {
            PersistentMapManagerKt.access$getLOG$p().assertTrue(basicFileAttributes.isDirectory());
            bl2 = true;
        }
        this.b = bl2;
    }
}

