/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.execution.rmi.RemoteServer;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolverImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManagerImpl;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemFacadeImpl<S extends ExternalSystemExecutionSettings>
extends RemoteServer
implements RemoteExternalSystemFacade<S> {
    private final ConcurrentMap<Class<?>, RemoteExternalSystemService<S>> e;
    private final AtomicReference<S> b;
    private final AtomicReference<ExternalSystemTaskNotificationListener> c;
    @NotNull
    private final RemoteExternalSystemProjectResolverImpl<S> d;
    @NotNull
    private final RemoteExternalSystemTaskManagerImpl<S> a;

    public AbstractExternalSystemFacadeImpl(@NotNull Class<ExternalSystemProjectResolver<S>> clazz, @NotNull Class<ExternalSystemTaskManager<S>> clazz2) throws IllegalAccessException, InstantiationException {
        if (clazz == null) {
            AbstractExternalSystemFacadeImpl.a(0);
        }
        if (clazz2 == null) {
            AbstractExternalSystemFacadeImpl.a(1);
        }
        this.e = ContainerUtil.newConcurrentMap();
        this.b = new AtomicReference();
        this.c = new AtomicReference<1>(new ExternalSystemTaskNotificationListenerAdapter(){});
        this.d = new RemoteExternalSystemProjectResolverImpl<S>(clazz.newInstance());
        this.a = new RemoteExternalSystemTaskManagerImpl<S>(clazz2.newInstance());
    }

    protected void init() throws RemoteException {
        this.applyProgressManager(RemoteExternalSystemProgressNotificationManager.NULL_OBJECT);
    }

    @Nullable
    protected S getSettings() {
        return (S)((ExternalSystemExecutionSettings)this.b.get());
    }

    @NotNull
    protected ExternalSystemTaskNotificationListener getNotificationListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.c.get();
        if (externalSystemTaskNotificationListener == null) {
            AbstractExternalSystemFacadeImpl.a(2);
        }
        return externalSystemTaskNotificationListener;
    }

    @Override
    @NotNull
    public RemoteExternalSystemProjectResolver<S> getResolver() throws IllegalStateException {
        RemoteExternalSystemProjectResolver remoteExternalSystemProjectResolver;
        try {
            remoteExternalSystemProjectResolver = this.a(RemoteExternalSystemProjectResolver.class, this.d);
        }
        catch (Exception exception) {
            throw new IllegalStateException(String.format("Can't create '%s' service", RemoteExternalSystemProjectResolverImpl.class.getName()), exception);
        }
        if (remoteExternalSystemProjectResolver == null) {
            AbstractExternalSystemFacadeImpl.a(3);
        }
        return remoteExternalSystemProjectResolver;
    }

    @Override
    @NotNull
    public RemoteExternalSystemTaskManager<S> getTaskManager() {
        RemoteExternalSystemTaskManager remoteExternalSystemTaskManager;
        try {
            remoteExternalSystemTaskManager = this.a(RemoteExternalSystemTaskManager.class, this.a);
        }
        catch (Exception exception) {
            throw new IllegalStateException(String.format("Can't create '%s' service", ExternalSystemTaskManager.class.getName()), exception);
        }
        if (remoteExternalSystemTaskManager == null) {
            AbstractExternalSystemFacadeImpl.a(4);
        }
        return remoteExternalSystemTaskManager;
    }

    private <I extends RemoteExternalSystemService<S>, C extends I> I a(@NotNull Class<I> clazz, @NotNull C c2) throws ClassNotFoundException, IllegalAccessException, InstantiationException, RemoteException {
        Object v2;
        if (clazz == null) {
            AbstractExternalSystemFacadeImpl.a(5);
        }
        if (c2 == null) {
            AbstractExternalSystemFacadeImpl.a(6);
        }
        if ((v2 = this.e.get(clazz)) != null) {
            return (I)((RemoteExternalSystemService)v2);
        }
        S s2 = this.getSettings();
        if (s2 != null) {
            c2.setNotificationListener(this.getNotificationListener());
            c2.setSettings(s2);
        }
        c2.setNotificationListener(this.getNotificationListener());
        try {
            I i2 = this.createService(clazz, c2);
            RemoteExternalSystemService<S> remoteExternalSystemService = this.e.putIfAbsent(clazz, (RemoteExternalSystemService<S>)i2);
            return (I)(remoteExternalSystemService == null ? i2 : remoteExternalSystemService);
        }
        catch (RemoteException remoteException) {
            Object v3 = this.e.get(clazz);
            if (v3 != null) {
                return (I)((RemoteExternalSystemService)v3);
            }
            throw new IllegalStateException(String.format("Can't prepare remote service for interface '%s', implementation '%s'", clazz, c2), remoteException);
        }
    }

    protected abstract <I extends RemoteExternalSystemService<S>, C extends I> I createService(@NotNull Class<I> var1, @NotNull C var2) throws ClassNotFoundException, IllegalAccessException, InstantiationException, RemoteException;

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId externalSystemTaskId) throws RemoteException {
        if (externalSystemTaskId == null) {
            AbstractExternalSystemFacadeImpl.a(7);
        }
        for (RemoteExternalSystemService remoteExternalSystemService : this.e.values()) {
            if (!remoteExternalSystemService.isTaskInProgress(externalSystemTaskId)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() throws RemoteException {
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map = null;
        for (RemoteExternalSystemService remoteExternalSystemService : this.e.values()) {
            Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map2 = remoteExternalSystemService.getTasksInProgress();
            if (map2.isEmpty()) continue;
            if (map == null) {
                map = new HashMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>>();
            }
            for (Map.Entry<ExternalSystemTaskType, Set<ExternalSystemTaskId>> entry : map2.entrySet()) {
                Set<ExternalSystemTaskId> set = map.get(entry.getKey());
                if (set == null) {
                    set = new HashSet<ExternalSystemTaskId>();
                    map.put(entry.getKey(), set);
                }
                set.addAll((Collection<ExternalSystemTaskId>)entry.getValue());
            }
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map3 = map;
        if (map3 == null) {
            AbstractExternalSystemFacadeImpl.a(8);
        }
        return map3;
    }

    @Override
    public void applySettings(@NotNull S s2) throws RemoteException {
        if (s2 == null) {
            AbstractExternalSystemFacadeImpl.a(9);
        }
        this.b.set(s2);
        ArrayList arrayList = ContainerUtilRt.newArrayList(this.e.values());
        for (RemoteExternalSystemService remoteExternalSystemService : arrayList) {
            remoteExternalSystemService.setSettings(s2);
        }
    }

    @Override
    public void applyProgressManager(@NotNull RemoteExternalSystemProgressNotificationManager remoteExternalSystemProgressNotificationManager) throws RemoteException {
        if (remoteExternalSystemProgressNotificationManager == null) {
            AbstractExternalSystemFacadeImpl.a(10);
        }
        SwallowingNotificationListener swallowingNotificationListener = new SwallowingNotificationListener(remoteExternalSystemProgressNotificationManager);
        this.c.set(swallowingNotificationListener);
        this.d.setNotificationListener(swallowingNotificationListener);
        this.a.setNotificationListener(swallowingNotificationListener);
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId externalSystemTaskId) throws RemoteException {
        if (externalSystemTaskId == null) {
            AbstractExternalSystemFacadeImpl.a(11);
        }
        if (externalSystemTaskId.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            return this.d.cancelTask(externalSystemTaskId);
        }
        return this.a.cancelTask(externalSystemTaskId);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildManagerClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressManager";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksInProgress";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTaskInProgress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applySettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyProgressManager";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SwallowingNotificationListener
    implements ExternalSystemTaskNotificationListener {
        @NotNull
        private final RemoteExternalSystemProgressNotificationManager a;

        SwallowingNotificationListener(@NotNull RemoteExternalSystemProgressNotificationManager remoteExternalSystemProgressNotificationManager) {
            if (remoteExternalSystemProgressNotificationManager == null) {
                SwallowingNotificationListener.a(0);
            }
            this.a = remoteExternalSystemProgressNotificationManager;
        }

        public void onQueued(@NotNull ExternalSystemTaskId externalSystemTaskId, String string) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(1);
            }
        }

        public void onStart(@NotNull ExternalSystemTaskId externalSystemTaskId, String string) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(2);
            }
        }

        public void onStart(@NotNull ExternalSystemTaskId externalSystemTaskId) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(3);
            }
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent) {
            if (externalSystemTaskNotificationEvent == null) {
                SwallowingNotificationListener.a(4);
            }
            try {
                this.a.onStatusChange(externalSystemTaskNotificationEvent);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String string, boolean bl2) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(5);
            }
            if (string == null) {
                SwallowingNotificationListener.a(6);
            }
            try {
                this.a.onTaskOutput(externalSystemTaskId, string, bl2);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onEnd(@NotNull ExternalSystemTaskId externalSystemTaskId) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(7);
            }
        }

        public void onSuccess(@NotNull ExternalSystemTaskId externalSystemTaskId) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(8);
            }
        }

        public void onFailure(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull Exception exception) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(9);
            }
            if (exception == null) {
                SwallowingNotificationListener.a(10);
            }
        }

        public void beforeCancel(@NotNull ExternalSystemTaskId externalSystemTaskId) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(11);
            }
        }

        public void onCancel(@NotNull ExternalSystemTaskId externalSystemTaskId) {
            if (externalSystemTaskId == null) {
                SwallowingNotificationListener.a(12);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onQueued";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStatusChange";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTaskOutput";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onEnd";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSuccess";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFailure";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeCancel";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCancel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

