/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.service.AbstractExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class RemoteExternalSystemFacadeImpl<S extends ExternalSystemExecutionSettings>
extends AbstractExternalSystemFacadeImpl<S> {
    private static final long f = TimeUnit.MILLISECONDS.convert(3L, TimeUnit.MINUTES);
    private final AtomicInteger i;
    private Future<?> j;
    private final AtomicLong h;
    private volatile boolean g;

    public RemoteExternalSystemFacadeImpl(@NotNull Class<ExternalSystemProjectResolver<S>> clazz, @NotNull Class<ExternalSystemTaskManager<S>> clazz2) throws IllegalAccessException, InstantiationException {
        if (clazz == null) {
            RemoteExternalSystemFacadeImpl.b(0);
        }
        if (clazz2 == null) {
            RemoteExternalSystemFacadeImpl.b(1);
        }
        super(clazz, clazz2);
        this.i = new AtomicInteger();
        this.j = CompletableFuture.completedFuture(null);
        this.h = new AtomicLong(f);
        this.b();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Can't create external system facade. Reason: given arguments don't contain information about external system resolver to use");
        }
        Class clazz = Class.forName(stringArray[0]);
        if (!ExternalSystemProjectResolver.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("Can't create external system facade. Reason: given external system resolver class (%s) must be IS-A '%s'", clazz, ExternalSystemProjectResolver.class));
        }
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Can't create external system facade. Reason: given arguments don't contain information about external system build manager to use");
        }
        Class clazz2 = Class.forName(stringArray[1]);
        if (!ExternalSystemProjectResolver.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("Can't create external system facade. Reason: given external system build manager (%s) must be IS-A '%s'", clazz2, ExternalSystemTaskManager.class));
        }
        Registry.get((String)(System.getProperty("external.system.id") + ".system.in.process")).setValue(false);
        RemoteExternalSystemFacadeImpl remoteExternalSystemFacadeImpl = new RemoteExternalSystemFacadeImpl(clazz, clazz2);
        remoteExternalSystemFacadeImpl.init();
        RemoteExternalSystemFacadeImpl.start(remoteExternalSystemFacadeImpl);
    }

    @Override
    protected <I extends RemoteExternalSystemService<S>, C extends I> I createService(@NotNull Class<I> clazz, @NotNull C c2) throws RemoteException {
        if (clazz == null) {
            RemoteExternalSystemFacadeImpl.b(2);
        }
        if (c2 == null) {
            RemoteExternalSystemFacadeImpl.b(3);
        }
        if (!this.g) {
            this.g = true;
            System.setOut(new LineAwarePrintStream(System.out));
            System.setErr(new LineAwarePrintStream(System.err));
        }
        RemoteExternalSystemService remoteExternalSystemService = (RemoteExternalSystemService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, new InvocationHandler((RemoteExternalSystemService)c2){
            final /* synthetic */ RemoteExternalSystemService val$impl;
            {
                this.val$impl = remoteExternalSystemService;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                RemoteExternalSystemFacadeImpl.this.i.incrementAndGet();
                try {
                    Object object2 = method.invoke((Object)this.val$impl, objectArray);
                    return object2;
                }
                finally {
                    RemoteExternalSystemFacadeImpl.this.i.decrementAndGet();
                    RemoteExternalSystemFacadeImpl.this.b();
                }
            }
        });
        return (I)((RemoteExternalSystemService)UnicastRemoteObject.exportObject((Remote)remoteExternalSystemService, 0));
    }

    @Override
    public void applySettings(@NotNull S s2) throws RemoteException {
        if (s2 == null) {
            RemoteExternalSystemFacadeImpl.b(4);
        }
        super.applySettings(s2);
        long l2 = s2.getRemoteProcessIdleTtlInMs();
        if (l2 > 0L) {
            this.h.set(l2);
        }
    }

    private void b() {
        this.j.cancel(false);
        this.j = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            if (this.i.get() > 0) {
                this.b();
                return;
            }
            System.exit(0);
        }, (long)((int)this.h.get()), TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildManagerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applySettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LineAwarePrintStream
    extends PrintStream {
        private LineAwarePrintStream(final @NotNull PrintStream printStream) {
            if (printStream == null) {
                LineAwarePrintStream.a(0);
            }
            super(new OutputStream(){
                @NotNull
                private final StringBuilder a = new StringBuilder();

                @Override
                public void write(int n2) {
                    char c2 = (char)n2;
                    this.a.append(Character.toString(c2));
                    if (c2 == '\n') {
                        this.a();
                    }
                }

                @Override
                public void write(byte[] byArray, int n2, int n3) {
                    int n4 = n2;
                    int n5 = n2 + n3;
                    for (int i2 = n2; i2 < n5; ++i2) {
                        if (byArray[i2] != 10) continue;
                        this.a.append(new String(byArray, n4, i2 - n4 + 1));
                        this.a();
                        n4 = i2 + 1;
                    }
                    if (n4 < n5) {
                        this.a.append(new String(byArray, n4, n5 - n4));
                    }
                }

                private void a() {
                    printStream.print(this.a.toString());
                    printStream.flush();
                    this.a.setLength(0);
                }
            });
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl$LineAwarePrintStream", "<init>"));
        }
    }
}

