/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildView;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestRunnableState;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0015J\b\u0010\u0010\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskRunner;", "Lcom/intellij/execution/runners/GenericProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "doExecute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getRunnerId", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemTaskRunner
extends GenericProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "ExternalSystemTaskRunner";
    }

    public boolean canRun(@NotNull String string, @NotNull RunProfile runProfile) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)runProfile, (String)"profile");
        return runProfile instanceof ExternalSystemRunConfiguration && Intrinsics.areEqual((Object)DefaultRunExecutor.EXECUTOR_ID, (Object)string);
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState runProfileState, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)runProfileState, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)executionEnvironment, (String)"environment");
        if (!(runProfileState instanceof ExternalSystemRunConfiguration.MyRunnableState) && !(runProfileState instanceof ImportedTestRunnableState)) {
            return null;
        }
        ExecutionResult executionResult = runProfileState.execute(executionEnvironment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            return null;
        }
        ExecutionResult executionResult2 = executionResult;
        RunContentDescriptor runContentDescriptor = new RunContentBuilder(executionResult2, executionEnvironment).showRunContent(executionEnvironment.getContentToReuse());
        if (runContentDescriptor == null) {
            return null;
        }
        RunContentDescriptor runContentDescriptor2 = runContentDescriptor;
        if (runProfileState instanceof ImportedTestRunnableState) {
            return runContentDescriptor2;
        }
        ((ExternalSystemRunConfiguration.MyRunnableState)runProfileState).setContentDescriptor(runContentDescriptor2);
        ExecutionResult executionResult3 = executionResult2;
        Intrinsics.checkExpressionValueIsNotNull((Object)executionResult3, (String)"executionResult");
        if (executionResult3.getExecutionConsole() instanceof BuildView) {
            return runContentDescriptor2;
        }
        RunContentDescriptor runContentDescriptor3 = new RunContentDescriptor(runContentDescriptor2, runContentDescriptor2.getExecutionConsole(), runContentDescriptor2.getProcessHandler(), runContentDescriptor2.getComponent(), runContentDescriptor2.getDisplayName(), runContentDescriptor2.getIcon(), null, runContentDescriptor2.getRestartActions()){
            final /* synthetic */ RunContentDescriptor $runContentDescriptor;

            public boolean isHiddenContent() {
                return true;
            }
            {
                this.$runContentDescriptor = runContentDescriptor;
                super(executionConsole, processHandler, jComponent, string, icon, runnable, anActionArray);
            }
        };
        runContentDescriptor3.setRunnerLayoutUi(runContentDescriptor2.getRunnerLayoutUi());
        return runContentDescriptor3;
    }
}

