/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.NotSupportedException;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemTask
extends UserDataHolderBase
implements ExternalSystemTask {
    private static final Logger g = Logger.getInstance(AbstractExternalSystemTask.class);
    private final AtomicReference<ExternalSystemTaskState> c;
    private final AtomicReference<Throwable> f;
    @NotNull
    private final transient Project e;
    @NotNull
    private final ExternalSystemTaskId a;
    @NotNull
    private final ProjectSystemId d;
    @NotNull
    private final String b;

    protected AbstractExternalSystemTask(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType externalSystemTaskType, @NotNull Project project2, @NotNull String string) {
        if (projectSystemId == null) {
            AbstractExternalSystemTask.a(0);
        }
        if (externalSystemTaskType == null) {
            AbstractExternalSystemTask.a(1);
        }
        if (project2 == null) {
            AbstractExternalSystemTask.a(2);
        }
        if (string == null) {
            AbstractExternalSystemTask.a(3);
        }
        this.c = new AtomicReference<ExternalSystemTaskState>(ExternalSystemTaskState.NOT_STARTED);
        this.f = new AtomicReference();
        this.d = projectSystemId;
        this.e = project2;
        this.a = ExternalSystemTaskId.create((ProjectSystemId)projectSystemId, (ExternalSystemTaskType)externalSystemTaskType, (Project)this.e);
        this.b = string;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.d;
        if (projectSystemId == null) {
            AbstractExternalSystemTask.a(4);
        }
        return projectSystemId;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        ExternalSystemTaskId externalSystemTaskId = this.a;
        if (externalSystemTaskId == null) {
            AbstractExternalSystemTask.a(5);
        }
        return externalSystemTaskId;
    }

    @NotNull
    public ExternalSystemTaskState getState() {
        ExternalSystemTaskState externalSystemTaskState = this.c.get();
        if (externalSystemTaskState == null) {
            AbstractExternalSystemTask.a(6);
        }
        return externalSystemTaskState;
    }

    protected void setState(@NotNull ExternalSystemTaskState externalSystemTaskState) {
        if (externalSystemTaskState == null) {
            AbstractExternalSystemTask.a(7);
        }
        this.c.set(externalSystemTaskState);
    }

    protected boolean compareAndSetState(@NotNull ExternalSystemTaskState externalSystemTaskState, @NotNull ExternalSystemTaskState externalSystemTaskState2) {
        if (externalSystemTaskState == null) {
            AbstractExternalSystemTask.a(8);
        }
        if (externalSystemTaskState2 == null) {
            AbstractExternalSystemTask.a(9);
        }
        return this.c.compareAndSet(externalSystemTaskState, externalSystemTaskState2);
    }

    public Throwable getError() {
        return this.f.get();
    }

    @NotNull
    public Project getIdeProject() {
        Project project2 = this.e;
        if (project2 == null) {
            AbstractExternalSystemTask.a(10);
        }
        return project2;
    }

    @NotNull
    public String getExternalProjectPath() {
        String string = this.b;
        if (string == null) {
            AbstractExternalSystemTask.a(11);
        }
        return string;
    }

    public void refreshState() {
        block3: {
            if (this.getState() != ExternalSystemTaskState.IN_PROGRESS) {
                return;
            }
            ExternalSystemFacadeManager externalSystemFacadeManager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            try {
                RemoteExternalSystemFacade remoteExternalSystemFacade = externalSystemFacadeManager.getFacade(this.e, this.b, this.d);
                this.setState(remoteExternalSystemFacade.isTaskInProgress(this.getId()) ? ExternalSystemTaskState.IN_PROGRESS : ExternalSystemTaskState.FAILED);
            }
            catch (Throwable throwable) {
                this.setState(ExternalSystemTaskState.FAILED);
                this.f.set(throwable);
                if (this.e.isDisposed()) break block3;
                g.warn(throwable);
            }
        }
    }

    public void execute(final @NotNull ProgressIndicator progressIndicator, ExternalSystemTaskNotificationListener ... externalSystemTaskNotificationListenerArray) {
        if (progressIndicator == null) {
            AbstractExternalSystemTask.a(12);
        }
        if (externalSystemTaskNotificationListenerArray == null) {
            AbstractExternalSystemTask.a(13);
        }
        progressIndicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent) {
                if (externalSystemTaskNotificationEvent == null) {
                    1.a(0);
                }
                if (externalSystemTaskNotificationEvent instanceof ExternalSystemTaskExecutionEvent && ((ExternalSystemTaskExecutionEvent)externalSystemTaskNotificationEvent).getProgressEvent() instanceof ExternalSystemStatusEvent) {
                    String string;
                    ExternalSystemStatusEvent externalSystemStatusEvent = (ExternalSystemStatusEvent)((ExternalSystemTaskExecutionEvent)externalSystemTaskNotificationEvent).getProgressEvent();
                    if (externalSystemStatusEvent.getTotal() <= 0L) {
                        progressIndicator.setIndeterminate(true);
                        string = "bytes".equals(externalSystemStatusEvent.getUnit()) ? StringUtil.formatFileSize((long)externalSystemStatusEvent.getProgress()) + " / ?" : "";
                    } else {
                        progressIndicator.setIndeterminate(false);
                        progressIndicator.setFraction((double)externalSystemStatusEvent.getProgress() / (double)externalSystemStatusEvent.getTotal());
                        string = "bytes".equals(externalSystemStatusEvent.getUnit()) ? StringUtil.formatFileSize((long)externalSystemStatusEvent.getProgress()) + " / " + StringUtil.formatFileSize((long)externalSystemStatusEvent.getTotal()) : "";
                    }
                    String string2 = externalSystemTaskNotificationEvent.getDescription();
                    progressIndicator.setText(AbstractExternalSystemTask.this.wrapProgressText(string2) + (string.isEmpty() ? "" : "  (" + string + ')'));
                } else {
                    progressIndicator.setIndeterminate(true);
                    progressIndicator.setText(AbstractExternalSystemTask.this.wrapProgressText(externalSystemTaskNotificationEvent.getDescription()));
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$1", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] externalSystemTaskNotificationListenerArray2 = externalSystemTaskNotificationListenerArray.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])externalSystemTaskNotificationListenerArray, (Object)externalSystemTaskNotificationListenerAdapter) : new ExternalSystemTaskNotificationListener[]{externalSystemTaskNotificationListenerAdapter};
        this.execute(externalSystemTaskNotificationListenerArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExternalSystemTaskNotificationListener ... externalSystemTaskNotificationListenerArray) {
        if (externalSystemTaskNotificationListenerArray == null) {
            AbstractExternalSystemTask.a(14);
        }
        if (!this.compareAndSetState(ExternalSystemTaskState.NOT_STARTED, ExternalSystemTaskState.IN_PROGRESS)) {
            return;
        }
        ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : externalSystemTaskNotificationListenerArray) {
            externalSystemProgressNotificationManager.addNotificationListener(this.getId(), externalSystemTaskNotificationListener);
        }
        ExternalSystemProcessingManager externalSystemProcessingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        try {
            externalSystemProcessingManager.add(this);
            this.doExecute();
            this.setState(ExternalSystemTaskState.FINISHED);
        }
        catch (Throwable throwable) {
            this.setState(ExternalSystemTaskState.FAILED);
            this.f.set(throwable);
            g.warn(throwable);
        }
        finally {
            for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : externalSystemTaskNotificationListenerArray) {
                externalSystemProgressNotificationManager.removeNotificationListener(externalSystemTaskNotificationListener);
            }
            externalSystemProcessingManager.release(this.getId());
        }
    }

    protected abstract void doExecute() throws Exception;

    public boolean cancel(final @NotNull ProgressIndicator progressIndicator, ExternalSystemTaskNotificationListener ... externalSystemTaskNotificationListenerArray) {
        if (progressIndicator == null) {
            AbstractExternalSystemTask.a(15);
        }
        if (externalSystemTaskNotificationListenerArray == null) {
            AbstractExternalSystemTask.a(16);
        }
        progressIndicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent) {
                if (externalSystemTaskNotificationEvent == null) {
                    2.a(0);
                }
                progressIndicator.setText(AbstractExternalSystemTask.this.wrapProgressText(externalSystemTaskNotificationEvent.getDescription()));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$2", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] externalSystemTaskNotificationListenerArray2 = externalSystemTaskNotificationListenerArray.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])externalSystemTaskNotificationListenerArray, (Object)externalSystemTaskNotificationListenerAdapter) : new ExternalSystemTaskNotificationListener[]{externalSystemTaskNotificationListenerAdapter};
        return this.cancel(externalSystemTaskNotificationListenerArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(ExternalSystemTaskNotificationListener ... externalSystemTaskNotificationListenerArray) {
        ExternalSystemTaskState externalSystemTaskState;
        if (externalSystemTaskNotificationListenerArray == null) {
            AbstractExternalSystemTask.a(17);
        }
        if ((externalSystemTaskState = this.getState()).isStopped()) {
            return true;
        }
        ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : externalSystemTaskNotificationListenerArray) {
            externalSystemProgressNotificationManager.addNotificationListener(this.getId(), externalSystemTaskNotificationListener);
        }
        if (!this.compareAndSetState(externalSystemTaskState, ExternalSystemTaskState.CANCELING)) {
            return false;
        }
        int n2 = 0;
        try {
            int n3 = n2 = this.doCancel();
            return n3 != 0;
        }
        catch (NotSupportedException notSupportedException) {
            NotificationData notificationData = new NotificationData("Cancellation failed", notSupportedException.getMessage(), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            notificationData.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance(this.getIdeProject()).showNotification(this.getExternalSystemId(), notificationData);
        }
        catch (Throwable throwable) {
            this.setState(ExternalSystemTaskState.CANCELLATION_FAILED);
            this.f.set(throwable);
            g.warn(throwable);
        }
        finally {
            for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : externalSystemTaskNotificationListenerArray) {
                externalSystemProgressNotificationManager.removeNotificationListener(externalSystemTaskNotificationListener);
            }
        }
        return n2 != 0;
    }

    protected abstract boolean doCancel() throws Exception;

    @NotNull
    protected String wrapProgressText(@NotNull String string) {
        if (string == null) {
            AbstractExternalSystemTask.a(18);
        }
        String string2 = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId(), string});
        if (string2 == null) {
            AbstractExternalSystemTask.a(19);
        }
        return string2;
    }

    public int hashCode() {
        return this.a.hashCode() + this.d.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        AbstractExternalSystemTask abstractExternalSystemTask = (AbstractExternalSystemTask)((Object)object);
        return this.a.equals((Object)abstractExternalSystemTask.a) && this.d.equals((Object)abstractExternalSystemTask.d);
    }

    public String toString() {
        return String.format("%s task %s: %s", this.d.getReadableName(), this.a, this.c);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetState";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

