/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessingManager
implements ExternalSystemTaskNotificationListener,
Disposable {
    private static final long e = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, Long> a;
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, ExternalSystemTask> c;
    @NotNull
    private final Alarm b;
    @NotNull
    private final ExternalSystemFacadeManager f;
    @NotNull
    private final ExternalSystemProgressNotificationManager d;

    public ExternalSystemProcessingManager(@NotNull ExternalSystemFacadeManager externalSystemFacadeManager, @NotNull ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager) {
        if (externalSystemFacadeManager == null) {
            ExternalSystemProcessingManager.a(0);
        }
        if (externalSystemProgressNotificationManager == null) {
            ExternalSystemProcessingManager.a(1);
        }
        this.a = ContainerUtil.newConcurrentMap();
        this.c = ContainerUtil.newConcurrentMap();
        this.b = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.f = externalSystemFacadeManager;
        this.d = externalSystemProgressNotificationManager;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        externalSystemProgressNotificationManager.addNotificationListener(this);
    }

    public void dispose() {
        this.d.removeNotificationListener(this);
        this.b.cancelAllRequests();
    }

    public boolean hasTaskOfTypeInProgress(@NotNull ExternalSystemTaskType externalSystemTaskType, @NotNull Project project2) {
        if (externalSystemTaskType == null) {
            ExternalSystemProcessingManager.a(2);
        }
        if (project2 == null) {
            ExternalSystemProcessingManager.a(3);
        }
        String string = ExternalSystemTaskId.getProjectId((Project)project2);
        for (ExternalSystemTaskId externalSystemTaskId : this.a.keySet()) {
            if (!externalSystemTaskType.equals((Object)externalSystemTaskId.getType()) || !string.equals(externalSystemTaskId.getIdeProjectId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskType externalSystemTaskType, @NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        if (externalSystemTaskType == null) {
            ExternalSystemProcessingManager.a(4);
        }
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.a(5);
        }
        if (string == null) {
            ExternalSystemProcessingManager.a(6);
        }
        for (ExternalSystemTask externalSystemTask : this.c.values()) {
            AbstractExternalSystemTask abstractExternalSystemTask;
            if (!(externalSystemTask instanceof AbstractExternalSystemTask) || (abstractExternalSystemTask = (AbstractExternalSystemTask)externalSystemTask).getId().getType() != externalSystemTaskType || !abstractExternalSystemTask.getExternalSystemId().getId().equals(projectSystemId.getId()) || !abstractExternalSystemTask.getExternalProjectPath().equals(string)) continue;
            return externalSystemTask;
        }
        return null;
    }

    @NotNull
    public List<ExternalSystemTask> findTasksOfState(@NotNull ProjectSystemId projectSystemId, ExternalSystemTaskState ... externalSystemTaskStateArray) {
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.a(7);
        }
        if (externalSystemTaskStateArray == null) {
            ExternalSystemProcessingManager.a(8);
        }
        SmartList smartList = new SmartList();
        for (ExternalSystemTask externalSystemTask : this.c.values()) {
            AbstractExternalSystemTask abstractExternalSystemTask;
            if (!(externalSystemTask instanceof AbstractExternalSystemTask) || !(abstractExternalSystemTask = (AbstractExternalSystemTask)externalSystemTask).getExternalSystemId().getId().equals(projectSystemId.getId()) || !ArrayUtil.contains((Object)abstractExternalSystemTask.getState(), (Object[])externalSystemTaskStateArray)) continue;
            smartList.add(externalSystemTask);
        }
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            ExternalSystemProcessingManager.a(9);
        }
        return smartList2;
    }

    public void add(@NotNull ExternalSystemTask externalSystemTask) {
        if (externalSystemTask == null) {
            ExternalSystemProcessingManager.a(10);
        }
        this.c.put(externalSystemTask.getId(), externalSystemTask);
    }

    public void release(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(11);
        }
        this.c.remove(externalSystemTaskId);
    }

    public void onQueued(@NotNull ExternalSystemTaskId externalSystemTaskId, String string) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(12);
        }
        this.onStart(externalSystemTaskId, string);
    }

    public void onStart(@NotNull ExternalSystemTaskId externalSystemTaskId, String string) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(13);
        }
        this.a.put(externalSystemTaskId, System.currentTimeMillis() + e);
        if (this.b.getActiveRequestCount() <= 0) {
            this.b.addRequest(() -> this.update(), e);
        }
    }

    public void onStart(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(14);
        }
        this.a.put(externalSystemTaskId, System.currentTimeMillis() + e);
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent) {
        if (externalSystemTaskNotificationEvent == null) {
            ExternalSystemProcessingManager.a(15);
        }
        this.a.put(externalSystemTaskNotificationEvent.getId(), System.currentTimeMillis() + e);
    }

    public void onTaskOutput(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String string, boolean bl2) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(16);
        }
        if (string == null) {
            ExternalSystemProcessingManager.a(17);
        }
        this.a.put(externalSystemTaskId, System.currentTimeMillis() + e);
    }

    public void onEnd(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(18);
        }
        this.a.remove(externalSystemTaskId);
        if (this.a.isEmpty()) {
            this.b.cancelAllRequests();
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(19);
        }
    }

    public void onFailure(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull Exception exception) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(20);
        }
        if (exception == null) {
            ExternalSystemProcessingManager.a(21);
        }
    }

    public void beforeCancel(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(22);
        }
    }

    public void onCancel(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemProcessingManager.a(23);
        }
    }

    public void update() {
        long l2 = e;
        HashMap hashMap = ContainerUtilRt.newHashMap();
        HashMap hashMap2 = ContainerUtilRt.newHashMap(this.a);
        if (hashMap2.isEmpty()) {
            return;
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            long l3 = System.currentTimeMillis() - (Long)entry.getValue();
            if (l3 > 0L) {
                l2 = Math.min(l2, l3);
                hashMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.f.isTaskActive((ExternalSystemTaskId)entry.getKey())) continue;
            hashMap.put(entry.getKey(), System.currentTimeMillis() + e);
        }
        this.a.clear();
        this.a.putAll(hashMap);
        if (!hashMap.isEmpty()) {
            this.b.cancelAllRequests();
            this.b.addRequest(() -> this.update(), l2);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facadeManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskStates";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksOfState";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasTaskOfTypeInProgress";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTasksOfState";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onQueued";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onStatusChange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onTaskOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onEnd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onFailure";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "beforeCancel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onCancel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

