/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.MessageCounter;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemNotificationManager
implements Disposable {
    @NotNull
    private static final Key<Pair<NotificationSource, ProjectSystemId>> c = Key.create((String)"CONTENT_ID");
    @NotNull
    private final MergingUpdateQueue a;
    @Nullable
    private volatile Project d;
    @NotNull
    private final Set<Notification> g;
    @NotNull
    private final Map<Key, Notification> f;
    @NotNull
    private final Set<ProjectSystemId> e;
    @NotNull
    private final MessageCounter b;

    public ExternalSystemNotificationManager(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemNotificationManager.a(0);
        }
        this.d = project2;
        this.g = ContainerUtil.newConcurrentSet();
        this.f = ContainerUtil.newConcurrentMap();
        this.e = ContainerUtil.newConcurrentSet();
        this.b = new MessageCounter();
        this.a = new MergingUpdateQueue(this.getClass() + " updates", 500, true, null, (Disposable)this, null, false);
    }

    @NotNull
    public static ExternalSystemNotificationManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemNotificationManager.a(1);
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = (ExternalSystemNotificationManager)ServiceManager.getService((Project)project2, ExternalSystemNotificationManager.class);
        if (externalSystemNotificationManager == null) {
            ExternalSystemNotificationManager.a(2);
        }
        return externalSystemNotificationManager;
    }

    public void processExternalProjectRefreshError(@NotNull Throwable throwable, @NotNull String string, @NotNull ProjectSystemId projectSystemId) {
        if (throwable == null) {
            ExternalSystemNotificationManager.a(3);
        }
        if (string == null) {
            ExternalSystemNotificationManager.a(4);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(5);
        }
        if (this.a()) {
            return;
        }
        Project project2 = this.d;
        assert (project2 != null);
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        if (!(externalSystemManager instanceof ExternalSystemConfigurableAware)) {
            return;
        }
        NotificationData notificationData = this.createNotification(throwable, string, projectSystemId, project2);
        EditorNotifications.getInstance((Project)project2).updateAllNotifications();
        this.showNotification(projectSystemId, notificationData);
    }

    @NotNull
    public NotificationData createNotification(@NotNull Throwable throwable, @NotNull String string, @NotNull ProjectSystemId projectSystemId, @NotNull Project project2) {
        if (throwable == null) {
            ExternalSystemNotificationManager.a(6);
        }
        if (string == null) {
            ExternalSystemNotificationManager.a(7);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(8);
        }
        if (project2 == null) {
            ExternalSystemNotificationManager.a(9);
        }
        String string2 = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{projectSystemId.getReadableName(), string});
        NotificationData notificationData = this.createNotification(string2, throwable, projectSystemId, project2);
        if (notificationData == null) {
            ExternalSystemNotificationManager.a(10);
        }
        return notificationData;
    }

    @NotNull
    public NotificationData createNotification(@NotNull String string, @NotNull Throwable throwable, @NotNull ProjectSystemId projectSystemId, @NotNull Project project2) {
        Object object;
        if (string == null) {
            ExternalSystemNotificationManager.a(11);
        }
        if (throwable == null) {
            ExternalSystemNotificationManager.a(12);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(13);
        }
        if (project2 == null) {
            ExternalSystemNotificationManager.a(14);
        }
        String string2 = ExternalSystemApiUtil.buildErrorMessage((Throwable)throwable);
        NotificationCategory notificationCategory = NotificationCategory.ERROR;
        String string3 = null;
        Integer n2 = null;
        Integer n3 = null;
        Throwable throwable2 = RemoteUtil.unwrap((Throwable)throwable);
        if (throwable2 instanceof LocationAwareExternalSystemException) {
            object = (LocationAwareExternalSystemException)throwable2;
            string3 = object.getFilePath();
            n2 = object.getLine();
            n3 = object.getColumn();
        }
        object = new NotificationData(string, string2, notificationCategory, NotificationSource.PROJECT_SYNC, string3, (Integer)ObjectUtils.notNull((Object)n2, (Object)-1), (Integer)ObjectUtils.notNull((Object)n3, (Object)-1), false);
        for (ExternalSystemNotificationExtension externalSystemNotificationExtension : (ExternalSystemNotificationExtension[])ExternalSystemNotificationExtension.EP_NAME.getExtensions()) {
            ProjectSystemId projectSystemId2 = externalSystemNotificationExtension.getTargetExternalSystemId();
            if (!projectSystemId.equals((Object)projectSystemId2) && !projectSystemId2.equals((Object)ProjectSystemId.IDE)) continue;
            externalSystemNotificationExtension.customize((NotificationData)object, project2, throwable);
        }
        Object object2 = object;
        if (object2 == null) {
            ExternalSystemNotificationManager.a(15);
        }
        return object2;
    }

    public boolean isNotificationActive(@NotNull Key<String> key) {
        Notification notification;
        if (key == null) {
            ExternalSystemNotificationManager.a(16);
        }
        return (notification = this.f.get(key)) != null && !notification.isExpired();
    }

    public void showNotification(@NotNull ProjectSystemId projectSystemId, @NotNull NotificationData notificationData) {
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(17);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.a(18);
        }
        this.showNotification(projectSystemId, notificationData, null);
    }

    public void showNotification(final @NotNull ProjectSystemId projectSystemId, final @NotNull NotificationData notificationData, final @Nullable Key<String> key) {
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(19);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.a(20);
        }
        Disposer.register((Disposable)this, (Disposable)notificationData);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PrintStream printStream = notificationData.getNotificationCategory() == NotificationCategory.INFO ? System.out : System.err;
            printStream.println(notificationData.getMessage());
            return;
        }
        if (key != null && this.isNotificationActive(key)) {
            return;
        }
        this.a.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.a()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.d != null);
                Project project2 = ExternalSystemNotificationManager.this.d;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = () -> {
                    Object object;
                    Object object2;
                    if (projectSystemId == null) {
                        1.a(0);
                    }
                    if (notificationData == null) {
                        1.a(1);
                    }
                    if (!ExternalSystemNotificationManager.this.e.contains(projectSystemId)) {
                        application.runWriteAction(() -> {
                            if (projectSystemId == null) {
                                1.a(2);
                            }
                            if (ExternalSystemNotificationManager.this.a()) {
                                return;
                            }
                            ExternalSystemUtil.ensureToolWindowContentInitialized(project2, projectSystemId);
                            ExternalSystemNotificationManager.this.e.add(projectSystemId);
                        });
                    }
                    if (ExternalSystemNotificationManager.this.a()) {
                        return;
                    }
                    if (notificationData.getBalloonGroup() == null) {
                        object2 = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(projectSystemId);
                        object = object2 instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)object2).getNotificationGroup() : null;
                    } else {
                        object2 = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup());
                        Object object3 = object = object2 != null ? object2 : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup());
                    }
                    if (object == null) {
                        return;
                    }
                    object2 = object.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
                    if (key == null) {
                        ExternalSystemNotificationManager.this.g.add(object2);
                    } else {
                        Notification notification = (Notification)ExternalSystemNotificationManager.this.f.put(key, object2);
                        if (notification != null) {
                            notification.expire();
                        }
                    }
                    if (notificationData.isBalloonNotification()) {
                        ExternalSystemNotificationManager.this.a((Notification)object2);
                    } else {
                        ExternalSystemNotificationManager.this.a((Notification)object2, projectSystemId, notificationData);
                    }
                };
                application.invokeLater(runnable, ModalityState.defaultModalityState(), project2.getDisposed());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "externalSystemId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notificationData";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void openMessageView(@NotNull ProjectSystemId projectSystemId, @NotNull NotificationSource notificationSource) {
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(21);
        }
        if (notificationSource == null) {
            ExternalSystemNotificationManager.a(22);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (projectSystemId == null) {
                ExternalSystemNotificationManager.a(46);
            }
            if (notificationSource == null) {
                ExternalSystemNotificationManager.a(47);
            }
            this.prepareMessagesView(projectSystemId, notificationSource, true);
        });
    }

    public void clearNotifications(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.a(23);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(24);
        }
        this.clearNotifications(null, notificationSource, projectSystemId);
    }

    public void clearNotifications(final @Nullable String string, @NotNull NotificationSource notificationSource, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.a(25);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(26);
        }
        this.b.remove(string, notificationSource, projectSystemId);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Pair pair2 = Pair.create((Object)((Object)notificationSource), (Object)projectSystemId);
        this.a.queue(new Update(new Object()){

            public void run() {
                Notification notification;
                if (ExternalSystemNotificationManager.this.a()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.d != null);
                Project project2 = ExternalSystemNotificationManager.this.d;
                SmartList smartList = ExternalSystemNotificationManager.this.g.iterator();
                while (smartList.hasNext()) {
                    notification = (Notification)smartList.next();
                    if (string != null && !string.equals(notification.getGroupId())) continue;
                    notification.expire();
                    smartList.remove();
                }
                smartList = new SmartList();
                ExternalSystemNotificationManager.this.f.forEach((arg_0, arg_1) -> 2.a(string, (List)smartList, arg_0, arg_1));
                smartList.forEach(ExternalSystemNotificationManager.this.f::remove);
                notification = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                if (notification == null) {
                    return;
                }
                MessageView messageView = (MessageView)ServiceManager.getService((Project)project2, MessageView.class);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project2.isDisposed()) {
                        return;
                    }
                    for (Content content : messageView.getContentManager().getContents()) {
                        if (content.isPinned() || !pair2.equals(content.getUserData(c))) continue;
                        if (string == null) {
                            messageView.getContentManager().removeContent(content, true);
                            continue;
                        }
                        assert (content.getComponent() instanceof NewEditableErrorTreeViewPanel);
                        NewEditableErrorTreeViewPanel newEditableErrorTreeViewPanel = (NewEditableErrorTreeViewPanel)content.getComponent();
                        ErrorViewStructure errorViewStructure = newEditableErrorTreeViewPanel.getErrorViewStructure();
                        errorViewStructure.removeGroup(string);
                    }
                });
            }

            private static /* synthetic */ void a(@Nullable String string2, List list2, Key key, Notification notification) {
                if (string2 == null || string2.equals(notification.getGroupId())) {
                    notification.expire();
                    list2.add(key);
                }
            }
        });
    }

    public int getMessageCount(@NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.a(27);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(28);
        }
        return this.getMessageCount(null, notificationSource, notificationCategory, projectSystemId);
    }

    public int getMessageCount(@Nullable String string, @NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.a(29);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(30);
        }
        return this.b.getCount(string, notificationSource, notificationCategory, projectSystemId);
    }

    private void a(@NotNull Notification notification, @NotNull ProjectSystemId projectSystemId, @NotNull NotificationData notificationData) {
        int n2;
        if (notification == null) {
            ExternalSystemNotificationManager.a(31);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(32);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.a(33);
        }
        VirtualFile virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        String string = virtualFile != null ? virtualFile.getPresentableUrl() : notificationData.getTitle();
        this.b.increment(string, notificationData.getNotificationSource(), notificationData.getNotificationCategory(), projectSystemId);
        int n3 = notificationData.getLine() - 1;
        int n4 = notificationData.getColumn() - 1;
        if (virtualFile == null) {
            n4 = -1;
            n3 = -1;
        }
        int n5 = n3 < 0 ? -1 : n3 + 1;
        int n6 = n2 = n4 < 0 ? 0 : n4 + 1;
        if (this.a()) {
            return;
        }
        assert (this.d != null);
        Project project2 = this.d;
        Navigatable navigatable = notificationData.getNavigatable() != null ? notificationData.getNavigatable() : (virtualFile != null ? new OpenFileDescriptor(project2, virtualFile, n3, n4) : NonNavigatable.INSTANCE);
        ErrorTreeElementKind errorTreeElementKind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)notificationData.getNotificationCategory().getMessageCategory());
        String[] stringArray = notificationData.getMessage().split("\n");
        String string2 = NewErrorTreeViewPanel.createExportPrefix((int)n5);
        String string3 = NewErrorTreeViewPanel.createRendererPrefix((int)n5, (int)n2);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (notificationData == null) {
                ExternalSystemNotificationManager.a(43);
            }
            if (projectSystemId == null) {
                ExternalSystemNotificationManager.a(44);
            }
            if (notification == null) {
                ExternalSystemNotificationManager.a(45);
            }
            boolean bl2 = notificationData.getNotificationCategory() == NotificationCategory.ERROR || notificationData.getNotificationCategory() == NotificationCategory.WARNING;
            NewErrorTreeViewPanel newErrorTreeViewPanel = this.prepareMessagesView(projectSystemId, notificationData.getNotificationSource(), bl2);
            GroupingElement groupingElement = newErrorTreeViewPanel.getErrorViewStructure().getGroupingElement(string, null, virtualFile);
            NotificationMessageElement notificationMessageElement = notificationData.hasLinks() && !ScreenReader.isActive() ? new EditableNotificationMessageElement(notification, errorTreeElementKind, groupingElement, stringArray, navigatable, string2, string3) : new NotificationMessageElement(errorTreeElementKind, groupingElement, stringArray, navigatable, string2, string3);
            newErrorTreeViewPanel.getErrorViewStructure().addNavigatableMessage(string, (NavigatableMessageElement)notificationMessageElement);
            newErrorTreeViewPanel.updateTree();
        });
    }

    private void a(@NotNull Notification notification) {
        if (notification == null) {
            ExternalSystemNotificationManager.a(34);
        }
        if (!this.a()) {
            notification.notify(this.d);
        }
    }

    @NotNull
    public NewErrorTreeViewPanel prepareMessagesView(@NotNull ProjectSystemId projectSystemId, @NotNull NotificationSource notificationSource, boolean bl2) {
        NewEditableErrorTreeViewPanel newEditableErrorTreeViewPanel;
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(35);
        }
        if (notificationSource == null) {
            ExternalSystemNotificationManager.a(36);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = ExternalSystemNotificationManager.getContentDisplayName(notificationSource, projectSystemId);
        Pair pair2 = Pair.create((Object)((Object)notificationSource), (Object)projectSystemId);
        Content content = this.a((Pair<NotificationSource, ProjectSystemId>)pair2, string);
        assert (this.d != null);
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.d, MessageView.class);
        if (content == null || !pair2.equals(content.getUserData(c))) {
            newEditableErrorTreeViewPanel = new NewEditableErrorTreeViewPanel(this.d, null, true, true, null);
            content = ContentFactory.SERVICE.getInstance().createContent((JComponent)newEditableErrorTreeViewPanel, string, true);
            content.putUserData(c, (Object)pair2);
            messageView.getContentManager().addContent(content);
            Disposer.register((Disposable)content, (Disposable)newEditableErrorTreeViewPanel);
        } else {
            assert (content.getComponent() instanceof NewEditableErrorTreeViewPanel);
            newEditableErrorTreeViewPanel = (NewEditableErrorTreeViewPanel)content.getComponent();
        }
        messageView.getContentManager().setSelectedContent(content);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.d).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        if (bl2 && toolWindow != null && !toolWindow.isActive()) {
            toolWindow.activate(null, false);
        }
        NewEditableErrorTreeViewPanel newEditableErrorTreeViewPanel2 = newEditableErrorTreeViewPanel;
        if (newEditableErrorTreeViewPanel2 == null) {
            ExternalSystemNotificationManager.a(37);
        }
        return newEditableErrorTreeViewPanel2;
    }

    @Nullable
    private Content a(@NotNull Pair<NotificationSource, ProjectSystemId> pair2, @NotNull String string) {
        if (pair2 == null) {
            ExternalSystemNotificationManager.a(38);
        }
        if (string == null) {
            ExternalSystemNotificationManager.a(39);
        }
        Content content = null;
        assert (this.d != null);
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.d, MessageView.class);
        for (Content content2 : messageView.getContentManager().getContents()) {
            if (!pair2.equals(content2.getUserData(c)) || !StringUtil.equals((CharSequence)content2.getDisplayName(), (CharSequence)string) || content2.isPinned()) continue;
            content = content2;
        }
        return content;
    }

    @NotNull
    public static String getContentDisplayName(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId projectSystemId) {
        String string;
        if (notificationSource == null) {
            ExternalSystemNotificationManager.a(40);
        }
        if (projectSystemId == null) {
            ExternalSystemNotificationManager.a(41);
        }
        switch (notificationSource) {
            case PROJECT_SYNC: {
                string = ExternalSystemBundle.message((String)"notification.messages.project.sync.tab.name", (Object[])new Object[]{projectSystemId.getReadableName()});
                break;
            }
            case TASK_EXECUTION: {
                string = ExternalSystemBundle.message((String)"notification.messages.task.execution.tab.name", (Object[])new Object[]{projectSystemId.getReadableName()});
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported notification source found: " + (Object)((Object)notificationSource)));
            }
        }
        String string2 = string;
        if (string2 == null) {
            ExternalSystemNotificationManager.a(42);
        }
        return string2;
    }

    public void dispose() {
        this.d = null;
        this.g.clear();
        this.f.clear();
        this.e.clear();
    }

    private boolean a() {
        return this.d == null || this.d.isDisposed() || !this.d.isOpen();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 15: 
            case 37: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 15: 
            case 37: 
            case 42: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 15: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectName";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationKey";
                break;
            }
            case 18: 
            case 20: 
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 36: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSource";
                break;
            }
            case 31: 
            case 34: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentIdPair";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDisplayName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMessagesView";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDisplayName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 10: 
            case 15: 
            case 37: 
            case 42: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processExternalProjectRefreshError";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationActive";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "openMessageView";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "clearNotifications";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMessageCount";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "applyNotification";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "prepareMessagesView";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findContent";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getContentDisplayName";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMessage$1";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openMessageView$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 15: 
            case 37: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

